<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GIFTCARD_ACTIVATION StructType
 * @subpackage Structs
 */
class GIFTCARD_ACTIVATION extends AbstractStructBase
{
    /**
     * The MerchantID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $MerchantID;
    /**
     * The HashInfo
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \StructType\HashInput
     */
    public $HashInfo;
    /**
     * The ClientIP
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ClientIP;
    /**
     * The Program
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Program;
    /**
     * The AccountDetailInfo
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\AccountDetailInput
     */
    public $AccountDetailInfo;
    /**
     * Constructor method for GIFTCARD_ACTIVATION
     * @uses GIFTCARD_ACTIVATION::setMerchantID()
     * @uses GIFTCARD_ACTIVATION::setHashInfo()
     * @uses GIFTCARD_ACTIVATION::setClientIP()
     * @uses GIFTCARD_ACTIVATION::setProgram()
     * @uses GIFTCARD_ACTIVATION::setAccountDetailInfo()
     * @param string $merchantID
     * @param \StructType\HashInput $hashInfo
     * @param string $clientIP
     * @param string $program
     * @param \StructType\AccountDetailInput $accountDetailInfo
     */
    public function __construct($merchantID = null, \StructType\HashInput $hashInfo = null, $clientIP = null, $program = null, \StructType\AccountDetailInput $accountDetailInfo = null)
    {
        $this
            ->setMerchantID($merchantID)
            ->setHashInfo($hashInfo)
            ->setClientIP($clientIP)
            ->setProgram($program)
            ->setAccountDetailInfo($accountDetailInfo);
    }
    /**
     * Get MerchantID value
     * @return string
     */
    public function getMerchantID()
    {
        return $this->MerchantID;
    }
    /**
     * Set MerchantID value
     * @param string $merchantID
     * @return \StructType\GIFTCARD_ACTIVATION
     */
    public function setMerchantID($merchantID = null)
    {
        // validation for constraint: string
        if (!is_null($merchantID) && !is_string($merchantID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($merchantID, true), gettype($merchantID)), __LINE__);
        }
        $this->MerchantID = $merchantID;
        return $this;
    }
    /**
     * Get HashInfo value
     * @return \StructType\HashInput
     */
    public function getHashInfo()
    {
        return $this->HashInfo;
    }
    /**
     * Set HashInfo value
     * @param \StructType\HashInput $hashInfo
     * @return \StructType\GIFTCARD_ACTIVATION
     */
    public function setHashInfo(\StructType\HashInput $hashInfo = null)
    {
        $this->HashInfo = $hashInfo;
        return $this;
    }
    /**
     * Get ClientIP value
     * @return string|null
     */
    public function getClientIP()
    {
        return $this->ClientIP;
    }
    /**
     * Set ClientIP value
     * @param string $clientIP
     * @return \StructType\GIFTCARD_ACTIVATION
     */
    public function setClientIP($clientIP = null)
    {
        // validation for constraint: string
        if (!is_null($clientIP) && !is_string($clientIP)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($clientIP, true), gettype($clientIP)), __LINE__);
        }
        $this->ClientIP = $clientIP;
        return $this;
    }
    /**
     * Get Program value
     * @return string|null
     */
    public function getProgram()
    {
        return $this->Program;
    }
    /**
     * Set Program value
     * @param string $program
     * @return \StructType\GIFTCARD_ACTIVATION
     */
    public function setProgram($program = null)
    {
        // validation for constraint: string
        if (!is_null($program) && !is_string($program)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($program, true), gettype($program)), __LINE__);
        }
        $this->Program = $program;
        return $this;
    }
    /**
     * Get AccountDetailInfo value
     * @return \StructType\AccountDetailInput|null
     */
    public function getAccountDetailInfo()
    {
        return $this->AccountDetailInfo;
    }
    /**
     * Set AccountDetailInfo value
     * @param \StructType\AccountDetailInput $accountDetailInfo
     * @return \StructType\GIFTCARD_ACTIVATION
     */
    public function setAccountDetailInfo(\StructType\AccountDetailInput $accountDetailInfo = null)
    {
        $this->AccountDetailInfo = $accountDetailInfo;
        return $this;
    }
}
