<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for FINANCE_SETTLEMENT StructType
 * @subpackage Structs
 */
class FINANCE_SETTLEMENT extends AbstractStructBase
{
    /**
     * The UserID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $UserID;
    /**
     * The Password
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $Password;
    /**
     * The MerchantID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $MerchantID;
    /**
     * The HashInfo
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \StructType\HashInput
     */
    public $HashInfo;
    /**
     * Constructor method for FINANCE_SETTLEMENT
     * @uses FINANCE_SETTLEMENT::setUserID()
     * @uses FINANCE_SETTLEMENT::setPassword()
     * @uses FINANCE_SETTLEMENT::setMerchantID()
     * @uses FINANCE_SETTLEMENT::setHashInfo()
     * @param string $userID
     * @param string $password
     * @param string $merchantID
     * @param \StructType\HashInput $hashInfo
     */
    public function __construct($userID = null, $password = null, $merchantID = null, \StructType\HashInput $hashInfo = null)
    {
        $this
            ->setUserID($userID)
            ->setPassword($password)
            ->setMerchantID($merchantID)
            ->setHashInfo($hashInfo);
    }
    /**
     * Get UserID value
     * @return string
     */
    public function getUserID()
    {
        return $this->UserID;
    }
    /**
     * Set UserID value
     * @param string $userID
     * @return \StructType\FINANCE_SETTLEMENT
     */
    public function setUserID($userID = null)
    {
        // validation for constraint: string
        if (!is_null($userID) && !is_string($userID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($userID, true), gettype($userID)), __LINE__);
        }
        $this->UserID = $userID;
        return $this;
    }
    /**
     * Get Password value
     * @return string
     */
    public function getPassword()
    {
        return $this->Password;
    }
    /**
     * Set Password value
     * @param string $password
     * @return \StructType\FINANCE_SETTLEMENT
     */
    public function setPassword($password = null)
    {
        // validation for constraint: string
        if (!is_null($password) && !is_string($password)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($password, true), gettype($password)), __LINE__);
        }
        $this->Password = $password;
        return $this;
    }
    /**
     * Get MerchantID value
     * @return string
     */
    public function getMerchantID()
    {
        return $this->MerchantID;
    }
    /**
     * Set MerchantID value
     * @param string $merchantID
     * @return \StructType\FINANCE_SETTLEMENT
     */
    public function setMerchantID($merchantID = null)
    {
        // validation for constraint: string
        if (!is_null($merchantID) && !is_string($merchantID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($merchantID, true), gettype($merchantID)), __LINE__);
        }
        $this->MerchantID = $merchantID;
        return $this;
    }
    /**
     * Get HashInfo value
     * @return \StructType\HashInput
     */
    public function getHashInfo()
    {
        return $this->HashInfo;
    }
    /**
     * Set HashInfo value
     * @param \StructType\HashInput $hashInfo
     * @return \StructType\FINANCE_SETTLEMENT
     */
    public function setHashInfo(\StructType\HashInput $hashInfo = null)
    {
        $this->HashInfo = $hashInfo;
        return $this;
    }
}
