<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for FINANCE_REVERSE_AUTH StructType
 * @subpackage Structs
 */
class FINANCE_REVERSE_AUTH extends AbstractStructBase
{
    /**
     * The UserID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $UserID;
    /**
     * The Password
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $Password;
    /**
     * The MerchantID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $MerchantID;
    /**
     * The HashInfo
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \StructType\HashInput
     */
    public $HashInfo;
    /**
     * The AccountNumber
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $AccountNumber;
    /**
     * The AuthCode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $AuthCode;
    /**
     * The AuthReversalAmount
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $AuthReversalAmount;
    /**
     * The TransactionId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $TransactionId;
    /**
     * Constructor method for FINANCE_REVERSE_AUTH
     * @uses FINANCE_REVERSE_AUTH::setUserID()
     * @uses FINANCE_REVERSE_AUTH::setPassword()
     * @uses FINANCE_REVERSE_AUTH::setMerchantID()
     * @uses FINANCE_REVERSE_AUTH::setHashInfo()
     * @uses FINANCE_REVERSE_AUTH::setAccountNumber()
     * @uses FINANCE_REVERSE_AUTH::setAuthCode()
     * @uses FINANCE_REVERSE_AUTH::setAuthReversalAmount()
     * @uses FINANCE_REVERSE_AUTH::setTransactionId()
     * @param string $userID
     * @param string $password
     * @param string $merchantID
     * @param \StructType\HashInput $hashInfo
     * @param string $accountNumber
     * @param string $authCode
     * @param float $authReversalAmount
     * @param string $transactionId
     */
    public function __construct($userID = null, $password = null, $merchantID = null, \StructType\HashInput $hashInfo = null, $accountNumber = null, $authCode = null, $authReversalAmount = null, $transactionId = null)
    {
        $this
            ->setUserID($userID)
            ->setPassword($password)
            ->setMerchantID($merchantID)
            ->setHashInfo($hashInfo)
            ->setAccountNumber($accountNumber)
            ->setAuthCode($authCode)
            ->setAuthReversalAmount($authReversalAmount)
            ->setTransactionId($transactionId);
    }
    /**
     * Get UserID value
     * @return string
     */
    public function getUserID()
    {
        return $this->UserID;
    }
    /**
     * Set UserID value
     * @param string $userID
     * @return \StructType\FINANCE_REVERSE_AUTH
     */
    public function setUserID($userID = null)
    {
        // validation for constraint: string
        if (!is_null($userID) && !is_string($userID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($userID, true), gettype($userID)), __LINE__);
        }
        $this->UserID = $userID;
        return $this;
    }
    /**
     * Get Password value
     * @return string
     */
    public function getPassword()
    {
        return $this->Password;
    }
    /**
     * Set Password value
     * @param string $password
     * @return \StructType\FINANCE_REVERSE_AUTH
     */
    public function setPassword($password = null)
    {
        // validation for constraint: string
        if (!is_null($password) && !is_string($password)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($password, true), gettype($password)), __LINE__);
        }
        $this->Password = $password;
        return $this;
    }
    /**
     * Get MerchantID value
     * @return string
     */
    public function getMerchantID()
    {
        return $this->MerchantID;
    }
    /**
     * Set MerchantID value
     * @param string $merchantID
     * @return \StructType\FINANCE_REVERSE_AUTH
     */
    public function setMerchantID($merchantID = null)
    {
        // validation for constraint: string
        if (!is_null($merchantID) && !is_string($merchantID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($merchantID, true), gettype($merchantID)), __LINE__);
        }
        $this->MerchantID = $merchantID;
        return $this;
    }
    /**
     * Get HashInfo value
     * @return \StructType\HashInput
     */
    public function getHashInfo()
    {
        return $this->HashInfo;
    }
    /**
     * Set HashInfo value
     * @param \StructType\HashInput $hashInfo
     * @return \StructType\FINANCE_REVERSE_AUTH
     */
    public function setHashInfo(\StructType\HashInput $hashInfo = null)
    {
        $this->HashInfo = $hashInfo;
        return $this;
    }
    /**
     * Get AccountNumber value
     * @return string
     */
    public function getAccountNumber()
    {
        return $this->AccountNumber;
    }
    /**
     * Set AccountNumber value
     * @param string $accountNumber
     * @return \StructType\FINANCE_REVERSE_AUTH
     */
    public function setAccountNumber($accountNumber = null)
    {
        // validation for constraint: string
        if (!is_null($accountNumber) && !is_string($accountNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($accountNumber, true), gettype($accountNumber)), __LINE__);
        }
        $this->AccountNumber = $accountNumber;
        return $this;
    }
    /**
     * Get AuthCode value
     * @return string
     */
    public function getAuthCode()
    {
        return $this->AuthCode;
    }
    /**
     * Set AuthCode value
     * @param string $authCode
     * @return \StructType\FINANCE_REVERSE_AUTH
     */
    public function setAuthCode($authCode = null)
    {
        // validation for constraint: string
        if (!is_null($authCode) && !is_string($authCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($authCode, true), gettype($authCode)), __LINE__);
        }
        $this->AuthCode = $authCode;
        return $this;
    }
    /**
     * Get AuthReversalAmount value
     * @return float
     */
    public function getAuthReversalAmount()
    {
        return $this->AuthReversalAmount;
    }
    /**
     * Set AuthReversalAmount value
     * @param float $authReversalAmount
     * @return \StructType\FINANCE_REVERSE_AUTH
     */
    public function setAuthReversalAmount($authReversalAmount = null)
    {
        // validation for constraint: float
        if (!is_null($authReversalAmount) && !(is_float($authReversalAmount) || is_numeric($authReversalAmount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($authReversalAmount, true), gettype($authReversalAmount)), __LINE__);
        }
        $this->AuthReversalAmount = $authReversalAmount;
        return $this;
    }
    /**
     * Get TransactionId value
     * @return string
     */
    public function getTransactionId()
    {
        return $this->TransactionId;
    }
    /**
     * Set TransactionId value
     * @param string $transactionId
     * @return \StructType\FINANCE_REVERSE_AUTH
     */
    public function setTransactionId($transactionId = null)
    {
        // validation for constraint: string
        if (!is_null($transactionId) && !is_string($transactionId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($transactionId, true), gettype($transactionId)), __LINE__);
        }
        $this->TransactionId = $transactionId;
        return $this;
    }
}
