<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for FINANCE_AUTHORIZATION StructType
 * @subpackage Structs
 */
class FINANCE_AUTHORIZATION extends AbstractStructBase
{
    /**
     * The UserID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $UserID;
    /**
     * The Password
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $Password;
    /**
     * The MerchantID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $MerchantID;
    /**
     * The HashInfo
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \StructType\HashInput
     */
    public $HashInfo;
    /**
     * The AccountNumber
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $AccountNumber;
    /**
     * The Address1
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $Address1;
    /**
     * The Address2
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $Address2;
    /**
     * The ExpirationMonth
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $ExpirationMonth;
    /**
     * The ExpirationYear
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $ExpirationYear;
    /**
     * The PromoCode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $PromoCode;
    /**
     * The PromoDisclosure
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $PromoDisclosure;
    /**
     * The PurchaseAmount
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $PurchaseAmount;
    /**
     * The ZipCode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $ZipCode;
    /**
     * Constructor method for FINANCE_AUTHORIZATION
     * @uses FINANCE_AUTHORIZATION::setUserID()
     * @uses FINANCE_AUTHORIZATION::setPassword()
     * @uses FINANCE_AUTHORIZATION::setMerchantID()
     * @uses FINANCE_AUTHORIZATION::setHashInfo()
     * @uses FINANCE_AUTHORIZATION::setAccountNumber()
     * @uses FINANCE_AUTHORIZATION::setAddress1()
     * @uses FINANCE_AUTHORIZATION::setAddress2()
     * @uses FINANCE_AUTHORIZATION::setExpirationMonth()
     * @uses FINANCE_AUTHORIZATION::setExpirationYear()
     * @uses FINANCE_AUTHORIZATION::setPromoCode()
     * @uses FINANCE_AUTHORIZATION::setPromoDisclosure()
     * @uses FINANCE_AUTHORIZATION::setPurchaseAmount()
     * @uses FINANCE_AUTHORIZATION::setZipCode()
     * @param string $userID
     * @param string $password
     * @param string $merchantID
     * @param \StructType\HashInput $hashInfo
     * @param string $accountNumber
     * @param string $address1
     * @param string $address2
     * @param string $expirationMonth
     * @param string $expirationYear
     * @param string $promoCode
     * @param string $promoDisclosure
     * @param float $purchaseAmount
     * @param string $zipCode
     */
    public function __construct($userID = null, $password = null, $merchantID = null, \StructType\HashInput $hashInfo = null, $accountNumber = null, $address1 = null, $address2 = null, $expirationMonth = null, $expirationYear = null, $promoCode = null, $promoDisclosure = null, $purchaseAmount = null, $zipCode = null)
    {
        $this
            ->setUserID($userID)
            ->setPassword($password)
            ->setMerchantID($merchantID)
            ->setHashInfo($hashInfo)
            ->setAccountNumber($accountNumber)
            ->setAddress1($address1)
            ->setAddress2($address2)
            ->setExpirationMonth($expirationMonth)
            ->setExpirationYear($expirationYear)
            ->setPromoCode($promoCode)
            ->setPromoDisclosure($promoDisclosure)
            ->setPurchaseAmount($purchaseAmount)
            ->setZipCode($zipCode);
    }
    /**
     * Get UserID value
     * @return string
     */
    public function getUserID()
    {
        return $this->UserID;
    }
    /**
     * Set UserID value
     * @param string $userID
     * @return \StructType\FINANCE_AUTHORIZATION
     */
    public function setUserID($userID = null)
    {
        // validation for constraint: string
        if (!is_null($userID) && !is_string($userID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($userID, true), gettype($userID)), __LINE__);
        }
        $this->UserID = $userID;
        return $this;
    }
    /**
     * Get Password value
     * @return string
     */
    public function getPassword()
    {
        return $this->Password;
    }
    /**
     * Set Password value
     * @param string $password
     * @return \StructType\FINANCE_AUTHORIZATION
     */
    public function setPassword($password = null)
    {
        // validation for constraint: string
        if (!is_null($password) && !is_string($password)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($password, true), gettype($password)), __LINE__);
        }
        $this->Password = $password;
        return $this;
    }
    /**
     * Get MerchantID value
     * @return string
     */
    public function getMerchantID()
    {
        return $this->MerchantID;
    }
    /**
     * Set MerchantID value
     * @param string $merchantID
     * @return \StructType\FINANCE_AUTHORIZATION
     */
    public function setMerchantID($merchantID = null)
    {
        // validation for constraint: string
        if (!is_null($merchantID) && !is_string($merchantID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($merchantID, true), gettype($merchantID)), __LINE__);
        }
        $this->MerchantID = $merchantID;
        return $this;
    }
    /**
     * Get HashInfo value
     * @return \StructType\HashInput
     */
    public function getHashInfo()
    {
        return $this->HashInfo;
    }
    /**
     * Set HashInfo value
     * @param \StructType\HashInput $hashInfo
     * @return \StructType\FINANCE_AUTHORIZATION
     */
    public function setHashInfo(\StructType\HashInput $hashInfo = null)
    {
        $this->HashInfo = $hashInfo;
        return $this;
    }
    /**
     * Get AccountNumber value
     * @return string
     */
    public function getAccountNumber()
    {
        return $this->AccountNumber;
    }
    /**
     * Set AccountNumber value
     * @param string $accountNumber
     * @return \StructType\FINANCE_AUTHORIZATION
     */
    public function setAccountNumber($accountNumber = null)
    {
        // validation for constraint: string
        if (!is_null($accountNumber) && !is_string($accountNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($accountNumber, true), gettype($accountNumber)), __LINE__);
        }
        $this->AccountNumber = $accountNumber;
        return $this;
    }
    /**
     * Get Address1 value
     * @return string
     */
    public function getAddress1()
    {
        return $this->Address1;
    }
    /**
     * Set Address1 value
     * @param string $address1
     * @return \StructType\FINANCE_AUTHORIZATION
     */
    public function setAddress1($address1 = null)
    {
        // validation for constraint: string
        if (!is_null($address1) && !is_string($address1)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($address1, true), gettype($address1)), __LINE__);
        }
        $this->Address1 = $address1;
        return $this;
    }
    /**
     * Get Address2 value
     * @return string
     */
    public function getAddress2()
    {
        return $this->Address2;
    }
    /**
     * Set Address2 value
     * @param string $address2
     * @return \StructType\FINANCE_AUTHORIZATION
     */
    public function setAddress2($address2 = null)
    {
        // validation for constraint: string
        if (!is_null($address2) && !is_string($address2)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($address2, true), gettype($address2)), __LINE__);
        }
        $this->Address2 = $address2;
        return $this;
    }
    /**
     * Get ExpirationMonth value
     * @return string
     */
    public function getExpirationMonth()
    {
        return $this->ExpirationMonth;
    }
    /**
     * Set ExpirationMonth value
     * @param string $expirationMonth
     * @return \StructType\FINANCE_AUTHORIZATION
     */
    public function setExpirationMonth($expirationMonth = null)
    {
        // validation for constraint: string
        if (!is_null($expirationMonth) && !is_string($expirationMonth)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($expirationMonth, true), gettype($expirationMonth)), __LINE__);
        }
        $this->ExpirationMonth = $expirationMonth;
        return $this;
    }
    /**
     * Get ExpirationYear value
     * @return string
     */
    public function getExpirationYear()
    {
        return $this->ExpirationYear;
    }
    /**
     * Set ExpirationYear value
     * @param string $expirationYear
     * @return \StructType\FINANCE_AUTHORIZATION
     */
    public function setExpirationYear($expirationYear = null)
    {
        // validation for constraint: string
        if (!is_null($expirationYear) && !is_string($expirationYear)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($expirationYear, true), gettype($expirationYear)), __LINE__);
        }
        $this->ExpirationYear = $expirationYear;
        return $this;
    }
    /**
     * Get PromoCode value
     * @return string
     */
    public function getPromoCode()
    {
        return $this->PromoCode;
    }
    /**
     * Set PromoCode value
     * @param string $promoCode
     * @return \StructType\FINANCE_AUTHORIZATION
     */
    public function setPromoCode($promoCode = null)
    {
        // validation for constraint: string
        if (!is_null($promoCode) && !is_string($promoCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($promoCode, true), gettype($promoCode)), __LINE__);
        }
        $this->PromoCode = $promoCode;
        return $this;
    }
    /**
     * Get PromoDisclosure value
     * @return string
     */
    public function getPromoDisclosure()
    {
        return $this->PromoDisclosure;
    }
    /**
     * Set PromoDisclosure value
     * @param string $promoDisclosure
     * @return \StructType\FINANCE_AUTHORIZATION
     */
    public function setPromoDisclosure($promoDisclosure = null)
    {
        // validation for constraint: string
        if (!is_null($promoDisclosure) && !is_string($promoDisclosure)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($promoDisclosure, true), gettype($promoDisclosure)), __LINE__);
        }
        $this->PromoDisclosure = $promoDisclosure;
        return $this;
    }
    /**
     * Get PurchaseAmount value
     * @return float
     */
    public function getPurchaseAmount()
    {
        return $this->PurchaseAmount;
    }
    /**
     * Set PurchaseAmount value
     * @param float $purchaseAmount
     * @return \StructType\FINANCE_AUTHORIZATION
     */
    public function setPurchaseAmount($purchaseAmount = null)
    {
        // validation for constraint: float
        if (!is_null($purchaseAmount) && !(is_float($purchaseAmount) || is_numeric($purchaseAmount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($purchaseAmount, true), gettype($purchaseAmount)), __LINE__);
        }
        $this->PurchaseAmount = $purchaseAmount;
        return $this;
    }
    /**
     * Get ZipCode value
     * @return string
     */
    public function getZipCode()
    {
        return $this->ZipCode;
    }
    /**
     * Set ZipCode value
     * @param string $zipCode
     * @return \StructType\FINANCE_AUTHORIZATION
     */
    public function setZipCode($zipCode = null)
    {
        // validation for constraint: string
        if (!is_null($zipCode) && !is_string($zipCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($zipCode, true), gettype($zipCode)), __LINE__);
        }
        $this->ZipCode = $zipCode;
        return $this;
    }
}
