<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for FINANCE_APPLICATION StructType
 * @subpackage Structs
 */
class FINANCE_APPLICATION extends AbstractStructBase
{
    /**
     * The UserID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $UserID;
    /**
     * The Password
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $Password;
    /**
     * The MerchantID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $MerchantID;
    /**
     * The HashInfo
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \StructType\HashInput
     */
    public $HashInfo;
    /**
     * The AccountSecurity
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $AccountSecurity;
    /**
     * The ApplicantInfo
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \StructType\ApplicantInput
     */
    public $ApplicantInfo;
    /**
     * The MothersMaidenName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $MothersMaidenName;
    /**
     * The NearestRelPhoneNumber
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $NearestRelPhoneNumber;
    /**
     * The OperationCode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $OperationCode;
    /**
     * The OrginationCode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $OrginationCode;
    /**
     * The ProductCode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $ProductCode;
    /**
     * The PurchaseAmount
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $PurchaseAmount;
    /**
     * The CoApplicantInfo
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\ApplicantInput
     */
    public $CoApplicantInfo;
    /**
     * Constructor method for FINANCE_APPLICATION
     * @uses FINANCE_APPLICATION::setUserID()
     * @uses FINANCE_APPLICATION::setPassword()
     * @uses FINANCE_APPLICATION::setMerchantID()
     * @uses FINANCE_APPLICATION::setHashInfo()
     * @uses FINANCE_APPLICATION::setAccountSecurity()
     * @uses FINANCE_APPLICATION::setApplicantInfo()
     * @uses FINANCE_APPLICATION::setMothersMaidenName()
     * @uses FINANCE_APPLICATION::setNearestRelPhoneNumber()
     * @uses FINANCE_APPLICATION::setOperationCode()
     * @uses FINANCE_APPLICATION::setOrginationCode()
     * @uses FINANCE_APPLICATION::setProductCode()
     * @uses FINANCE_APPLICATION::setPurchaseAmount()
     * @uses FINANCE_APPLICATION::setCoApplicantInfo()
     * @param string $userID
     * @param string $password
     * @param string $merchantID
     * @param \StructType\HashInput $hashInfo
     * @param string $accountSecurity
     * @param \StructType\ApplicantInput $applicantInfo
     * @param string $mothersMaidenName
     * @param string $nearestRelPhoneNumber
     * @param string $operationCode
     * @param string $orginationCode
     * @param string $productCode
     * @param float $purchaseAmount
     * @param \StructType\ApplicantInput $coApplicantInfo
     */
    public function __construct($userID = null, $password = null, $merchantID = null, \StructType\HashInput $hashInfo = null, $accountSecurity = null, \StructType\ApplicantInput $applicantInfo = null, $mothersMaidenName = null, $nearestRelPhoneNumber = null, $operationCode = null, $orginationCode = null, $productCode = null, $purchaseAmount = null, \StructType\ApplicantInput $coApplicantInfo = null)
    {
        $this
            ->setUserID($userID)
            ->setPassword($password)
            ->setMerchantID($merchantID)
            ->setHashInfo($hashInfo)
            ->setAccountSecurity($accountSecurity)
            ->setApplicantInfo($applicantInfo)
            ->setMothersMaidenName($mothersMaidenName)
            ->setNearestRelPhoneNumber($nearestRelPhoneNumber)
            ->setOperationCode($operationCode)
            ->setOrginationCode($orginationCode)
            ->setProductCode($productCode)
            ->setPurchaseAmount($purchaseAmount)
            ->setCoApplicantInfo($coApplicantInfo);
    }
    /**
     * Get UserID value
     * @return string
     */
    public function getUserID()
    {
        return $this->UserID;
    }
    /**
     * Set UserID value
     * @param string $userID
     * @return \StructType\FINANCE_APPLICATION
     */
    public function setUserID($userID = null)
    {
        // validation for constraint: string
        if (!is_null($userID) && !is_string($userID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($userID, true), gettype($userID)), __LINE__);
        }
        $this->UserID = $userID;
        return $this;
    }
    /**
     * Get Password value
     * @return string
     */
    public function getPassword()
    {
        return $this->Password;
    }
    /**
     * Set Password value
     * @param string $password
     * @return \StructType\FINANCE_APPLICATION
     */
    public function setPassword($password = null)
    {
        // validation for constraint: string
        if (!is_null($password) && !is_string($password)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($password, true), gettype($password)), __LINE__);
        }
        $this->Password = $password;
        return $this;
    }
    /**
     * Get MerchantID value
     * @return string
     */
    public function getMerchantID()
    {
        return $this->MerchantID;
    }
    /**
     * Set MerchantID value
     * @param string $merchantID
     * @return \StructType\FINANCE_APPLICATION
     */
    public function setMerchantID($merchantID = null)
    {
        // validation for constraint: string
        if (!is_null($merchantID) && !is_string($merchantID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($merchantID, true), gettype($merchantID)), __LINE__);
        }
        $this->MerchantID = $merchantID;
        return $this;
    }
    /**
     * Get HashInfo value
     * @return \StructType\HashInput
     */
    public function getHashInfo()
    {
        return $this->HashInfo;
    }
    /**
     * Set HashInfo value
     * @param \StructType\HashInput $hashInfo
     * @return \StructType\FINANCE_APPLICATION
     */
    public function setHashInfo(\StructType\HashInput $hashInfo = null)
    {
        $this->HashInfo = $hashInfo;
        return $this;
    }
    /**
     * Get AccountSecurity value
     * @return string
     */
    public function getAccountSecurity()
    {
        return $this->AccountSecurity;
    }
    /**
     * Set AccountSecurity value
     * @param string $accountSecurity
     * @return \StructType\FINANCE_APPLICATION
     */
    public function setAccountSecurity($accountSecurity = null)
    {
        // validation for constraint: string
        if (!is_null($accountSecurity) && !is_string($accountSecurity)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($accountSecurity, true), gettype($accountSecurity)), __LINE__);
        }
        $this->AccountSecurity = $accountSecurity;
        return $this;
    }
    /**
     * Get ApplicantInfo value
     * @return \StructType\ApplicantInput
     */
    public function getApplicantInfo()
    {
        return $this->ApplicantInfo;
    }
    /**
     * Set ApplicantInfo value
     * @param \StructType\ApplicantInput $applicantInfo
     * @return \StructType\FINANCE_APPLICATION
     */
    public function setApplicantInfo(\StructType\ApplicantInput $applicantInfo = null)
    {
        $this->ApplicantInfo = $applicantInfo;
        return $this;
    }
    /**
     * Get MothersMaidenName value
     * @return string
     */
    public function getMothersMaidenName()
    {
        return $this->MothersMaidenName;
    }
    /**
     * Set MothersMaidenName value
     * @param string $mothersMaidenName
     * @return \StructType\FINANCE_APPLICATION
     */
    public function setMothersMaidenName($mothersMaidenName = null)
    {
        // validation for constraint: string
        if (!is_null($mothersMaidenName) && !is_string($mothersMaidenName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($mothersMaidenName, true), gettype($mothersMaidenName)), __LINE__);
        }
        $this->MothersMaidenName = $mothersMaidenName;
        return $this;
    }
    /**
     * Get NearestRelPhoneNumber value
     * @return string
     */
    public function getNearestRelPhoneNumber()
    {
        return $this->NearestRelPhoneNumber;
    }
    /**
     * Set NearestRelPhoneNumber value
     * @param string $nearestRelPhoneNumber
     * @return \StructType\FINANCE_APPLICATION
     */
    public function setNearestRelPhoneNumber($nearestRelPhoneNumber = null)
    {
        // validation for constraint: string
        if (!is_null($nearestRelPhoneNumber) && !is_string($nearestRelPhoneNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($nearestRelPhoneNumber, true), gettype($nearestRelPhoneNumber)), __LINE__);
        }
        $this->NearestRelPhoneNumber = $nearestRelPhoneNumber;
        return $this;
    }
    /**
     * Get OperationCode value
     * @return string
     */
    public function getOperationCode()
    {
        return $this->OperationCode;
    }
    /**
     * Set OperationCode value
     * @param string $operationCode
     * @return \StructType\FINANCE_APPLICATION
     */
    public function setOperationCode($operationCode = null)
    {
        // validation for constraint: string
        if (!is_null($operationCode) && !is_string($operationCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($operationCode, true), gettype($operationCode)), __LINE__);
        }
        $this->OperationCode = $operationCode;
        return $this;
    }
    /**
     * Get OrginationCode value
     * @return string
     */
    public function getOrginationCode()
    {
        return $this->OrginationCode;
    }
    /**
     * Set OrginationCode value
     * @param string $orginationCode
     * @return \StructType\FINANCE_APPLICATION
     */
    public function setOrginationCode($orginationCode = null)
    {
        // validation for constraint: string
        if (!is_null($orginationCode) && !is_string($orginationCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($orginationCode, true), gettype($orginationCode)), __LINE__);
        }
        $this->OrginationCode = $orginationCode;
        return $this;
    }
    /**
     * Get ProductCode value
     * @return string
     */
    public function getProductCode()
    {
        return $this->ProductCode;
    }
    /**
     * Set ProductCode value
     * @param string $productCode
     * @return \StructType\FINANCE_APPLICATION
     */
    public function setProductCode($productCode = null)
    {
        // validation for constraint: string
        if (!is_null($productCode) && !is_string($productCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($productCode, true), gettype($productCode)), __LINE__);
        }
        $this->ProductCode = $productCode;
        return $this;
    }
    /**
     * Get PurchaseAmount value
     * @return float
     */
    public function getPurchaseAmount()
    {
        return $this->PurchaseAmount;
    }
    /**
     * Set PurchaseAmount value
     * @param float $purchaseAmount
     * @return \StructType\FINANCE_APPLICATION
     */
    public function setPurchaseAmount($purchaseAmount = null)
    {
        // validation for constraint: float
        if (!is_null($purchaseAmount) && !(is_float($purchaseAmount) || is_numeric($purchaseAmount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($purchaseAmount, true), gettype($purchaseAmount)), __LINE__);
        }
        $this->PurchaseAmount = $purchaseAmount;
        return $this;
    }
    /**
     * Get CoApplicantInfo value
     * @return \StructType\ApplicantInput|null
     */
    public function getCoApplicantInfo()
    {
        return $this->CoApplicantInfo;
    }
    /**
     * Set CoApplicantInfo value
     * @param \StructType\ApplicantInput $coApplicantInfo
     * @return \StructType\FINANCE_APPLICATION
     */
    public function setCoApplicantInfo(\StructType\ApplicantInput $coApplicantInfo = null)
    {
        $this->CoApplicantInfo = $coApplicantInfo;
        return $this;
    }
}
