<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CustomerInput StructType
 * @subpackage Structs
 */
class CustomerInput extends AbstractStructBase
{
    /**
     * The PaymentMethod
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \StructType\PaymentMethodInput
     */
    public $PaymentMethod;
    /**
     * The CustomerID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $CustomerID;
    /**
     * The BillingDetailInfo
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\CustDetailInput
     */
    public $BillingDetailInfo;
    /**
     * The CustomerDescription
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $CustomerDescription;
    /**
     * Constructor method for CustomerInput
     * @uses CustomerInput::setPaymentMethod()
     * @uses CustomerInput::setCustomerID()
     * @uses CustomerInput::setBillingDetailInfo()
     * @uses CustomerInput::setCustomerDescription()
     * @param \StructType\PaymentMethodInput $paymentMethod
     * @param string $customerID
     * @param \StructType\CustDetailInput $billingDetailInfo
     * @param string $customerDescription
     */
    public function __construct(\StructType\PaymentMethodInput $paymentMethod = null, $customerID = null, \StructType\CustDetailInput $billingDetailInfo = null, $customerDescription = null)
    {
        $this
            ->setPaymentMethod($paymentMethod)
            ->setCustomerID($customerID)
            ->setBillingDetailInfo($billingDetailInfo)
            ->setCustomerDescription($customerDescription);
    }
    /**
     * Get PaymentMethod value
     * @return \StructType\PaymentMethodInput
     */
    public function getPaymentMethod()
    {
        return $this->PaymentMethod;
    }
    /**
     * Set PaymentMethod value
     * @param \StructType\PaymentMethodInput $paymentMethod
     * @return \StructType\CustomerInput
     */
    public function setPaymentMethod(\StructType\PaymentMethodInput $paymentMethod = null)
    {
        $this->PaymentMethod = $paymentMethod;
        return $this;
    }
    /**
     * Get CustomerID value
     * @return string
     */
    public function getCustomerID()
    {
        return $this->CustomerID;
    }
    /**
     * Set CustomerID value
     * @param string $customerID
     * @return \StructType\CustomerInput
     */
    public function setCustomerID($customerID = null)
    {
        // validation for constraint: string
        if (!is_null($customerID) && !is_string($customerID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($customerID, true), gettype($customerID)), __LINE__);
        }
        $this->CustomerID = $customerID;
        return $this;
    }
    /**
     * Get BillingDetailInfo value
     * @return \StructType\CustDetailInput|null
     */
    public function getBillingDetailInfo()
    {
        return $this->BillingDetailInfo;
    }
    /**
     * Set BillingDetailInfo value
     * @param \StructType\CustDetailInput $billingDetailInfo
     * @return \StructType\CustomerInput
     */
    public function setBillingDetailInfo(\StructType\CustDetailInput $billingDetailInfo = null)
    {
        $this->BillingDetailInfo = $billingDetailInfo;
        return $this;
    }
    /**
     * Get CustomerDescription value
     * @return string|null
     */
    public function getCustomerDescription()
    {
        return $this->CustomerDescription;
    }
    /**
     * Set CustomerDescription value
     * @param string $customerDescription
     * @return \StructType\CustomerInput
     */
    public function setCustomerDescription($customerDescription = null)
    {
        // validation for constraint: string
        if (!is_null($customerDescription) && !is_string($customerDescription)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($customerDescription, true), gettype($customerDescription)), __LINE__);
        }
        $this->CustomerDescription = $customerDescription;
        return $this;
    }
}
