<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CreditCardInput StructType
 * @subpackage Structs
 */
class CreditCardInput extends AbstractStructBase
{
    /**
     * The CreditCardNumber
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $CreditCardNumber;
    /**
     * The MagStripeData
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $MagStripeData;
    /**
     * The EntryMode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $EntryMode;
    /**
     * The CardExpiration
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $CardExpiration;
    /**
     * The CardCode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $CardCode;
    /**
     * The AVSZip
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $AVSZip;
    /**
     * The AVSStreetDigits
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $AVSStreetDigits;
    /**
     * The Pares
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Pares;
    /**
     * The VerifyCardAuth
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $VerifyCardAuth;
    /**
     * Constructor method for CreditCardInput
     * @uses CreditCardInput::setCreditCardNumber()
     * @uses CreditCardInput::setMagStripeData()
     * @uses CreditCardInput::setEntryMode()
     * @uses CreditCardInput::setCardExpiration()
     * @uses CreditCardInput::setCardCode()
     * @uses CreditCardInput::setAVSZip()
     * @uses CreditCardInput::setAVSStreetDigits()
     * @uses CreditCardInput::setPares()
     * @uses CreditCardInput::setVerifyCardAuth()
     * @param string $creditCardNumber
     * @param string $magStripeData
     * @param string $entryMode
     * @param string $cardExpiration
     * @param string $cardCode
     * @param string $aVSZip
     * @param string $aVSStreetDigits
     * @param string $pares
     * @param bool $verifyCardAuth
     */
    public function __construct($creditCardNumber = null, $magStripeData = null, $entryMode = null, $cardExpiration = null, $cardCode = null, $aVSZip = null, $aVSStreetDigits = null, $pares = null, $verifyCardAuth = null)
    {
        $this
            ->setCreditCardNumber($creditCardNumber)
            ->setMagStripeData($magStripeData)
            ->setEntryMode($entryMode)
            ->setCardExpiration($cardExpiration)
            ->setCardCode($cardCode)
            ->setAVSZip($aVSZip)
            ->setAVSStreetDigits($aVSStreetDigits)
            ->setPares($pares)
            ->setVerifyCardAuth($verifyCardAuth);
    }
    /**
     * Get CreditCardNumber value
     * @return string|null
     */
    public function getCreditCardNumber()
    {
        return $this->CreditCardNumber;
    }
    /**
     * Set CreditCardNumber value
     * @param string $creditCardNumber
     * @return \StructType\CreditCardInput
     */
    public function setCreditCardNumber($creditCardNumber = null)
    {
        // validation for constraint: string
        if (!is_null($creditCardNumber) && !is_string($creditCardNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($creditCardNumber, true), gettype($creditCardNumber)), __LINE__);
        }
        $this->CreditCardNumber = $creditCardNumber;
        return $this;
    }
    /**
     * Get MagStripeData value
     * @return string|null
     */
    public function getMagStripeData()
    {
        return $this->MagStripeData;
    }
    /**
     * Set MagStripeData value
     * @param string $magStripeData
     * @return \StructType\CreditCardInput
     */
    public function setMagStripeData($magStripeData = null)
    {
        // validation for constraint: string
        if (!is_null($magStripeData) && !is_string($magStripeData)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($magStripeData, true), gettype($magStripeData)), __LINE__);
        }
        $this->MagStripeData = $magStripeData;
        return $this;
    }
    /**
     * Get EntryMode value
     * @return string|null
     */
    public function getEntryMode()
    {
        return $this->EntryMode;
    }
    /**
     * Set EntryMode value
     * @param string $entryMode
     * @return \StructType\CreditCardInput
     */
    public function setEntryMode($entryMode = null)
    {
        // validation for constraint: string
        if (!is_null($entryMode) && !is_string($entryMode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($entryMode, true), gettype($entryMode)), __LINE__);
        }
        $this->EntryMode = $entryMode;
        return $this;
    }
    /**
     * Get CardExpiration value
     * @return string|null
     */
    public function getCardExpiration()
    {
        return $this->CardExpiration;
    }
    /**
     * Set CardExpiration value
     * @param string $cardExpiration
     * @return \StructType\CreditCardInput
     */
    public function setCardExpiration($cardExpiration = null)
    {
        // validation for constraint: string
        if (!is_null($cardExpiration) && !is_string($cardExpiration)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cardExpiration, true), gettype($cardExpiration)), __LINE__);
        }
        $this->CardExpiration = $cardExpiration;
        return $this;
    }
    /**
     * Get CardCode value
     * @return string|null
     */
    public function getCardCode()
    {
        return $this->CardCode;
    }
    /**
     * Set CardCode value
     * @param string $cardCode
     * @return \StructType\CreditCardInput
     */
    public function setCardCode($cardCode = null)
    {
        // validation for constraint: string
        if (!is_null($cardCode) && !is_string($cardCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cardCode, true), gettype($cardCode)), __LINE__);
        }
        $this->CardCode = $cardCode;
        return $this;
    }
    /**
     * Get AVSZip value
     * @return string|null
     */
    public function getAVSZip()
    {
        return $this->AVSZip;
    }
    /**
     * Set AVSZip value
     * @param string $aVSZip
     * @return \StructType\CreditCardInput
     */
    public function setAVSZip($aVSZip = null)
    {
        // validation for constraint: string
        if (!is_null($aVSZip) && !is_string($aVSZip)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($aVSZip, true), gettype($aVSZip)), __LINE__);
        }
        $this->AVSZip = $aVSZip;
        return $this;
    }
    /**
     * Get AVSStreetDigits value
     * @return string|null
     */
    public function getAVSStreetDigits()
    {
        return $this->AVSStreetDigits;
    }
    /**
     * Set AVSStreetDigits value
     * @param string $aVSStreetDigits
     * @return \StructType\CreditCardInput
     */
    public function setAVSStreetDigits($aVSStreetDigits = null)
    {
        // validation for constraint: string
        if (!is_null($aVSStreetDigits) && !is_string($aVSStreetDigits)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($aVSStreetDigits, true), gettype($aVSStreetDigits)), __LINE__);
        }
        $this->AVSStreetDigits = $aVSStreetDigits;
        return $this;
    }
    /**
     * Get Pares value
     * @return string|null
     */
    public function getPares()
    {
        return $this->Pares;
    }
    /**
     * Set Pares value
     * @param string $pares
     * @return \StructType\CreditCardInput
     */
    public function setPares($pares = null)
    {
        // validation for constraint: string
        if (!is_null($pares) && !is_string($pares)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($pares, true), gettype($pares)), __LINE__);
        }
        $this->Pares = $pares;
        return $this;
    }
    /**
     * Get VerifyCardAuth value
     * @return bool|null
     */
    public function getVerifyCardAuth()
    {
        return $this->VerifyCardAuth;
    }
    /**
     * Set VerifyCardAuth value
     * @param bool $verifyCardAuth
     * @return \StructType\CreditCardInput
     */
    public function setVerifyCardAuth($verifyCardAuth = null)
    {
        // validation for constraint: boolean
        if (!is_null($verifyCardAuth) && !is_bool($verifyCardAuth)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($verifyCardAuth, true), gettype($verifyCardAuth)), __LINE__);
        }
        $this->VerifyCardAuth = $verifyCardAuth;
        return $this;
    }
}
