<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ChargeDetailOutput StructType
 * @subpackage Structs
 */
class ChargeDetailOutput extends AbstractStructBase
{
    /**
     * The ApprovalIndicator
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $ApprovalIndicator;
    /**
     * The Message
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $Message;
    /**
     * The CVVIndicator
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $CVVIndicator;
    /**
     * The CVVCode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $CVVCode;
    /**
     * The AVSIndicator
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $AVSIndicator;
    /**
     * The AVSCode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $AVSCode;
    /**
     * The BatchReference
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $BatchReference;
    /**
     * The CardType
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $CardType;
    /**
     * The SettleDate
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $SettleDate;
    /**
     * The CreditCardNumber
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $CreditCardNumber;
    /**
     * The EntryMode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $EntryMode;
    /**
     * The CardExpiration
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $CardExpiration;
    /**
     * The CustomerNumber
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $CustomerNumber;
    /**
     * The Amount
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var float
     */
    public $Amount;
    /**
     * The ShippingTotal
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var float
     */
    public $ShippingTotal;
    /**
     * The TaxAmount
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var float
     */
    public $TaxAmount;
    /**
     * The OrderNumber
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $OrderNumber;
    /**
     * The AuthCode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $AuthCode;
    /**
     * The ReferenceNumber
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ReferenceNumber;
    /**
     * Constructor method for ChargeDetailOutput
     * @uses ChargeDetailOutput::setApprovalIndicator()
     * @uses ChargeDetailOutput::setMessage()
     * @uses ChargeDetailOutput::setCVVIndicator()
     * @uses ChargeDetailOutput::setCVVCode()
     * @uses ChargeDetailOutput::setAVSIndicator()
     * @uses ChargeDetailOutput::setAVSCode()
     * @uses ChargeDetailOutput::setBatchReference()
     * @uses ChargeDetailOutput::setCardType()
     * @uses ChargeDetailOutput::setSettleDate()
     * @uses ChargeDetailOutput::setCreditCardNumber()
     * @uses ChargeDetailOutput::setEntryMode()
     * @uses ChargeDetailOutput::setCardExpiration()
     * @uses ChargeDetailOutput::setCustomerNumber()
     * @uses ChargeDetailOutput::setAmount()
     * @uses ChargeDetailOutput::setShippingTotal()
     * @uses ChargeDetailOutput::setTaxAmount()
     * @uses ChargeDetailOutput::setOrderNumber()
     * @uses ChargeDetailOutput::setAuthCode()
     * @uses ChargeDetailOutput::setReferenceNumber()
     * @param string $approvalIndicator
     * @param string $message
     * @param string $cVVIndicator
     * @param string $cVVCode
     * @param string $aVSIndicator
     * @param string $aVSCode
     * @param string $batchReference
     * @param string $cardType
     * @param string $settleDate
     * @param string $creditCardNumber
     * @param string $entryMode
     * @param string $cardExpiration
     * @param string $customerNumber
     * @param float $amount
     * @param float $shippingTotal
     * @param float $taxAmount
     * @param string $orderNumber
     * @param string $authCode
     * @param string $referenceNumber
     */
    public function __construct($approvalIndicator = null, $message = null, $cVVIndicator = null, $cVVCode = null, $aVSIndicator = null, $aVSCode = null, $batchReference = null, $cardType = null, $settleDate = null, $creditCardNumber = null, $entryMode = null, $cardExpiration = null, $customerNumber = null, $amount = null, $shippingTotal = null, $taxAmount = null, $orderNumber = null, $authCode = null, $referenceNumber = null)
    {
        $this
            ->setApprovalIndicator($approvalIndicator)
            ->setMessage($message)
            ->setCVVIndicator($cVVIndicator)
            ->setCVVCode($cVVCode)
            ->setAVSIndicator($aVSIndicator)
            ->setAVSCode($aVSCode)
            ->setBatchReference($batchReference)
            ->setCardType($cardType)
            ->setSettleDate($settleDate)
            ->setCreditCardNumber($creditCardNumber)
            ->setEntryMode($entryMode)
            ->setCardExpiration($cardExpiration)
            ->setCustomerNumber($customerNumber)
            ->setAmount($amount)
            ->setShippingTotal($shippingTotal)
            ->setTaxAmount($taxAmount)
            ->setOrderNumber($orderNumber)
            ->setAuthCode($authCode)
            ->setReferenceNumber($referenceNumber);
    }
    /**
     * Get ApprovalIndicator value
     * @return string
     */
    public function getApprovalIndicator()
    {
        return $this->ApprovalIndicator;
    }
    /**
     * Set ApprovalIndicator value
     * @param string $approvalIndicator
     * @return \StructType\ChargeDetailOutput
     */
    public function setApprovalIndicator($approvalIndicator = null)
    {
        // validation for constraint: string
        if (!is_null($approvalIndicator) && !is_string($approvalIndicator)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($approvalIndicator, true), gettype($approvalIndicator)), __LINE__);
        }
        $this->ApprovalIndicator = $approvalIndicator;
        return $this;
    }
    /**
     * Get Message value
     * @return string
     */
    public function getMessage()
    {
        return $this->Message;
    }
    /**
     * Set Message value
     * @param string $message
     * @return \StructType\ChargeDetailOutput
     */
    public function setMessage($message = null)
    {
        // validation for constraint: string
        if (!is_null($message) && !is_string($message)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($message, true), gettype($message)), __LINE__);
        }
        $this->Message = $message;
        return $this;
    }
    /**
     * Get CVVIndicator value
     * @return string
     */
    public function getCVVIndicator()
    {
        return $this->CVVIndicator;
    }
    /**
     * Set CVVIndicator value
     * @param string $cVVIndicator
     * @return \StructType\ChargeDetailOutput
     */
    public function setCVVIndicator($cVVIndicator = null)
    {
        // validation for constraint: string
        if (!is_null($cVVIndicator) && !is_string($cVVIndicator)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cVVIndicator, true), gettype($cVVIndicator)), __LINE__);
        }
        $this->CVVIndicator = $cVVIndicator;
        return $this;
    }
    /**
     * Get CVVCode value
     * @return string
     */
    public function getCVVCode()
    {
        return $this->CVVCode;
    }
    /**
     * Set CVVCode value
     * @param string $cVVCode
     * @return \StructType\ChargeDetailOutput
     */
    public function setCVVCode($cVVCode = null)
    {
        // validation for constraint: string
        if (!is_null($cVVCode) && !is_string($cVVCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cVVCode, true), gettype($cVVCode)), __LINE__);
        }
        $this->CVVCode = $cVVCode;
        return $this;
    }
    /**
     * Get AVSIndicator value
     * @return string
     */
    public function getAVSIndicator()
    {
        return $this->AVSIndicator;
    }
    /**
     * Set AVSIndicator value
     * @param string $aVSIndicator
     * @return \StructType\ChargeDetailOutput
     */
    public function setAVSIndicator($aVSIndicator = null)
    {
        // validation for constraint: string
        if (!is_null($aVSIndicator) && !is_string($aVSIndicator)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($aVSIndicator, true), gettype($aVSIndicator)), __LINE__);
        }
        $this->AVSIndicator = $aVSIndicator;
        return $this;
    }
    /**
     * Get AVSCode value
     * @return string
     */
    public function getAVSCode()
    {
        return $this->AVSCode;
    }
    /**
     * Set AVSCode value
     * @param string $aVSCode
     * @return \StructType\ChargeDetailOutput
     */
    public function setAVSCode($aVSCode = null)
    {
        // validation for constraint: string
        if (!is_null($aVSCode) && !is_string($aVSCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($aVSCode, true), gettype($aVSCode)), __LINE__);
        }
        $this->AVSCode = $aVSCode;
        return $this;
    }
    /**
     * Get BatchReference value
     * @return string
     */
    public function getBatchReference()
    {
        return $this->BatchReference;
    }
    /**
     * Set BatchReference value
     * @param string $batchReference
     * @return \StructType\ChargeDetailOutput
     */
    public function setBatchReference($batchReference = null)
    {
        // validation for constraint: string
        if (!is_null($batchReference) && !is_string($batchReference)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($batchReference, true), gettype($batchReference)), __LINE__);
        }
        $this->BatchReference = $batchReference;
        return $this;
    }
    /**
     * Get CardType value
     * @return string
     */
    public function getCardType()
    {
        return $this->CardType;
    }
    /**
     * Set CardType value
     * @param string $cardType
     * @return \StructType\ChargeDetailOutput
     */
    public function setCardType($cardType = null)
    {
        // validation for constraint: string
        if (!is_null($cardType) && !is_string($cardType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cardType, true), gettype($cardType)), __LINE__);
        }
        $this->CardType = $cardType;
        return $this;
    }
    /**
     * Get SettleDate value
     * @return string
     */
    public function getSettleDate()
    {
        return $this->SettleDate;
    }
    /**
     * Set SettleDate value
     * @param string $settleDate
     * @return \StructType\ChargeDetailOutput
     */
    public function setSettleDate($settleDate = null)
    {
        // validation for constraint: string
        if (!is_null($settleDate) && !is_string($settleDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($settleDate, true), gettype($settleDate)), __LINE__);
        }
        $this->SettleDate = $settleDate;
        return $this;
    }
    /**
     * Get CreditCardNumber value
     * @return string|null
     */
    public function getCreditCardNumber()
    {
        return $this->CreditCardNumber;
    }
    /**
     * Set CreditCardNumber value
     * @param string $creditCardNumber
     * @return \StructType\ChargeDetailOutput
     */
    public function setCreditCardNumber($creditCardNumber = null)
    {
        // validation for constraint: string
        if (!is_null($creditCardNumber) && !is_string($creditCardNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($creditCardNumber, true), gettype($creditCardNumber)), __LINE__);
        }
        $this->CreditCardNumber = $creditCardNumber;
        return $this;
    }
    /**
     * Get EntryMode value
     * @return string|null
     */
    public function getEntryMode()
    {
        return $this->EntryMode;
    }
    /**
     * Set EntryMode value
     * @param string $entryMode
     * @return \StructType\ChargeDetailOutput
     */
    public function setEntryMode($entryMode = null)
    {
        // validation for constraint: string
        if (!is_null($entryMode) && !is_string($entryMode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($entryMode, true), gettype($entryMode)), __LINE__);
        }
        $this->EntryMode = $entryMode;
        return $this;
    }
    /**
     * Get CardExpiration value
     * @return string|null
     */
    public function getCardExpiration()
    {
        return $this->CardExpiration;
    }
    /**
     * Set CardExpiration value
     * @param string $cardExpiration
     * @return \StructType\ChargeDetailOutput
     */
    public function setCardExpiration($cardExpiration = null)
    {
        // validation for constraint: string
        if (!is_null($cardExpiration) && !is_string($cardExpiration)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cardExpiration, true), gettype($cardExpiration)), __LINE__);
        }
        $this->CardExpiration = $cardExpiration;
        return $this;
    }
    /**
     * Get CustomerNumber value
     * @return string|null
     */
    public function getCustomerNumber()
    {
        return $this->CustomerNumber;
    }
    /**
     * Set CustomerNumber value
     * @param string $customerNumber
     * @return \StructType\ChargeDetailOutput
     */
    public function setCustomerNumber($customerNumber = null)
    {
        // validation for constraint: string
        if (!is_null($customerNumber) && !is_string($customerNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($customerNumber, true), gettype($customerNumber)), __LINE__);
        }
        $this->CustomerNumber = $customerNumber;
        return $this;
    }
    /**
     * Get Amount value
     * @return float|null
     */
    public function getAmount()
    {
        return $this->Amount;
    }
    /**
     * Set Amount value
     * @param float $amount
     * @return \StructType\ChargeDetailOutput
     */
    public function setAmount($amount = null)
    {
        // validation for constraint: float
        if (!is_null($amount) && !(is_float($amount) || is_numeric($amount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($amount, true), gettype($amount)), __LINE__);
        }
        $this->Amount = $amount;
        return $this;
    }
    /**
     * Get ShippingTotal value
     * @return float|null
     */
    public function getShippingTotal()
    {
        return $this->ShippingTotal;
    }
    /**
     * Set ShippingTotal value
     * @param float $shippingTotal
     * @return \StructType\ChargeDetailOutput
     */
    public function setShippingTotal($shippingTotal = null)
    {
        // validation for constraint: float
        if (!is_null($shippingTotal) && !(is_float($shippingTotal) || is_numeric($shippingTotal))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($shippingTotal, true), gettype($shippingTotal)), __LINE__);
        }
        $this->ShippingTotal = $shippingTotal;
        return $this;
    }
    /**
     * Get TaxAmount value
     * @return float|null
     */
    public function getTaxAmount()
    {
        return $this->TaxAmount;
    }
    /**
     * Set TaxAmount value
     * @param float $taxAmount
     * @return \StructType\ChargeDetailOutput
     */
    public function setTaxAmount($taxAmount = null)
    {
        // validation for constraint: float
        if (!is_null($taxAmount) && !(is_float($taxAmount) || is_numeric($taxAmount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($taxAmount, true), gettype($taxAmount)), __LINE__);
        }
        $this->TaxAmount = $taxAmount;
        return $this;
    }
    /**
     * Get OrderNumber value
     * @return string|null
     */
    public function getOrderNumber()
    {
        return $this->OrderNumber;
    }
    /**
     * Set OrderNumber value
     * @param string $orderNumber
     * @return \StructType\ChargeDetailOutput
     */
    public function setOrderNumber($orderNumber = null)
    {
        // validation for constraint: string
        if (!is_null($orderNumber) && !is_string($orderNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($orderNumber, true), gettype($orderNumber)), __LINE__);
        }
        $this->OrderNumber = $orderNumber;
        return $this;
    }
    /**
     * Get AuthCode value
     * @return string|null
     */
    public function getAuthCode()
    {
        return $this->AuthCode;
    }
    /**
     * Set AuthCode value
     * @param string $authCode
     * @return \StructType\ChargeDetailOutput
     */
    public function setAuthCode($authCode = null)
    {
        // validation for constraint: string
        if (!is_null($authCode) && !is_string($authCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($authCode, true), gettype($authCode)), __LINE__);
        }
        $this->AuthCode = $authCode;
        return $this;
    }
    /**
     * Get ReferenceNumber value
     * @return string|null
     */
    public function getReferenceNumber()
    {
        return $this->ReferenceNumber;
    }
    /**
     * Set ReferenceNumber value
     * @param string $referenceNumber
     * @return \StructType\ChargeDetailOutput
     */
    public function setReferenceNumber($referenceNumber = null)
    {
        // validation for constraint: string
        if (!is_null($referenceNumber) && !is_string($referenceNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($referenceNumber, true), gettype($referenceNumber)), __LINE__);
        }
        $this->ReferenceNumber = $referenceNumber;
        return $this;
    }
}
