<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ChargeDetailInput StructType
 * @subpackage Structs
 */
class ChargeDetailInput extends AbstractStructBase
{
    /**
     * The InvoiceNumber
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $InvoiceNumber;
    /**
     * The PONumber
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $PONumber;
    /**
     * The CreditCardNumber
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $CreditCardNumber;
    /**
     * The MagStripeData
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $MagStripeData;
    /**
     * The EntryMode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $EntryMode;
    /**
     * The CardExpiration
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $CardExpiration;
    /**
     * The CardCode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $CardCode;
    /**
     * The CheckNumber
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var int
     */
    public $CheckNumber;
    /**
     * The Routing
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Routing;
    /**
     * The Account
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Account;
    /**
     * The AccountType
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $AccountType;
    /**
     * The CustomerNumber
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $CustomerNumber;
    /**
     * The Amount
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var float
     */
    public $Amount;
    /**
     * The ShippingTotal
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var float
     */
    public $ShippingTotal;
    /**
     * The ShipFromZip
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ShipFromZip;
    /**
     * The TaxAmount
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var float
     */
    public $TaxAmount;
    /**
     * The DutyAmount
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var float
     */
    public $DutyAmount;
    /**
     * The DiscountAmount
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var float
     */
    public $DiscountAmount;
    /**
     * The OrderNumber
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $OrderNumber;
    /**
     * The AVSZip
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $AVSZip;
    /**
     * The AVSStreetDigits
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $AVSStreetDigits;
    /**
     * The Description
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Description;
    /**
     * The SigData
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $SigData;
    /**
     * The CustReceipt
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $CustReceipt;
    /**
     * The CustReceiptTemplate
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $CustReceiptTemplate;
    /**
     * The IsRecurring
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $IsRecurring;
    /**
     * The Pares
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Pares;
    /**
     * The VerifyCardAuth
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $VerifyCardAuth;
    /**
     * Constructor method for ChargeDetailInput
     * @uses ChargeDetailInput::setInvoiceNumber()
     * @uses ChargeDetailInput::setPONumber()
     * @uses ChargeDetailInput::setCreditCardNumber()
     * @uses ChargeDetailInput::setMagStripeData()
     * @uses ChargeDetailInput::setEntryMode()
     * @uses ChargeDetailInput::setCardExpiration()
     * @uses ChargeDetailInput::setCardCode()
     * @uses ChargeDetailInput::setCheckNumber()
     * @uses ChargeDetailInput::setRouting()
     * @uses ChargeDetailInput::setAccount()
     * @uses ChargeDetailInput::setAccountType()
     * @uses ChargeDetailInput::setCustomerNumber()
     * @uses ChargeDetailInput::setAmount()
     * @uses ChargeDetailInput::setShippingTotal()
     * @uses ChargeDetailInput::setShipFromZip()
     * @uses ChargeDetailInput::setTaxAmount()
     * @uses ChargeDetailInput::setDutyAmount()
     * @uses ChargeDetailInput::setDiscountAmount()
     * @uses ChargeDetailInput::setOrderNumber()
     * @uses ChargeDetailInput::setAVSZip()
     * @uses ChargeDetailInput::setAVSStreetDigits()
     * @uses ChargeDetailInput::setDescription()
     * @uses ChargeDetailInput::setSigData()
     * @uses ChargeDetailInput::setCustReceipt()
     * @uses ChargeDetailInput::setCustReceiptTemplate()
     * @uses ChargeDetailInput::setIsRecurring()
     * @uses ChargeDetailInput::setPares()
     * @uses ChargeDetailInput::setVerifyCardAuth()
     * @param string $invoiceNumber
     * @param string $pONumber
     * @param string $creditCardNumber
     * @param string $magStripeData
     * @param string $entryMode
     * @param string $cardExpiration
     * @param string $cardCode
     * @param int $checkNumber
     * @param string $routing
     * @param string $account
     * @param string $accountType
     * @param string $customerNumber
     * @param float $amount
     * @param float $shippingTotal
     * @param string $shipFromZip
     * @param float $taxAmount
     * @param float $dutyAmount
     * @param float $discountAmount
     * @param string $orderNumber
     * @param string $aVSZip
     * @param string $aVSStreetDigits
     * @param string $description
     * @param string $sigData
     * @param string $custReceipt
     * @param string $custReceiptTemplate
     * @param string $isRecurring
     * @param string $pares
     * @param bool $verifyCardAuth
     */
    public function __construct($invoiceNumber = null, $pONumber = null, $creditCardNumber = null, $magStripeData = null, $entryMode = null, $cardExpiration = null, $cardCode = null, $checkNumber = null, $routing = null, $account = null, $accountType = null, $customerNumber = null, $amount = null, $shippingTotal = null, $shipFromZip = null, $taxAmount = null, $dutyAmount = null, $discountAmount = null, $orderNumber = null, $aVSZip = null, $aVSStreetDigits = null, $description = null, $sigData = null, $custReceipt = null, $custReceiptTemplate = null, $isRecurring = null, $pares = null, $verifyCardAuth = null)
    {
        $this
            ->setInvoiceNumber($invoiceNumber)
            ->setPONumber($pONumber)
            ->setCreditCardNumber($creditCardNumber)
            ->setMagStripeData($magStripeData)
            ->setEntryMode($entryMode)
            ->setCardExpiration($cardExpiration)
            ->setCardCode($cardCode)
            ->setCheckNumber($checkNumber)
            ->setRouting($routing)
            ->setAccount($account)
            ->setAccountType($accountType)
            ->setCustomerNumber($customerNumber)
            ->setAmount($amount)
            ->setShippingTotal($shippingTotal)
            ->setShipFromZip($shipFromZip)
            ->setTaxAmount($taxAmount)
            ->setDutyAmount($dutyAmount)
            ->setDiscountAmount($discountAmount)
            ->setOrderNumber($orderNumber)
            ->setAVSZip($aVSZip)
            ->setAVSStreetDigits($aVSStreetDigits)
            ->setDescription($description)
            ->setSigData($sigData)
            ->setCustReceipt($custReceipt)
            ->setCustReceiptTemplate($custReceiptTemplate)
            ->setIsRecurring($isRecurring)
            ->setPares($pares)
            ->setVerifyCardAuth($verifyCardAuth);
    }
    /**
     * Get InvoiceNumber value
     * @return string
     */
    public function getInvoiceNumber()
    {
        return $this->InvoiceNumber;
    }
    /**
     * Set InvoiceNumber value
     * @param string $invoiceNumber
     * @return \StructType\ChargeDetailInput
     */
    public function setInvoiceNumber($invoiceNumber = null)
    {
        // validation for constraint: string
        if (!is_null($invoiceNumber) && !is_string($invoiceNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($invoiceNumber, true), gettype($invoiceNumber)), __LINE__);
        }
        $this->InvoiceNumber = $invoiceNumber;
        return $this;
    }
    /**
     * Get PONumber value
     * @return string
     */
    public function getPONumber()
    {
        return $this->PONumber;
    }
    /**
     * Set PONumber value
     * @param string $pONumber
     * @return \StructType\ChargeDetailInput
     */
    public function setPONumber($pONumber = null)
    {
        // validation for constraint: string
        if (!is_null($pONumber) && !is_string($pONumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($pONumber, true), gettype($pONumber)), __LINE__);
        }
        $this->PONumber = $pONumber;
        return $this;
    }
    /**
     * Get CreditCardNumber value
     * @return string|null
     */
    public function getCreditCardNumber()
    {
        return $this->CreditCardNumber;
    }
    /**
     * Set CreditCardNumber value
     * @param string $creditCardNumber
     * @return \StructType\ChargeDetailInput
     */
    public function setCreditCardNumber($creditCardNumber = null)
    {
        // validation for constraint: string
        if (!is_null($creditCardNumber) && !is_string($creditCardNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($creditCardNumber, true), gettype($creditCardNumber)), __LINE__);
        }
        $this->CreditCardNumber = $creditCardNumber;
        return $this;
    }
    /**
     * Get MagStripeData value
     * @return string|null
     */
    public function getMagStripeData()
    {
        return $this->MagStripeData;
    }
    /**
     * Set MagStripeData value
     * @param string $magStripeData
     * @return \StructType\ChargeDetailInput
     */
    public function setMagStripeData($magStripeData = null)
    {
        // validation for constraint: string
        if (!is_null($magStripeData) && !is_string($magStripeData)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($magStripeData, true), gettype($magStripeData)), __LINE__);
        }
        $this->MagStripeData = $magStripeData;
        return $this;
    }
    /**
     * Get EntryMode value
     * @return string|null
     */
    public function getEntryMode()
    {
        return $this->EntryMode;
    }
    /**
     * Set EntryMode value
     * @param string $entryMode
     * @return \StructType\ChargeDetailInput
     */
    public function setEntryMode($entryMode = null)
    {
        // validation for constraint: string
        if (!is_null($entryMode) && !is_string($entryMode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($entryMode, true), gettype($entryMode)), __LINE__);
        }
        $this->EntryMode = $entryMode;
        return $this;
    }
    /**
     * Get CardExpiration value
     * @return string|null
     */
    public function getCardExpiration()
    {
        return $this->CardExpiration;
    }
    /**
     * Set CardExpiration value
     * @param string $cardExpiration
     * @return \StructType\ChargeDetailInput
     */
    public function setCardExpiration($cardExpiration = null)
    {
        // validation for constraint: string
        if (!is_null($cardExpiration) && !is_string($cardExpiration)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cardExpiration, true), gettype($cardExpiration)), __LINE__);
        }
        $this->CardExpiration = $cardExpiration;
        return $this;
    }
    /**
     * Get CardCode value
     * @return string|null
     */
    public function getCardCode()
    {
        return $this->CardCode;
    }
    /**
     * Set CardCode value
     * @param string $cardCode
     * @return \StructType\ChargeDetailInput
     */
    public function setCardCode($cardCode = null)
    {
        // validation for constraint: string
        if (!is_null($cardCode) && !is_string($cardCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cardCode, true), gettype($cardCode)), __LINE__);
        }
        $this->CardCode = $cardCode;
        return $this;
    }
    /**
     * Get CheckNumber value
     * @return int|null
     */
    public function getCheckNumber()
    {
        return $this->CheckNumber;
    }
    /**
     * Set CheckNumber value
     * @param int $checkNumber
     * @return \StructType\ChargeDetailInput
     */
    public function setCheckNumber($checkNumber = null)
    {
        // validation for constraint: int
        if (!is_null($checkNumber) && !(is_int($checkNumber) || ctype_digit($checkNumber))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($checkNumber, true), gettype($checkNumber)), __LINE__);
        }
        $this->CheckNumber = $checkNumber;
        return $this;
    }
    /**
     * Get Routing value
     * @return string|null
     */
    public function getRouting()
    {
        return $this->Routing;
    }
    /**
     * Set Routing value
     * @param string $routing
     * @return \StructType\ChargeDetailInput
     */
    public function setRouting($routing = null)
    {
        // validation for constraint: string
        if (!is_null($routing) && !is_string($routing)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($routing, true), gettype($routing)), __LINE__);
        }
        $this->Routing = $routing;
        return $this;
    }
    /**
     * Get Account value
     * @return string|null
     */
    public function getAccount()
    {
        return $this->Account;
    }
    /**
     * Set Account value
     * @param string $account
     * @return \StructType\ChargeDetailInput
     */
    public function setAccount($account = null)
    {
        // validation for constraint: string
        if (!is_null($account) && !is_string($account)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($account, true), gettype($account)), __LINE__);
        }
        $this->Account = $account;
        return $this;
    }
    /**
     * Get AccountType value
     * @return string|null
     */
    public function getAccountType()
    {
        return $this->AccountType;
    }
    /**
     * Set AccountType value
     * @param string $accountType
     * @return \StructType\ChargeDetailInput
     */
    public function setAccountType($accountType = null)
    {
        // validation for constraint: string
        if (!is_null($accountType) && !is_string($accountType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($accountType, true), gettype($accountType)), __LINE__);
        }
        $this->AccountType = $accountType;
        return $this;
    }
    /**
     * Get CustomerNumber value
     * @return string|null
     */
    public function getCustomerNumber()
    {
        return $this->CustomerNumber;
    }
    /**
     * Set CustomerNumber value
     * @param string $customerNumber
     * @return \StructType\ChargeDetailInput
     */
    public function setCustomerNumber($customerNumber = null)
    {
        // validation for constraint: string
        if (!is_null($customerNumber) && !is_string($customerNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($customerNumber, true), gettype($customerNumber)), __LINE__);
        }
        $this->CustomerNumber = $customerNumber;
        return $this;
    }
    /**
     * Get Amount value
     * @return float|null
     */
    public function getAmount()
    {
        return $this->Amount;
    }
    /**
     * Set Amount value
     * @param float $amount
     * @return \StructType\ChargeDetailInput
     */
    public function setAmount($amount = null)
    {
        // validation for constraint: float
        if (!is_null($amount) && !(is_float($amount) || is_numeric($amount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($amount, true), gettype($amount)), __LINE__);
        }
        $this->Amount = $amount;
        return $this;
    }
    /**
     * Get ShippingTotal value
     * @return float|null
     */
    public function getShippingTotal()
    {
        return $this->ShippingTotal;
    }
    /**
     * Set ShippingTotal value
     * @param float $shippingTotal
     * @return \StructType\ChargeDetailInput
     */
    public function setShippingTotal($shippingTotal = null)
    {
        // validation for constraint: float
        if (!is_null($shippingTotal) && !(is_float($shippingTotal) || is_numeric($shippingTotal))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($shippingTotal, true), gettype($shippingTotal)), __LINE__);
        }
        $this->ShippingTotal = $shippingTotal;
        return $this;
    }
    /**
     * Get ShipFromZip value
     * @return string|null
     */
    public function getShipFromZip()
    {
        return $this->ShipFromZip;
    }
    /**
     * Set ShipFromZip value
     * @param string $shipFromZip
     * @return \StructType\ChargeDetailInput
     */
    public function setShipFromZip($shipFromZip = null)
    {
        // validation for constraint: string
        if (!is_null($shipFromZip) && !is_string($shipFromZip)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($shipFromZip, true), gettype($shipFromZip)), __LINE__);
        }
        $this->ShipFromZip = $shipFromZip;
        return $this;
    }
    /**
     * Get TaxAmount value
     * @return float|null
     */
    public function getTaxAmount()
    {
        return $this->TaxAmount;
    }
    /**
     * Set TaxAmount value
     * @param float $taxAmount
     * @return \StructType\ChargeDetailInput
     */
    public function setTaxAmount($taxAmount = null)
    {
        // validation for constraint: float
        if (!is_null($taxAmount) && !(is_float($taxAmount) || is_numeric($taxAmount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($taxAmount, true), gettype($taxAmount)), __LINE__);
        }
        $this->TaxAmount = $taxAmount;
        return $this;
    }
    /**
     * Get DutyAmount value
     * @return float|null
     */
    public function getDutyAmount()
    {
        return $this->DutyAmount;
    }
    /**
     * Set DutyAmount value
     * @param float $dutyAmount
     * @return \StructType\ChargeDetailInput
     */
    public function setDutyAmount($dutyAmount = null)
    {
        // validation for constraint: float
        if (!is_null($dutyAmount) && !(is_float($dutyAmount) || is_numeric($dutyAmount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($dutyAmount, true), gettype($dutyAmount)), __LINE__);
        }
        $this->DutyAmount = $dutyAmount;
        return $this;
    }
    /**
     * Get DiscountAmount value
     * @return float|null
     */
    public function getDiscountAmount()
    {
        return $this->DiscountAmount;
    }
    /**
     * Set DiscountAmount value
     * @param float $discountAmount
     * @return \StructType\ChargeDetailInput
     */
    public function setDiscountAmount($discountAmount = null)
    {
        // validation for constraint: float
        if (!is_null($discountAmount) && !(is_float($discountAmount) || is_numeric($discountAmount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($discountAmount, true), gettype($discountAmount)), __LINE__);
        }
        $this->DiscountAmount = $discountAmount;
        return $this;
    }
    /**
     * Get OrderNumber value
     * @return string|null
     */
    public function getOrderNumber()
    {
        return $this->OrderNumber;
    }
    /**
     * Set OrderNumber value
     * @param string $orderNumber
     * @return \StructType\ChargeDetailInput
     */
    public function setOrderNumber($orderNumber = null)
    {
        // validation for constraint: string
        if (!is_null($orderNumber) && !is_string($orderNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($orderNumber, true), gettype($orderNumber)), __LINE__);
        }
        $this->OrderNumber = $orderNumber;
        return $this;
    }
    /**
     * Get AVSZip value
     * @return string|null
     */
    public function getAVSZip()
    {
        return $this->AVSZip;
    }
    /**
     * Set AVSZip value
     * @param string $aVSZip
     * @return \StructType\ChargeDetailInput
     */
    public function setAVSZip($aVSZip = null)
    {
        // validation for constraint: string
        if (!is_null($aVSZip) && !is_string($aVSZip)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($aVSZip, true), gettype($aVSZip)), __LINE__);
        }
        $this->AVSZip = $aVSZip;
        return $this;
    }
    /**
     * Get AVSStreetDigits value
     * @return string|null
     */
    public function getAVSStreetDigits()
    {
        return $this->AVSStreetDigits;
    }
    /**
     * Set AVSStreetDigits value
     * @param string $aVSStreetDigits
     * @return \StructType\ChargeDetailInput
     */
    public function setAVSStreetDigits($aVSStreetDigits = null)
    {
        // validation for constraint: string
        if (!is_null($aVSStreetDigits) && !is_string($aVSStreetDigits)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($aVSStreetDigits, true), gettype($aVSStreetDigits)), __LINE__);
        }
        $this->AVSStreetDigits = $aVSStreetDigits;
        return $this;
    }
    /**
     * Get Description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->Description;
    }
    /**
     * Set Description value
     * @param string $description
     * @return \StructType\ChargeDetailInput
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($description, true), gettype($description)), __LINE__);
        }
        $this->Description = $description;
        return $this;
    }
    /**
     * Get SigData value
     * @return string|null
     */
    public function getSigData()
    {
        return $this->SigData;
    }
    /**
     * Set SigData value
     * @param string $sigData
     * @return \StructType\ChargeDetailInput
     */
    public function setSigData($sigData = null)
    {
        // validation for constraint: string
        if (!is_null($sigData) && !is_string($sigData)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($sigData, true), gettype($sigData)), __LINE__);
        }
        $this->SigData = $sigData;
        return $this;
    }
    /**
     * Get CustReceipt value
     * @return string|null
     */
    public function getCustReceipt()
    {
        return $this->CustReceipt;
    }
    /**
     * Set CustReceipt value
     * @param string $custReceipt
     * @return \StructType\ChargeDetailInput
     */
    public function setCustReceipt($custReceipt = null)
    {
        // validation for constraint: string
        if (!is_null($custReceipt) && !is_string($custReceipt)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($custReceipt, true), gettype($custReceipt)), __LINE__);
        }
        $this->CustReceipt = $custReceipt;
        return $this;
    }
    /**
     * Get CustReceiptTemplate value
     * @return string|null
     */
    public function getCustReceiptTemplate()
    {
        return $this->CustReceiptTemplate;
    }
    /**
     * Set CustReceiptTemplate value
     * @param string $custReceiptTemplate
     * @return \StructType\ChargeDetailInput
     */
    public function setCustReceiptTemplate($custReceiptTemplate = null)
    {
        // validation for constraint: string
        if (!is_null($custReceiptTemplate) && !is_string($custReceiptTemplate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($custReceiptTemplate, true), gettype($custReceiptTemplate)), __LINE__);
        }
        $this->CustReceiptTemplate = $custReceiptTemplate;
        return $this;
    }
    /**
     * Get IsRecurring value
     * @return string|null
     */
    public function getIsRecurring()
    {
        return $this->IsRecurring;
    }
    /**
     * Set IsRecurring value
     * @param string $isRecurring
     * @return \StructType\ChargeDetailInput
     */
    public function setIsRecurring($isRecurring = null)
    {
        // validation for constraint: string
        if (!is_null($isRecurring) && !is_string($isRecurring)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($isRecurring, true), gettype($isRecurring)), __LINE__);
        }
        $this->IsRecurring = $isRecurring;
        return $this;
    }
    /**
     * Get Pares value
     * @return string|null
     */
    public function getPares()
    {
        return $this->Pares;
    }
    /**
     * Set Pares value
     * @param string $pares
     * @return \StructType\ChargeDetailInput
     */
    public function setPares($pares = null)
    {
        // validation for constraint: string
        if (!is_null($pares) && !is_string($pares)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($pares, true), gettype($pares)), __LINE__);
        }
        $this->Pares = $pares;
        return $this;
    }
    /**
     * Get VerifyCardAuth value
     * @return bool|null
     */
    public function getVerifyCardAuth()
    {
        return $this->VerifyCardAuth;
    }
    /**
     * Set VerifyCardAuth value
     * @param bool $verifyCardAuth
     * @return \StructType\ChargeDetailInput
     */
    public function setVerifyCardAuth($verifyCardAuth = null)
    {
        // validation for constraint: boolean
        if (!is_null($verifyCardAuth) && !is_bool($verifyCardAuth)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($verifyCardAuth, true), gettype($verifyCardAuth)), __LINE__);
        }
        $this->VerifyCardAuth = $verifyCardAuth;
        return $this;
    }
}
