<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for BANKCHECK_SALE StructType
 * @subpackage Structs
 */
class BANKCHECK_SALE extends AbstractStructBase
{
    /**
     * The MerchantID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $MerchantID;
    /**
     * The HashInfo
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \StructType\HashInput
     */
    public $HashInfo;
    /**
     * The ClientIP
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ClientIP;
    /**
     * The ChargeDetailInfo
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\ChargeDetailInput
     */
    public $ChargeDetailInfo;
    /**
     * The BillingDetailInfo
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\CustDetailInput
     */
    public $BillingDetailInfo;
    /**
     * The ShippingDetailInfo
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\CustDetailInput
     */
    public $ShippingDetailInfo;
    /**
     * Constructor method for BANKCHECK_SALE
     * @uses BANKCHECK_SALE::setMerchantID()
     * @uses BANKCHECK_SALE::setHashInfo()
     * @uses BANKCHECK_SALE::setClientIP()
     * @uses BANKCHECK_SALE::setChargeDetailInfo()
     * @uses BANKCHECK_SALE::setBillingDetailInfo()
     * @uses BANKCHECK_SALE::setShippingDetailInfo()
     * @param string $merchantID
     * @param \StructType\HashInput $hashInfo
     * @param string $clientIP
     * @param \StructType\ChargeDetailInput $chargeDetailInfo
     * @param \StructType\CustDetailInput $billingDetailInfo
     * @param \StructType\CustDetailInput $shippingDetailInfo
     */
    public function __construct($merchantID = null, \StructType\HashInput $hashInfo = null, $clientIP = null, \StructType\ChargeDetailInput $chargeDetailInfo = null, \StructType\CustDetailInput $billingDetailInfo = null, \StructType\CustDetailInput $shippingDetailInfo = null)
    {
        $this
            ->setMerchantID($merchantID)
            ->setHashInfo($hashInfo)
            ->setClientIP($clientIP)
            ->setChargeDetailInfo($chargeDetailInfo)
            ->setBillingDetailInfo($billingDetailInfo)
            ->setShippingDetailInfo($shippingDetailInfo);
    }
    /**
     * Get MerchantID value
     * @return string
     */
    public function getMerchantID()
    {
        return $this->MerchantID;
    }
    /**
     * Set MerchantID value
     * @param string $merchantID
     * @return \StructType\BANKCHECK_SALE
     */
    public function setMerchantID($merchantID = null)
    {
        // validation for constraint: string
        if (!is_null($merchantID) && !is_string($merchantID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($merchantID, true), gettype($merchantID)), __LINE__);
        }
        $this->MerchantID = $merchantID;
        return $this;
    }
    /**
     * Get HashInfo value
     * @return \StructType\HashInput
     */
    public function getHashInfo()
    {
        return $this->HashInfo;
    }
    /**
     * Set HashInfo value
     * @param \StructType\HashInput $hashInfo
     * @return \StructType\BANKCHECK_SALE
     */
    public function setHashInfo(\StructType\HashInput $hashInfo = null)
    {
        $this->HashInfo = $hashInfo;
        return $this;
    }
    /**
     * Get ClientIP value
     * @return string|null
     */
    public function getClientIP()
    {
        return $this->ClientIP;
    }
    /**
     * Set ClientIP value
     * @param string $clientIP
     * @return \StructType\BANKCHECK_SALE
     */
    public function setClientIP($clientIP = null)
    {
        // validation for constraint: string
        if (!is_null($clientIP) && !is_string($clientIP)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($clientIP, true), gettype($clientIP)), __LINE__);
        }
        $this->ClientIP = $clientIP;
        return $this;
    }
    /**
     * Get ChargeDetailInfo value
     * @return \StructType\ChargeDetailInput|null
     */
    public function getChargeDetailInfo()
    {
        return $this->ChargeDetailInfo;
    }
    /**
     * Set ChargeDetailInfo value
     * @param \StructType\ChargeDetailInput $chargeDetailInfo
     * @return \StructType\BANKCHECK_SALE
     */
    public function setChargeDetailInfo(\StructType\ChargeDetailInput $chargeDetailInfo = null)
    {
        $this->ChargeDetailInfo = $chargeDetailInfo;
        return $this;
    }
    /**
     * Get BillingDetailInfo value
     * @return \StructType\CustDetailInput|null
     */
    public function getBillingDetailInfo()
    {
        return $this->BillingDetailInfo;
    }
    /**
     * Set BillingDetailInfo value
     * @param \StructType\CustDetailInput $billingDetailInfo
     * @return \StructType\BANKCHECK_SALE
     */
    public function setBillingDetailInfo(\StructType\CustDetailInput $billingDetailInfo = null)
    {
        $this->BillingDetailInfo = $billingDetailInfo;
        return $this;
    }
    /**
     * Get ShippingDetailInfo value
     * @return \StructType\CustDetailInput|null
     */
    public function getShippingDetailInfo()
    {
        return $this->ShippingDetailInfo;
    }
    /**
     * Set ShippingDetailInfo value
     * @param \StructType\CustDetailInput $shippingDetailInfo
     * @return \StructType\BANKCHECK_SALE
     */
    public function setShippingDetailInfo(\StructType\CustDetailInput $shippingDetailInfo = null)
    {
        $this->ShippingDetailInfo = $shippingDetailInfo;
        return $this;
    }
}
