<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for BANKCARD_SEND_BATCH StructType
 * @subpackage Structs
 */
class BANKCARD_SEND_BATCH extends AbstractStructBase
{
    /**
     * The MerchantID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $MerchantID;
    /**
     * The HashInfo
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \StructType\HashInput
     */
    public $HashInfo;
    /**
     * The ClientIP
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ClientIP;
    /**
     * The FileName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $FileName;
    /**
     * The AutoStart
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $AutoStart;
    /**
     * The Format
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Format;
    /**
     * The Encoding
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Encoding;
    /**
     * The Fields
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Fields;
    /**
     * The Data
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Data;
    /**
     * The OverrideDuplicates
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $OverrideDuplicates;
    /**
     * Constructor method for BANKCARD_SEND_BATCH
     * @uses BANKCARD_SEND_BATCH::setMerchantID()
     * @uses BANKCARD_SEND_BATCH::setHashInfo()
     * @uses BANKCARD_SEND_BATCH::setClientIP()
     * @uses BANKCARD_SEND_BATCH::setFileName()
     * @uses BANKCARD_SEND_BATCH::setAutoStart()
     * @uses BANKCARD_SEND_BATCH::setFormat()
     * @uses BANKCARD_SEND_BATCH::setEncoding()
     * @uses BANKCARD_SEND_BATCH::setFields()
     * @uses BANKCARD_SEND_BATCH::setData()
     * @uses BANKCARD_SEND_BATCH::setOverrideDuplicates()
     * @param string $merchantID
     * @param \StructType\HashInput $hashInfo
     * @param string $clientIP
     * @param string $fileName
     * @param bool $autoStart
     * @param string $format
     * @param string $encoding
     * @param string $fields
     * @param string $data
     * @param bool $overrideDuplicates
     */
    public function __construct($merchantID = null, \StructType\HashInput $hashInfo = null, $clientIP = null, $fileName = null, $autoStart = null, $format = null, $encoding = null, $fields = null, $data = null, $overrideDuplicates = null)
    {
        $this
            ->setMerchantID($merchantID)
            ->setHashInfo($hashInfo)
            ->setClientIP($clientIP)
            ->setFileName($fileName)
            ->setAutoStart($autoStart)
            ->setFormat($format)
            ->setEncoding($encoding)
            ->setFields($fields)
            ->setData($data)
            ->setOverrideDuplicates($overrideDuplicates);
    }
    /**
     * Get MerchantID value
     * @return string
     */
    public function getMerchantID()
    {
        return $this->MerchantID;
    }
    /**
     * Set MerchantID value
     * @param string $merchantID
     * @return \StructType\BANKCARD_SEND_BATCH
     */
    public function setMerchantID($merchantID = null)
    {
        // validation for constraint: string
        if (!is_null($merchantID) && !is_string($merchantID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($merchantID, true), gettype($merchantID)), __LINE__);
        }
        $this->MerchantID = $merchantID;
        return $this;
    }
    /**
     * Get HashInfo value
     * @return \StructType\HashInput
     */
    public function getHashInfo()
    {
        return $this->HashInfo;
    }
    /**
     * Set HashInfo value
     * @param \StructType\HashInput $hashInfo
     * @return \StructType\BANKCARD_SEND_BATCH
     */
    public function setHashInfo(\StructType\HashInput $hashInfo = null)
    {
        $this->HashInfo = $hashInfo;
        return $this;
    }
    /**
     * Get ClientIP value
     * @return string|null
     */
    public function getClientIP()
    {
        return $this->ClientIP;
    }
    /**
     * Set ClientIP value
     * @param string $clientIP
     * @return \StructType\BANKCARD_SEND_BATCH
     */
    public function setClientIP($clientIP = null)
    {
        // validation for constraint: string
        if (!is_null($clientIP) && !is_string($clientIP)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($clientIP, true), gettype($clientIP)), __LINE__);
        }
        $this->ClientIP = $clientIP;
        return $this;
    }
    /**
     * Get FileName value
     * @return string|null
     */
    public function getFileName()
    {
        return $this->FileName;
    }
    /**
     * Set FileName value
     * @param string $fileName
     * @return \StructType\BANKCARD_SEND_BATCH
     */
    public function setFileName($fileName = null)
    {
        // validation for constraint: string
        if (!is_null($fileName) && !is_string($fileName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($fileName, true), gettype($fileName)), __LINE__);
        }
        $this->FileName = $fileName;
        return $this;
    }
    /**
     * Get AutoStart value
     * @return bool|null
     */
    public function getAutoStart()
    {
        return $this->AutoStart;
    }
    /**
     * Set AutoStart value
     * @param bool $autoStart
     * @return \StructType\BANKCARD_SEND_BATCH
     */
    public function setAutoStart($autoStart = null)
    {
        // validation for constraint: boolean
        if (!is_null($autoStart) && !is_bool($autoStart)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($autoStart, true), gettype($autoStart)), __LINE__);
        }
        $this->AutoStart = $autoStart;
        return $this;
    }
    /**
     * Get Format value
     * @return string|null
     */
    public function getFormat()
    {
        return $this->Format;
    }
    /**
     * Set Format value
     * @param string $format
     * @return \StructType\BANKCARD_SEND_BATCH
     */
    public function setFormat($format = null)
    {
        // validation for constraint: string
        if (!is_null($format) && !is_string($format)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($format, true), gettype($format)), __LINE__);
        }
        $this->Format = $format;
        return $this;
    }
    /**
     * Get Encoding value
     * @return string|null
     */
    public function getEncoding()
    {
        return $this->Encoding;
    }
    /**
     * Set Encoding value
     * @param string $encoding
     * @return \StructType\BANKCARD_SEND_BATCH
     */
    public function setEncoding($encoding = null)
    {
        // validation for constraint: string
        if (!is_null($encoding) && !is_string($encoding)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($encoding, true), gettype($encoding)), __LINE__);
        }
        $this->Encoding = $encoding;
        return $this;
    }
    /**
     * Get Fields value
     * @return string|null
     */
    public function getFields()
    {
        return $this->Fields;
    }
    /**
     * Set Fields value
     * @param string $fields
     * @return \StructType\BANKCARD_SEND_BATCH
     */
    public function setFields($fields = null)
    {
        // validation for constraint: string
        if (!is_null($fields) && !is_string($fields)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($fields, true), gettype($fields)), __LINE__);
        }
        $this->Fields = $fields;
        return $this;
    }
    /**
     * Get Data value
     * @return string|null
     */
    public function getData()
    {
        return $this->Data;
    }
    /**
     * Set Data value
     * @param string $data
     * @return \StructType\BANKCARD_SEND_BATCH
     */
    public function setData($data = null)
    {
        // validation for constraint: string
        if (!is_null($data) && !is_string($data)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($data, true), gettype($data)), __LINE__);
        }
        $this->Data = $data;
        return $this;
    }
    /**
     * Get OverrideDuplicates value
     * @return bool|null
     */
    public function getOverrideDuplicates()
    {
        return $this->OverrideDuplicates;
    }
    /**
     * Set OverrideDuplicates value
     * @param bool $overrideDuplicates
     * @return \StructType\BANKCARD_SEND_BATCH
     */
    public function setOverrideDuplicates($overrideDuplicates = null)
    {
        // validation for constraint: boolean
        if (!is_null($overrideDuplicates) && !is_bool($overrideDuplicates)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($overrideDuplicates, true), gettype($overrideDuplicates)), __LINE__);
        }
        $this->OverrideDuplicates = $overrideDuplicates;
        return $this;
    }
}
