<?php
/**
 * Class which returns the class map definition
 * @package
 */
class ClassMap
{
    /**
     * Returns the mapping between the WSDL Structs and generated Structs' classes
     * This array is sent to the \SoapClient when calling the WS
     * @return string[]
     */
    final public static function get()
    {
        return array(
            'HashInput' => '\\StructType\\HashInput',
            'CustDetailInput' => '\\StructType\\CustDetailInput',
            'ChargeDetailInput' => '\\StructType\\ChargeDetailInput',
            'CreditCardInput' => '\\StructType\\CreditCardInput',
            'CheckInput' => '\\StructType\\CheckInput',
            'PaymentMethodInput' => '\\StructType\\PaymentMethodInput',
            'CustomerInput' => '\\StructType\\CustomerInput',
            'CustomerChargeInput' => '\\StructType\\CustomerChargeInput',
            'ItemDetailInput' => '\\StructType\\ItemDetailInput',
            'CustomerOutput' => '\\StructType\\CustomerOutput',
            'BatchListingOutput' => '\\StructType\\BatchListingOutput',
            'BatchesOutput' => '\\StructType\\BatchesOutput',
            'ChargeDetailOutput' => '\\StructType\\ChargeDetailOutput',
            'AccountDetailInput' => '\\StructType\\AccountDetailInput',
            'GCChargeDetailInput' => '\\StructType\\GCChargeDetailInput',
            'BankCardResponse' => '\\StructType\\BankCardResponse',
            'BatchUploadStatus' => '\\StructType\\BatchUploadStatus',
            'GiftCardResponse' => '\\StructType\\GiftCardResponse',
            'ApplicantInput' => '\\StructType\\ApplicantInput',
            'BANKCARD_SALE' => '\\StructType\\BANKCARD_SALE',
            'BANKCARD_SALEResponse' => '\\StructType\\BANKCARD_SALEResponse',
            'BANKCARD_CREDIT_OR_REFUND' => '\\StructType\\BANKCARD_CREDIT_OR_REFUND',
            'BANKCARD_CREDIT_OR_REFUNDResponse' => '\\StructType\\BANKCARD_CREDIT_OR_REFUNDResponse',
            'BANKCARD_AUTHONLY' => '\\StructType\\BANKCARD_AUTHONLY',
            'BANKCARD_AUTHONLYResponse' => '\\StructType\\BANKCARD_AUTHONLYResponse',
            'BANKCARD_AUTHONLYL3' => '\\StructType\\BANKCARD_AUTHONLYL3',
            'BANKCARD_AUTHONLYL3Response' => '\\StructType\\BANKCARD_AUTHONLYL3Response',
            'BANKCARD_CREDIT' => '\\StructType\\BANKCARD_CREDIT',
            'BANKCARD_CREDITResponse' => '\\StructType\\BANKCARD_CREDITResponse',
            'BANKCARD_VOID' => '\\StructType\\BANKCARD_VOID',
            'BANKCARD_VOIDResponse' => '\\StructType\\BANKCARD_VOIDResponse',
            'BANKCARD_PRIOR_AUTH_SALE' => '\\StructType\\BANKCARD_PRIOR_AUTH_SALE',
            'BANKCARD_PRIOR_AUTH_SALEResponse' => '\\StructType\\BANKCARD_PRIOR_AUTH_SALEResponse',
            'BANKCARD_PHONE_AUTH_POST' => '\\StructType\\BANKCARD_PHONE_AUTH_POST',
            'BANKCARD_PHONE_AUTH_POSTResponse' => '\\StructType\\BANKCARD_PHONE_AUTH_POSTResponse',
            'BANKCHECK_SALE' => '\\StructType\\BANKCHECK_SALE',
            'BANKCHECK_SALEResponse' => '\\StructType\\BANKCHECK_SALEResponse',
            'BANKCHECK_CREDIT' => '\\StructType\\BANKCHECK_CREDIT',
            'BANKCHECK_CREDITResponse' => '\\StructType\\BANKCHECK_CREDITResponse',
            'BANKCARD_SEND_BATCH' => '\\StructType\\BANKCARD_SEND_BATCH',
            'BANKCARD_SEND_BATCHResponse' => '\\StructType\\BANKCARD_SEND_BATCHResponse',
            'BANKCARD_RUN_BATCH' => '\\StructType\\BANKCARD_RUN_BATCH',
            'BANKCARD_RUN_BATCHResponse' => '\\StructType\\BANKCARD_RUN_BATCHResponse',
            'BANKCARD_RUN_BATCHResult' => '\\StructType\\BANKCARD_RUN_BATCHResult',
            'BANKCARD_GET_BATCH_STATUS' => '\\StructType\\BANKCARD_GET_BATCH_STATUS',
            'BANKCARD_GET_BATCH_STATUSResponse' => '\\StructType\\BANKCARD_GET_BATCH_STATUSResponse',
            'VERIFY_BANKCARD_SERVICE' => '\\StructType\\VERIFY_BANKCARD_SERVICE',
            'VERIFY_BANKCARD_SERVICEResponse' => '\\StructType\\VERIFY_BANKCARD_SERVICEResponse',
            'VERIFY_BANKCARD_SERVICEResult' => '\\StructType\\VERIFY_BANKCARD_SERVICEResult',
            'BANKCARD_VERIFY_CUSTOMER_PAYMENT_METHOD' => '\\StructType\\BANKCARD_VERIFY_CUSTOMER_PAYMENT_METHOD',
            'BANKCARD_VERIFY_CUSTOMER_PAYMENT_METHODResponse' => '\\StructType\\BANKCARD_VERIFY_CUSTOMER_PAYMENT_METHODResponse',
            'BANKCARD_VERIFY_CUSTOMER_PAYMENT_METHODResult' => '\\StructType\\BANKCARD_VERIFY_CUSTOMER_PAYMENT_METHODResult',
            'BANKCARD_ADD_CUSTOMER' => '\\StructType\\BANKCARD_ADD_CUSTOMER',
            'BANKCARD_ADD_CUSTOMERResponse' => '\\StructType\\BANKCARD_ADD_CUSTOMERResponse',
            'BANKCARD_ADD_CUSTOMERResult' => '\\StructType\\BANKCARD_ADD_CUSTOMERResult',
            'BANKCARD_GET_CUSTOMER' => '\\StructType\\BANKCARD_GET_CUSTOMER',
            'BANKCARD_GET_CUSTOMERResponse' => '\\StructType\\BANKCARD_GET_CUSTOMERResponse',
            'BANKCARD_GET_CUSTOMERResult' => '\\StructType\\BANKCARD_GET_CUSTOMERResult',
            'BANKCARD_DEL_CUSTOMER' => '\\StructType\\BANKCARD_DEL_CUSTOMER',
            'BANKCARD_DEL_CUSTOMERResponse' => '\\StructType\\BANKCARD_DEL_CUSTOMERResponse',
            'BANKCARD_DEL_CUSTOMERResult' => '\\StructType\\BANKCARD_DEL_CUSTOMERResult',
            'BANKCARD_ADD_CUSTOMER_PAYMENT_METHOD' => '\\StructType\\BANKCARD_ADD_CUSTOMER_PAYMENT_METHOD',
            'BANKCARD_ADD_CUSTOMER_PAYMENT_METHODResponse' => '\\StructType\\BANKCARD_ADD_CUSTOMER_PAYMENT_METHODResponse',
            'BANKCARD_ADD_CUSTOMER_PAYMENT_METHODResult' => '\\StructType\\BANKCARD_ADD_CUSTOMER_PAYMENT_METHODResult',
            'BANKCARD_DEL_CUSTOMER_PAYMENT_METHOD' => '\\StructType\\BANKCARD_DEL_CUSTOMER_PAYMENT_METHOD',
            'BANKCARD_DEL_CUSTOMER_PAYMENT_METHODResponse' => '\\StructType\\BANKCARD_DEL_CUSTOMER_PAYMENT_METHODResponse',
            'BANKCARD_DEL_CUSTOMER_PAYMENT_METHODResult' => '\\StructType\\BANKCARD_DEL_CUSTOMER_PAYMENT_METHODResult',
            'BANKCARD_CUSTOMER_SALE' => '\\StructType\\BANKCARD_CUSTOMER_SALE',
            'BANKCARD_CUSTOMER_SALEResponse' => '\\StructType\\BANKCARD_CUSTOMER_SALEResponse',
            'BANKCARD_CUSTOMER_AUTHONLY' => '\\StructType\\BANKCARD_CUSTOMER_AUTHONLY',
            'BANKCARD_CUSTOMER_AUTHONLYL3' => '\\StructType\\BANKCARD_CUSTOMER_AUTHONLYL3',
            'BANKCARD_CUSTOMER_AUTHONLYResponse' => '\\StructType\\BANKCARD_CUSTOMER_AUTHONLYResponse',
            'BANKCARD_CUSTOMER_AUTHONLYL3Response' => '\\StructType\\BANKCARD_CUSTOMER_AUTHONLYL3Response',
            'BANKCARD_CUSTOMER_CREDIT_OR_REFUND' => '\\StructType\\BANKCARD_CUSTOMER_CREDIT_OR_REFUND',
            'BANKCARD_CUSTOMER_CREDIT_OR_REFUNDResponse' => '\\StructType\\BANKCARD_CUSTOMER_CREDIT_OR_REFUNDResponse',
            'BANKCARD_CUSTOMER_CREDIT' => '\\StructType\\BANKCARD_CUSTOMER_CREDIT',
            'BANKCARD_CUSTOMER_CREDITResponse' => '\\StructType\\BANKCARD_CUSTOMER_CREDITResponse',
            'BANKCARD_CUSTOMER_VOID' => '\\StructType\\BANKCARD_CUSTOMER_VOID',
            'BANKCARD_CUSTOMER_VOIDResponse' => '\\StructType\\BANKCARD_CUSTOMER_VOIDResponse',
            'BANKCARD_CUSTOMER_PRIOR_AUTH_SALE' => '\\StructType\\BANKCARD_CUSTOMER_PRIOR_AUTH_SALE',
            'BANKCARD_CUSTOMER_PRIOR_AUTH_SALEResponse' => '\\StructType\\BANKCARD_CUSTOMER_PRIOR_AUTH_SALEResponse',
            'VERIFY_BANKCARD_CUSTOMER_SERVICE' => '\\StructType\\VERIFY_BANKCARD_CUSTOMER_SERVICE',
            'VERIFY_BANKCARD_CUSTOMER_SERVICEResponse' => '\\StructType\\VERIFY_BANKCARD_CUSTOMER_SERVICEResponse',
            'VERIFY_BANKCARD_CUSTOMER_SERVICEResult' => '\\StructType\\VERIFY_BANKCARD_CUSTOMER_SERVICEResult',
            'GIFTCARD_ACTIVATION' => '\\StructType\\GIFTCARD_ACTIVATION',
            'GIFTCARD_ACTIVATIONResponse' => '\\StructType\\GIFTCARD_ACTIVATIONResponse',
            'GIFTCARD_REDEMPTION' => '\\StructType\\GIFTCARD_REDEMPTION',
            'GIFTCARD_REDEMPTIONResponse' => '\\StructType\\GIFTCARD_REDEMPTIONResponse',
            'GIFTCARD_VOID' => '\\StructType\\GIFTCARD_VOID',
            'GIFTCARD_VOIDResponse' => '\\StructType\\GIFTCARD_VOIDResponse',
            'GIFTCARD_BALANCE' => '\\StructType\\GIFTCARD_BALANCE',
            'GIFTCARD_BALANCEResponse' => '\\StructType\\GIFTCARD_BALANCEResponse',
            'VERIFY_GIFTCARD_SERVICE' => '\\StructType\\VERIFY_GIFTCARD_SERVICE',
            'VERIFY_GIFTCARD_SERVICEResponse' => '\\StructType\\VERIFY_GIFTCARD_SERVICEResponse',
            'VERIFY_GIFTCARD_SERVICEResult' => '\\StructType\\VERIFY_GIFTCARD_SERVICEResult',
            'VIEW_SETTLED_BATCH_SUMMARY' => '\\StructType\\VIEW_SETTLED_BATCH_SUMMARY',
            'VIEW_SETTLED_BATCH_SUMMARYResponse' => '\\StructType\\VIEW_SETTLED_BATCH_SUMMARYResponse',
            'VIEW_SETTLED_BATCH_SUMMARYResult' => '\\StructType\\VIEW_SETTLED_BATCH_SUMMARYResult',
            'VIEW_BANKCARD_SETTLED_BATCH_LISTING' => '\\StructType\\VIEW_BANKCARD_SETTLED_BATCH_LISTING',
            'VIEW_BANKCARD_SETTLED_BATCH_LISTINGResponse' => '\\StructType\\VIEW_BANKCARD_SETTLED_BATCH_LISTINGResponse',
            'VIEW_BANKCARD_SETTLED_BATCH_LISTINGResult' => '\\StructType\\VIEW_BANKCARD_SETTLED_BATCH_LISTINGResult',
            'FINANCE_APPLICATION' => '\\StructType\\FINANCE_APPLICATION',
            'FINANCE_APPLICATIONResponse' => '\\StructType\\FINANCE_APPLICATIONResponse',
            'FINANCE_APPLICATIONResult' => '\\StructType\\FINANCE_APPLICATIONResult',
            'FINANCE_PROMO_DISCLOSURE' => '\\StructType\\FINANCE_PROMO_DISCLOSURE',
            'FINANCE_PROMO_DISCLOSUREResponse' => '\\StructType\\FINANCE_PROMO_DISCLOSUREResponse',
            'FINANCE_PROMO_DISCLOSUREResult' => '\\StructType\\FINANCE_PROMO_DISCLOSUREResult',
            'FINANCE_AUTHORIZATION' => '\\StructType\\FINANCE_AUTHORIZATION',
            'FINANCE_AUTHORIZATIONResponse' => '\\StructType\\FINANCE_AUTHORIZATIONResponse',
            'FINANCE_AUTHORIZATIONResult' => '\\StructType\\FINANCE_AUTHORIZATIONResult',
            'FINANCE_REVERSE_AUTH' => '\\StructType\\FINANCE_REVERSE_AUTH',
            'FINANCE_REVERSE_AUTHResponse' => '\\StructType\\FINANCE_REVERSE_AUTHResponse',
            'FINANCE_REVERSE_AUTHResult' => '\\StructType\\FINANCE_REVERSE_AUTHResult',
            'FINANCE_SETTLEMENT' => '\\StructType\\FINANCE_SETTLEMENT',
            'FINANCE_SETTLEMENTResponse' => '\\StructType\\FINANCE_SETTLEMENTResponse',
            'FINANCE_SETTLEMENTResult' => '\\StructType\\FINANCE_SETTLEMENTResult',
            'FINANCE_RECONCILE' => '\\StructType\\FINANCE_RECONCILE',
            'FINANCE_RECONCILEResponse' => '\\StructType\\FINANCE_RECONCILEResponse',
            'FINANCE_RECONCILEResult' => '\\StructType\\FINANCE_RECONCILEResult',
            'BANKCARD_LEVEL3_SALE' => '\\StructType\\BANKCARD_LEVEL3_SALE',
            'BANKCARD_LEVEL3_SALEResponse' => '\\StructType\\BANKCARD_LEVEL3_SALEResponse',
            'BANKCARD_LEVEL3_AUTHONLY' => '\\StructType\\BANKCARD_LEVEL3_AUTHONLY',
            'BANKCARD_LEVEL3_AUTHONLYResponse' => '\\StructType\\BANKCARD_LEVEL3_AUTHONLYResponse',
            'BANKCARD_LEVEL3_PRIOR_AUTH_SALE' => '\\StructType\\BANKCARD_LEVEL3_PRIOR_AUTH_SALE',
            'BANKCARD_LEVEL3_PRIOR_AUTH_SALEResponse' => '\\StructType\\BANKCARD_LEVEL3_PRIOR_AUTH_SALEResponse',
            'VERIFY_BANKCARD_LEVEL3_SERVICE' => '\\StructType\\VERIFY_BANKCARD_LEVEL3_SERVICE',
            'VERIFY_BANKCARD_LEVEL3_SERVICEResponse' => '\\StructType\\VERIFY_BANKCARD_LEVEL3_SERVICEResponse',
            'VERIFY_BANKCARD_LEVEL3_SERVICEResult' => '\\StructType\\VERIFY_BANKCARD_LEVEL3_SERVICEResult',
            'BANKCARD_LEVEL3_PHONE_AUTH_POST' => '\\StructType\\BANKCARD_LEVEL3_PHONE_AUTH_POST',
            'BANKCARD_LEVEL3_PHONE_AUTH_POSTResponse' => '\\StructType\\BANKCARD_LEVEL3_PHONE_AUTH_POSTResponse',
            'BANKCARD_LEVEL3_CREDIT' => '\\StructType\\BANKCARD_LEVEL3_CREDIT',
            'BANKCARD_LEVEL3_CREDITResponse' => '\\StructType\\BANKCARD_LEVEL3_CREDITResponse',
            'BANKCARD_LEVEL3_VOID' => '\\StructType\\BANKCARD_LEVEL3_VOID',
            'BANKCARD_LEVEL3_VOIDResponse' => '\\StructType\\BANKCARD_LEVEL3_VOIDResponse',
        );
    }
}
