<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for UnitReviewsType StructType
 * @subpackage Structs
 */
class UnitReviewsType extends AbstractStructBase
{
    /**
     * The UnitReview
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\UnitReviewType[]
     */
    public $UnitReview;
    /**
     * The PropertyManagerReview
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\PropertyManagerReviewType
     */
    public $PropertyManagerReview;
    /**
     * Constructor method for UnitReviewsType
     * @uses UnitReviewsType::setUnitReview()
     * @uses UnitReviewsType::setPropertyManagerReview()
     * @param \StructType\UnitReviewType[] $unitReview
     * @param \StructType\PropertyManagerReviewType $propertyManagerReview
     */
    public function __construct(array $unitReview = array(), \StructType\PropertyManagerReviewType $propertyManagerReview = null)
    {
        $this
            ->setUnitReview($unitReview)
            ->setPropertyManagerReview($propertyManagerReview);
    }
    /**
     * Get UnitReview value
     * @return \StructType\UnitReviewType[]|null
     */
    public function getUnitReview()
    {
        return $this->UnitReview;
    }
    /**
     * Set UnitReview value
     * @throws \InvalidArgumentException
     * @param \StructType\UnitReviewType[] $unitReview
     * @return \StructType\UnitReviewsType
     */
    public function setUnitReview(array $unitReview = array())
    {
        foreach ($unitReview as $unitReviewsTypeUnitReviewItem) {
            // validation for constraint: itemType
            if (!$unitReviewsTypeUnitReviewItem instanceof \StructType\UnitReviewType) {
                throw new \InvalidArgumentException(sprintf('The UnitReview property can only contain items of \StructType\UnitReviewType, "%s" given', is_object($unitReviewsTypeUnitReviewItem) ? get_class($unitReviewsTypeUnitReviewItem) : gettype($unitReviewsTypeUnitReviewItem)), __LINE__);
            }
        }
        $this->UnitReview = $unitReview;
        return $this;
    }
    /**
     * Add item to UnitReview value
     * @throws \InvalidArgumentException
     * @param \StructType\UnitReviewType $item
     * @return \StructType\UnitReviewsType
     */
    public function addToUnitReview(\StructType\UnitReviewType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\UnitReviewType) {
            throw new \InvalidArgumentException(sprintf('The UnitReview property can only contain items of \StructType\UnitReviewType, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->UnitReview[] = $item;
        return $this;
    }
    /**
     * Get PropertyManagerReview value
     * @return \StructType\PropertyManagerReviewType|null
     */
    public function getPropertyManagerReview()
    {
        return $this->PropertyManagerReview;
    }
    /**
     * Set PropertyManagerReview value
     * @param \StructType\PropertyManagerReviewType $propertyManagerReview
     * @return \StructType\UnitReviewsType
     */
    public function setPropertyManagerReview(\StructType\PropertyManagerReviewType $propertyManagerReview = null)
    {
        $this->PropertyManagerReview = $propertyManagerReview;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\UnitReviewsType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
