<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for UnitReservationsType StructType
 * @subpackage Structs
 */
class UnitReservationsType extends AbstractStructBase
{
    /**
     * The UnitReservation
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\UnitReservationType[]
     */
    public $UnitReservation;
    /**
     * The RoutingHops
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfRoutingHopTypeRoutingHop
     */
    public $RoutingHops;
    /**
     * The WrittenConfInst
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\WrittenConfInstType
     */
    public $WrittenConfInst;
    /**
     * The TPA_Extensions
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\TPA_Extensions_Type
     */
    public $TPA_Extensions;
    /**
     * Constructor method for UnitReservationsType
     * @uses UnitReservationsType::setUnitReservation()
     * @uses UnitReservationsType::setRoutingHops()
     * @uses UnitReservationsType::setWrittenConfInst()
     * @uses UnitReservationsType::setTPA_Extensions()
     * @param \StructType\UnitReservationType[] $unitReservation
     * @param \ArrayType\ArrayOfRoutingHopTypeRoutingHop $routingHops
     * @param \StructType\WrittenConfInstType $writtenConfInst
     * @param \StructType\TPA_Extensions_Type $tPA_Extensions
     */
    public function __construct(array $unitReservation = array(), \ArrayType\ArrayOfRoutingHopTypeRoutingHop $routingHops = null, \StructType\WrittenConfInstType $writtenConfInst = null, \StructType\TPA_Extensions_Type $tPA_Extensions = null)
    {
        $this
            ->setUnitReservation($unitReservation)
            ->setRoutingHops($routingHops)
            ->setWrittenConfInst($writtenConfInst)
            ->setTPA_Extensions($tPA_Extensions);
    }
    /**
     * Get UnitReservation value
     * @return \StructType\UnitReservationType[]|null
     */
    public function getUnitReservation()
    {
        return $this->UnitReservation;
    }
    /**
     * Set UnitReservation value
     * @throws \InvalidArgumentException
     * @param \StructType\UnitReservationType[] $unitReservation
     * @return \StructType\UnitReservationsType
     */
    public function setUnitReservation(array $unitReservation = array())
    {
        foreach ($unitReservation as $unitReservationsTypeUnitReservationItem) {
            // validation for constraint: itemType
            if (!$unitReservationsTypeUnitReservationItem instanceof \StructType\UnitReservationType) {
                throw new \InvalidArgumentException(sprintf('The UnitReservation property can only contain items of \StructType\UnitReservationType, "%s" given', is_object($unitReservationsTypeUnitReservationItem) ? get_class($unitReservationsTypeUnitReservationItem) : gettype($unitReservationsTypeUnitReservationItem)), __LINE__);
            }
        }
        $this->UnitReservation = $unitReservation;
        return $this;
    }
    /**
     * Add item to UnitReservation value
     * @throws \InvalidArgumentException
     * @param \StructType\UnitReservationType $item
     * @return \StructType\UnitReservationsType
     */
    public function addToUnitReservation(\StructType\UnitReservationType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\UnitReservationType) {
            throw new \InvalidArgumentException(sprintf('The UnitReservation property can only contain items of \StructType\UnitReservationType, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->UnitReservation[] = $item;
        return $this;
    }
    /**
     * Get RoutingHops value
     * @return \ArrayType\ArrayOfRoutingHopTypeRoutingHop|null
     */
    public function getRoutingHops()
    {
        return $this->RoutingHops;
    }
    /**
     * Set RoutingHops value
     * @param \ArrayType\ArrayOfRoutingHopTypeRoutingHop $routingHops
     * @return \StructType\UnitReservationsType
     */
    public function setRoutingHops(\ArrayType\ArrayOfRoutingHopTypeRoutingHop $routingHops = null)
    {
        $this->RoutingHops = $routingHops;
        return $this;
    }
    /**
     * Get WrittenConfInst value
     * @return \StructType\WrittenConfInstType|null
     */
    public function getWrittenConfInst()
    {
        return $this->WrittenConfInst;
    }
    /**
     * Set WrittenConfInst value
     * @param \StructType\WrittenConfInstType $writtenConfInst
     * @return \StructType\UnitReservationsType
     */
    public function setWrittenConfInst(\StructType\WrittenConfInstType $writtenConfInst = null)
    {
        $this->WrittenConfInst = $writtenConfInst;
        return $this;
    }
    /**
     * Get TPA_Extensions value
     * @return \StructType\TPA_Extensions_Type|null
     */
    public function getTPA_Extensions()
    {
        return $this->TPA_Extensions;
    }
    /**
     * Set TPA_Extensions value
     * @param \StructType\TPA_Extensions_Type $tPA_Extensions
     * @return \StructType\UnitReservationsType
     */
    public function setTPA_Extensions(\StructType\TPA_Extensions_Type $tPA_Extensions = null)
    {
        $this->TPA_Extensions = $tPA_Extensions;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\UnitReservationsType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
