<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for UnitResResponseType StructType
 * @subpackage Structs
 */
class UnitResResponseType extends EVRN_BaseRSType
{
    /**
     * The POS
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfSourceType
     */
    public $POS;
    /**
     * The Warnings
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\WarningsType
     */
    public $Warnings;
    /**
     * The Success
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\SuccessType
     */
    public $Success;
    /**
     * The Errors
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\ErrorsType
     */
    public $Errors;
    /**
     * The UnitReservations
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\UnitReservationsType
     */
    public $UnitReservations;
    /**
     * The ResResponseType
     * @var string
     */
    public $ResResponseType;
    /**
     * Constructor method for UnitResResponseType
     * @uses UnitResResponseType::setPOS()
     * @uses UnitResResponseType::setWarnings()
     * @uses UnitResResponseType::setSuccess()
     * @uses UnitResResponseType::setErrors()
     * @uses UnitResResponseType::setUnitReservations()
     * @uses UnitResResponseType::setResResponseType()
     * @param \ArrayType\ArrayOfSourceType $pOS
     * @param \StructType\WarningsType $warnings
     * @param \StructType\SuccessType $success
     * @param \StructType\ErrorsType $errors
     * @param \StructType\UnitReservationsType $unitReservations
     * @param string $resResponseType
     */
    public function __construct(\ArrayType\ArrayOfSourceType $pOS = null, \StructType\WarningsType $warnings = null, \StructType\SuccessType $success = null, \StructType\ErrorsType $errors = null, \StructType\UnitReservationsType $unitReservations = null, $resResponseType = null)
    {
        $this
            ->setPOS($pOS)
            ->setWarnings($warnings)
            ->setSuccess($success)
            ->setErrors($errors)
            ->setUnitReservations($unitReservations)
            ->setResResponseType($resResponseType);
    }
    /**
     * Get POS value
     * @return \ArrayType\ArrayOfSourceType|null
     */
    public function getPOS()
    {
        return $this->POS;
    }
    /**
     * Set POS value
     * @param \ArrayType\ArrayOfSourceType $pOS
     * @return \StructType\UnitResResponseType
     */
    public function setPOS(\ArrayType\ArrayOfSourceType $pOS = null)
    {
        $this->POS = $pOS;
        return $this;
    }
    /**
     * Get Warnings value
     * @return \StructType\WarningsType|null
     */
    public function getWarnings()
    {
        return $this->Warnings;
    }
    /**
     * Set Warnings value
     * @param \StructType\WarningsType $warnings
     * @return \StructType\UnitResResponseType
     */
    public function setWarnings(\StructType\WarningsType $warnings = null)
    {
        $this->Warnings = $warnings;
        return $this;
    }
    /**
     * Get Success value
     * @return \StructType\SuccessType|null
     */
    public function getSuccess()
    {
        return $this->Success;
    }
    /**
     * Set Success value
     * @param \StructType\SuccessType $success
     * @return \StructType\UnitResResponseType
     */
    public function setSuccess(\StructType\SuccessType $success = null)
    {
        $this->Success = $success;
        return $this;
    }
    /**
     * Get Errors value
     * @return \StructType\ErrorsType|null
     */
    public function getErrors()
    {
        return $this->Errors;
    }
    /**
     * Set Errors value
     * @param \StructType\ErrorsType $errors
     * @return \StructType\UnitResResponseType
     */
    public function setErrors(\StructType\ErrorsType $errors = null)
    {
        $this->Errors = $errors;
        return $this;
    }
    /**
     * Get UnitReservations value
     * @return \StructType\UnitReservationsType|null
     */
    public function getUnitReservations()
    {
        return $this->UnitReservations;
    }
    /**
     * Set UnitReservations value
     * @param \StructType\UnitReservationsType $unitReservations
     * @return \StructType\UnitResResponseType
     */
    public function setUnitReservations(\StructType\UnitReservationsType $unitReservations = null)
    {
        $this->UnitReservations = $unitReservations;
        return $this;
    }
    /**
     * Get ResResponseType value
     * @return string|null
     */
    public function getResResponseType()
    {
        return $this->ResResponseType;
    }
    /**
     * Set ResResponseType value
     * @uses \EnumType\TransactionStatusType::valueIsValid()
     * @uses \EnumType\TransactionStatusType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $resResponseType
     * @return \StructType\UnitResResponseType
     */
    public function setResResponseType($resResponseType = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\TransactionStatusType::valueIsValid($resResponseType)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $resResponseType, implode(', ', \EnumType\TransactionStatusType::getValidValues())), __LINE__);
        }
        $this->ResResponseType = $resResponseType;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\UnitResResponseType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
