<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ResCommonDetailType StructType
 * @subpackage Structs
 */
class ResCommonDetailType extends AbstractStructBase
{
    /**
     * The GuestCounts
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\GuestCountType
     */
    public $GuestCounts;
    /**
     * The TimeSpan
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\DateTimeSpanType
     */
    public $TimeSpan;
    /**
     * The ResGuestRPHs
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfResGuestRPHsTypeResGuestRPH
     */
    public $ResGuestRPHs;
    /**
     * The Memberships
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfMembershipTypeMembership
     */
    public $Memberships;
    /**
     * The Comments
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfCommentTypeComment
     */
    public $Comments;
    /**
     * The SpecialRequests
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfSpecialRequestTypeSpecialRequest
     */
    public $SpecialRequests;
    /**
     * The Guarantee
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Guarantee;
    /**
     * The DepositPayments
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfRequiredPaymentsTypeGuaranteePayment
     */
    public $DepositPayments;
    /**
     * The CancelPenalties
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\CancelPenaltiesType
     */
    public $CancelPenalties;
    /**
     * The Fees
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfFeeType
     */
    public $Fees;
    /**
     * The Total
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\TotalType
     */
    public $Total;
    /**
     * Constructor method for ResCommonDetailType
     * @uses ResCommonDetailType::setGuestCounts()
     * @uses ResCommonDetailType::setTimeSpan()
     * @uses ResCommonDetailType::setResGuestRPHs()
     * @uses ResCommonDetailType::setMemberships()
     * @uses ResCommonDetailType::setComments()
     * @uses ResCommonDetailType::setSpecialRequests()
     * @uses ResCommonDetailType::setGuarantee()
     * @uses ResCommonDetailType::setDepositPayments()
     * @uses ResCommonDetailType::setCancelPenalties()
     * @uses ResCommonDetailType::setFees()
     * @uses ResCommonDetailType::setTotal()
     * @param \StructType\GuestCountType $guestCounts
     * @param \StructType\DateTimeSpanType $timeSpan
     * @param \ArrayType\ArrayOfResGuestRPHsTypeResGuestRPH $resGuestRPHs
     * @param \ArrayType\ArrayOfMembershipTypeMembership $memberships
     * @param \ArrayType\ArrayOfCommentTypeComment $comments
     * @param \ArrayType\ArrayOfSpecialRequestTypeSpecialRequest $specialRequests
     * @param string $guarantee
     * @param \ArrayType\ArrayOfRequiredPaymentsTypeGuaranteePayment $depositPayments
     * @param \StructType\CancelPenaltiesType $cancelPenalties
     * @param \ArrayType\ArrayOfFeeType $fees
     * @param \StructType\TotalType $total
     */
    public function __construct(\StructType\GuestCountType $guestCounts = null, \StructType\DateTimeSpanType $timeSpan = null, \ArrayType\ArrayOfResGuestRPHsTypeResGuestRPH $resGuestRPHs = null, \ArrayType\ArrayOfMembershipTypeMembership $memberships = null, \ArrayType\ArrayOfCommentTypeComment $comments = null, \ArrayType\ArrayOfSpecialRequestTypeSpecialRequest $specialRequests = null, $guarantee = null, \ArrayType\ArrayOfRequiredPaymentsTypeGuaranteePayment $depositPayments = null, \StructType\CancelPenaltiesType $cancelPenalties = null, \ArrayType\ArrayOfFeeType $fees = null, \StructType\TotalType $total = null)
    {
        $this
            ->setGuestCounts($guestCounts)
            ->setTimeSpan($timeSpan)
            ->setResGuestRPHs($resGuestRPHs)
            ->setMemberships($memberships)
            ->setComments($comments)
            ->setSpecialRequests($specialRequests)
            ->setGuarantee($guarantee)
            ->setDepositPayments($depositPayments)
            ->setCancelPenalties($cancelPenalties)
            ->setFees($fees)
            ->setTotal($total);
    }
    /**
     * Get GuestCounts value
     * @return \StructType\GuestCountType|null
     */
    public function getGuestCounts()
    {
        return $this->GuestCounts;
    }
    /**
     * Set GuestCounts value
     * @param \StructType\GuestCountType $guestCounts
     * @return \StructType\ResCommonDetailType
     */
    public function setGuestCounts(\StructType\GuestCountType $guestCounts = null)
    {
        $this->GuestCounts = $guestCounts;
        return $this;
    }
    /**
     * Get TimeSpan value
     * @return \StructType\DateTimeSpanType|null
     */
    public function getTimeSpan()
    {
        return $this->TimeSpan;
    }
    /**
     * Set TimeSpan value
     * @param \StructType\DateTimeSpanType $timeSpan
     * @return \StructType\ResCommonDetailType
     */
    public function setTimeSpan(\StructType\DateTimeSpanType $timeSpan = null)
    {
        $this->TimeSpan = $timeSpan;
        return $this;
    }
    /**
     * Get ResGuestRPHs value
     * @return \ArrayType\ArrayOfResGuestRPHsTypeResGuestRPH|null
     */
    public function getResGuestRPHs()
    {
        return $this->ResGuestRPHs;
    }
    /**
     * Set ResGuestRPHs value
     * @param \ArrayType\ArrayOfResGuestRPHsTypeResGuestRPH $resGuestRPHs
     * @return \StructType\ResCommonDetailType
     */
    public function setResGuestRPHs(\ArrayType\ArrayOfResGuestRPHsTypeResGuestRPH $resGuestRPHs = null)
    {
        $this->ResGuestRPHs = $resGuestRPHs;
        return $this;
    }
    /**
     * Get Memberships value
     * @return \ArrayType\ArrayOfMembershipTypeMembership|null
     */
    public function getMemberships()
    {
        return $this->Memberships;
    }
    /**
     * Set Memberships value
     * @param \ArrayType\ArrayOfMembershipTypeMembership $memberships
     * @return \StructType\ResCommonDetailType
     */
    public function setMemberships(\ArrayType\ArrayOfMembershipTypeMembership $memberships = null)
    {
        $this->Memberships = $memberships;
        return $this;
    }
    /**
     * Get Comments value
     * @return \ArrayType\ArrayOfCommentTypeComment|null
     */
    public function getComments()
    {
        return $this->Comments;
    }
    /**
     * Set Comments value
     * @param \ArrayType\ArrayOfCommentTypeComment $comments
     * @return \StructType\ResCommonDetailType
     */
    public function setComments(\ArrayType\ArrayOfCommentTypeComment $comments = null)
    {
        $this->Comments = $comments;
        return $this;
    }
    /**
     * Get SpecialRequests value
     * @return \ArrayType\ArrayOfSpecialRequestTypeSpecialRequest|null
     */
    public function getSpecialRequests()
    {
        return $this->SpecialRequests;
    }
    /**
     * Set SpecialRequests value
     * @param \ArrayType\ArrayOfSpecialRequestTypeSpecialRequest $specialRequests
     * @return \StructType\ResCommonDetailType
     */
    public function setSpecialRequests(\ArrayType\ArrayOfSpecialRequestTypeSpecialRequest $specialRequests = null)
    {
        $this->SpecialRequests = $specialRequests;
        return $this;
    }
    /**
     * Get Guarantee value
     * @return string|null
     */
    public function getGuarantee()
    {
        return $this->Guarantee;
    }
    /**
     * Set Guarantee value
     * @uses \EnumType\GuaranteeType::valueIsValid()
     * @uses \EnumType\GuaranteeType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $guarantee
     * @return \StructType\ResCommonDetailType
     */
    public function setGuarantee($guarantee = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\GuaranteeType::valueIsValid($guarantee)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $guarantee, implode(', ', \EnumType\GuaranteeType::getValidValues())), __LINE__);
        }
        $this->Guarantee = $guarantee;
        return $this;
    }
    /**
     * Get DepositPayments value
     * @return \ArrayType\ArrayOfRequiredPaymentsTypeGuaranteePayment|null
     */
    public function getDepositPayments()
    {
        return $this->DepositPayments;
    }
    /**
     * Set DepositPayments value
     * @param \ArrayType\ArrayOfRequiredPaymentsTypeGuaranteePayment $depositPayments
     * @return \StructType\ResCommonDetailType
     */
    public function setDepositPayments(\ArrayType\ArrayOfRequiredPaymentsTypeGuaranteePayment $depositPayments = null)
    {
        $this->DepositPayments = $depositPayments;
        return $this;
    }
    /**
     * Get CancelPenalties value
     * @return \StructType\CancelPenaltiesType|null
     */
    public function getCancelPenalties()
    {
        return $this->CancelPenalties;
    }
    /**
     * Set CancelPenalties value
     * @param \StructType\CancelPenaltiesType $cancelPenalties
     * @return \StructType\ResCommonDetailType
     */
    public function setCancelPenalties(\StructType\CancelPenaltiesType $cancelPenalties = null)
    {
        $this->CancelPenalties = $cancelPenalties;
        return $this;
    }
    /**
     * Get Fees value
     * @return \ArrayType\ArrayOfFeeType|null
     */
    public function getFees()
    {
        return $this->Fees;
    }
    /**
     * Set Fees value
     * @param \ArrayType\ArrayOfFeeType $fees
     * @return \StructType\ResCommonDetailType
     */
    public function setFees(\ArrayType\ArrayOfFeeType $fees = null)
    {
        $this->Fees = $fees;
        return $this;
    }
    /**
     * Get Total value
     * @return \StructType\TotalType|null
     */
    public function getTotal()
    {
        return $this->Total;
    }
    /**
     * Set Total value
     * @param \StructType\TotalType $total
     * @return \StructType\ResCommonDetailType
     */
    public function setTotal(\StructType\TotalType $total = null)
    {
        $this->Total = $total;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\ResCommonDetailType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
