<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PropertyManagerRequestType StructType
 * @subpackage Structs
 */
class PropertyManagerRequestType extends AbstractStructBase
{
    /**
     * The PropertyManagerCode
     * @var string
     */
    public $PropertyManagerCode;
    /**
     * The CountryCodeList
     * @var string[]
     */
    public $CountryCodeList;
    /**
     * The StateCodeList
     * @var string[]
     */
    public $StateCodeList;
    /**
     * Constructor method for PropertyManagerRequestType
     * @uses PropertyManagerRequestType::setPropertyManagerCode()
     * @uses PropertyManagerRequestType::setCountryCodeList()
     * @uses PropertyManagerRequestType::setStateCodeList()
     * @param string $propertyManagerCode
     * @param string[] $countryCodeList
     * @param string[] $stateCodeList
     */
    public function __construct($propertyManagerCode = null, array $countryCodeList = array(), array $stateCodeList = array())
    {
        $this
            ->setPropertyManagerCode($propertyManagerCode)
            ->setCountryCodeList($countryCodeList)
            ->setStateCodeList($stateCodeList);
    }
    /**
     * Get PropertyManagerCode value
     * @return string|null
     */
    public function getPropertyManagerCode()
    {
        return $this->PropertyManagerCode;
    }
    /**
     * Set PropertyManagerCode value
     * @param string $propertyManagerCode
     * @return \StructType\PropertyManagerRequestType
     */
    public function setPropertyManagerCode($propertyManagerCode = null)
    {
        // validation for constraint: string
        if (!is_null($propertyManagerCode) && !is_string($propertyManagerCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($propertyManagerCode)), __LINE__);
        }
        $this->PropertyManagerCode = $propertyManagerCode;
        return $this;
    }
    /**
     * Get CountryCodeList value
     * @return string[]|null
     */
    public function getCountryCodeList()
    {
        return $this->CountryCodeList;
    }
    /**
     * Set CountryCodeList value
     * @throws \InvalidArgumentException
     * @param string[] $countryCodeList
     * @return \StructType\PropertyManagerRequestType
     */
    public function setCountryCodeList(array $countryCodeList = array())
    {
        foreach ($countryCodeList as $propertyManagerRequestTypeCountryCodeListItem) {
            // validation for constraint: itemType
            if (!is_string($propertyManagerRequestTypeCountryCodeListItem)) {
                throw new \InvalidArgumentException(sprintf('The CountryCodeList property can only contain items of string, "%s" given', is_object($propertyManagerRequestTypeCountryCodeListItem) ? get_class($propertyManagerRequestTypeCountryCodeListItem) : gettype($propertyManagerRequestTypeCountryCodeListItem)), __LINE__);
            }
        }
        $this->CountryCodeList = $countryCodeList;
        return $this;
    }
    /**
     * Add item to CountryCodeList value
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \StructType\PropertyManagerRequestType
     */
    public function addToCountryCodeList($item)
    {
        // validation for constraint: itemType
        if (!is_string($item)) {
            throw new \InvalidArgumentException(sprintf('The CountryCodeList property can only contain items of string, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->CountryCodeList[] = $item;
        return $this;
    }
    /**
     * Get StateCodeList value
     * @return string[]|null
     */
    public function getStateCodeList()
    {
        return $this->StateCodeList;
    }
    /**
     * Set StateCodeList value
     * @throws \InvalidArgumentException
     * @param string[] $stateCodeList
     * @return \StructType\PropertyManagerRequestType
     */
    public function setStateCodeList(array $stateCodeList = array())
    {
        foreach ($stateCodeList as $propertyManagerRequestTypeStateCodeListItem) {
            // validation for constraint: itemType
            if (!is_string($propertyManagerRequestTypeStateCodeListItem)) {
                throw new \InvalidArgumentException(sprintf('The StateCodeList property can only contain items of string, "%s" given', is_object($propertyManagerRequestTypeStateCodeListItem) ? get_class($propertyManagerRequestTypeStateCodeListItem) : gettype($propertyManagerRequestTypeStateCodeListItem)), __LINE__);
            }
        }
        $this->StateCodeList = $stateCodeList;
        return $this;
    }
    /**
     * Add item to StateCodeList value
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \StructType\PropertyManagerRequestType
     */
    public function addToStateCodeList($item)
    {
        // validation for constraint: itemType
        if (!is_string($item)) {
            throw new \InvalidArgumentException(sprintf('The StateCodeList property can only contain items of string, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->StateCodeList[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\PropertyManagerRequestType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
