<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ProfileType StructType
 * @subpackage Structs
 */
class ProfileType extends AbstractStructBase
{
    /**
     * The Accesses
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\AccessesType
     */
    public $Accesses;
    /**
     * The Customer
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\CustomerType
     */
    public $Customer;
    /**
     * The PrefCollections
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\PreferencesType
     */
    public $PrefCollections;
    /**
     * The CompanyInfo
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\CompanyInfoType
     */
    public $CompanyInfo;
    /**
     * The Affiliations
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\AffiliationsType
     */
    public $Affiliations;
    /**
     * The Agreements
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\AgreementsType
     */
    public $Agreements;
    /**
     * The TPA_Extensions
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\TPA_Extensions_Type
     */
    public $TPA_Extensions;
    /**
     * The ShareAllSynchInd
     * Meta informations extracted from the WSDL
     * - default: No
     * @var string
     */
    public $ShareAllSynchInd;
    /**
     * The ShareAllMarketInd
     * Meta informations extracted from the WSDL
     * - default: No
     * @var string
     */
    public $ShareAllMarketInd;
    /**
     * The ProfileType
     * @var string
     */
    public $ProfileType;
    /**
     * The CreateDateTime
     * @var string
     */
    public $CreateDateTime;
    /**
     * The CreatorID
     * @var string
     */
    public $CreatorID;
    /**
     * The LastModifyDateTime
     * @var string
     */
    public $LastModifyDateTime;
    /**
     * The LastModifierID
     * @var string
     */
    public $LastModifierID;
    /**
     * The RPH
     * @var string
     */
    public $RPH;
    /**
     * Constructor method for ProfileType
     * @uses ProfileType::setAccesses()
     * @uses ProfileType::setCustomer()
     * @uses ProfileType::setPrefCollections()
     * @uses ProfileType::setCompanyInfo()
     * @uses ProfileType::setAffiliations()
     * @uses ProfileType::setAgreements()
     * @uses ProfileType::setTPA_Extensions()
     * @uses ProfileType::setShareAllSynchInd()
     * @uses ProfileType::setShareAllMarketInd()
     * @uses ProfileType::setProfileType()
     * @uses ProfileType::setCreateDateTime()
     * @uses ProfileType::setCreatorID()
     * @uses ProfileType::setLastModifyDateTime()
     * @uses ProfileType::setLastModifierID()
     * @uses ProfileType::setRPH()
     * @param \StructType\AccessesType $accesses
     * @param \StructType\CustomerType $customer
     * @param \StructType\PreferencesType $prefCollections
     * @param \StructType\CompanyInfoType $companyInfo
     * @param \StructType\AffiliationsType $affiliations
     * @param \StructType\AgreementsType $agreements
     * @param \StructType\TPA_Extensions_Type $tPA_Extensions
     * @param string $shareAllSynchInd
     * @param string $shareAllMarketInd
     * @param string $profileType
     * @param string $createDateTime
     * @param string $creatorID
     * @param string $lastModifyDateTime
     * @param string $lastModifierID
     * @param string $rPH
     */
    public function __construct(\StructType\AccessesType $accesses = null, \StructType\CustomerType $customer = null, \StructType\PreferencesType $prefCollections = null, \StructType\CompanyInfoType $companyInfo = null, \StructType\AffiliationsType $affiliations = null, \StructType\AgreementsType $agreements = null, \StructType\TPA_Extensions_Type $tPA_Extensions = null, $shareAllSynchInd = 'No', $shareAllMarketInd = 'No', $profileType = null, $createDateTime = null, $creatorID = null, $lastModifyDateTime = null, $lastModifierID = null, $rPH = null)
    {
        $this
            ->setAccesses($accesses)
            ->setCustomer($customer)
            ->setPrefCollections($prefCollections)
            ->setCompanyInfo($companyInfo)
            ->setAffiliations($affiliations)
            ->setAgreements($agreements)
            ->setTPA_Extensions($tPA_Extensions)
            ->setShareAllSynchInd($shareAllSynchInd)
            ->setShareAllMarketInd($shareAllMarketInd)
            ->setProfileType($profileType)
            ->setCreateDateTime($createDateTime)
            ->setCreatorID($creatorID)
            ->setLastModifyDateTime($lastModifyDateTime)
            ->setLastModifierID($lastModifierID)
            ->setRPH($rPH);
    }
    /**
     * Get Accesses value
     * @return \StructType\AccessesType|null
     */
    public function getAccesses()
    {
        return $this->Accesses;
    }
    /**
     * Set Accesses value
     * @param \StructType\AccessesType $accesses
     * @return \StructType\ProfileType
     */
    public function setAccesses(\StructType\AccessesType $accesses = null)
    {
        $this->Accesses = $accesses;
        return $this;
    }
    /**
     * Get Customer value
     * @return \StructType\CustomerType|null
     */
    public function getCustomer()
    {
        return $this->Customer;
    }
    /**
     * Set Customer value
     * @param \StructType\CustomerType $customer
     * @return \StructType\ProfileType
     */
    public function setCustomer(\StructType\CustomerType $customer = null)
    {
        $this->Customer = $customer;
        return $this;
    }
    /**
     * Get PrefCollections value
     * @return \StructType\PreferencesType|null
     */
    public function getPrefCollections()
    {
        return $this->PrefCollections;
    }
    /**
     * Set PrefCollections value
     * @param \StructType\PreferencesType $prefCollections
     * @return \StructType\ProfileType
     */
    public function setPrefCollections(\StructType\PreferencesType $prefCollections = null)
    {
        $this->PrefCollections = $prefCollections;
        return $this;
    }
    /**
     * Get CompanyInfo value
     * @return \StructType\CompanyInfoType|null
     */
    public function getCompanyInfo()
    {
        return $this->CompanyInfo;
    }
    /**
     * Set CompanyInfo value
     * @param \StructType\CompanyInfoType $companyInfo
     * @return \StructType\ProfileType
     */
    public function setCompanyInfo(\StructType\CompanyInfoType $companyInfo = null)
    {
        $this->CompanyInfo = $companyInfo;
        return $this;
    }
    /**
     * Get Affiliations value
     * @return \StructType\AffiliationsType|null
     */
    public function getAffiliations()
    {
        return $this->Affiliations;
    }
    /**
     * Set Affiliations value
     * @param \StructType\AffiliationsType $affiliations
     * @return \StructType\ProfileType
     */
    public function setAffiliations(\StructType\AffiliationsType $affiliations = null)
    {
        $this->Affiliations = $affiliations;
        return $this;
    }
    /**
     * Get Agreements value
     * @return \StructType\AgreementsType|null
     */
    public function getAgreements()
    {
        return $this->Agreements;
    }
    /**
     * Set Agreements value
     * @param \StructType\AgreementsType $agreements
     * @return \StructType\ProfileType
     */
    public function setAgreements(\StructType\AgreementsType $agreements = null)
    {
        $this->Agreements = $agreements;
        return $this;
    }
    /**
     * Get TPA_Extensions value
     * @return \StructType\TPA_Extensions_Type|null
     */
    public function getTPA_Extensions()
    {
        return $this->TPA_Extensions;
    }
    /**
     * Set TPA_Extensions value
     * @param \StructType\TPA_Extensions_Type $tPA_Extensions
     * @return \StructType\ProfileType
     */
    public function setTPA_Extensions(\StructType\TPA_Extensions_Type $tPA_Extensions = null)
    {
        $this->TPA_Extensions = $tPA_Extensions;
        return $this;
    }
    /**
     * Get ShareAllSynchInd value
     * @return string|null
     */
    public function getShareAllSynchInd()
    {
        return $this->ShareAllSynchInd;
    }
    /**
     * Set ShareAllSynchInd value
     * @uses \EnumType\YesNoType::valueIsValid()
     * @uses \EnumType\YesNoType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $shareAllSynchInd
     * @return \StructType\ProfileType
     */
    public function setShareAllSynchInd($shareAllSynchInd = 'No')
    {
        // validation for constraint: enumeration
        if (!\EnumType\YesNoType::valueIsValid($shareAllSynchInd)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $shareAllSynchInd, implode(', ', \EnumType\YesNoType::getValidValues())), __LINE__);
        }
        $this->ShareAllSynchInd = $shareAllSynchInd;
        return $this;
    }
    /**
     * Get ShareAllMarketInd value
     * @return string|null
     */
    public function getShareAllMarketInd()
    {
        return $this->ShareAllMarketInd;
    }
    /**
     * Set ShareAllMarketInd value
     * @uses \EnumType\YesNoType::valueIsValid()
     * @uses \EnumType\YesNoType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $shareAllMarketInd
     * @return \StructType\ProfileType
     */
    public function setShareAllMarketInd($shareAllMarketInd = 'No')
    {
        // validation for constraint: enumeration
        if (!\EnumType\YesNoType::valueIsValid($shareAllMarketInd)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $shareAllMarketInd, implode(', ', \EnumType\YesNoType::getValidValues())), __LINE__);
        }
        $this->ShareAllMarketInd = $shareAllMarketInd;
        return $this;
    }
    /**
     * Get ProfileType value
     * @return string|null
     */
    public function getProfileType()
    {
        return $this->ProfileType;
    }
    /**
     * Set ProfileType value
     * @param string $profileType
     * @return \StructType\ProfileType
     */
    public function setProfileType($profileType = null)
    {
        // validation for constraint: string
        if (!is_null($profileType) && !is_string($profileType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($profileType)), __LINE__);
        }
        $this->ProfileType = $profileType;
        return $this;
    }
    /**
     * Get CreateDateTime value
     * @return string|null
     */
    public function getCreateDateTime()
    {
        return $this->CreateDateTime;
    }
    /**
     * Set CreateDateTime value
     * @param string $createDateTime
     * @return \StructType\ProfileType
     */
    public function setCreateDateTime($createDateTime = null)
    {
        // validation for constraint: string
        if (!is_null($createDateTime) && !is_string($createDateTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($createDateTime)), __LINE__);
        }
        $this->CreateDateTime = $createDateTime;
        return $this;
    }
    /**
     * Get CreatorID value
     * @return string|null
     */
    public function getCreatorID()
    {
        return $this->CreatorID;
    }
    /**
     * Set CreatorID value
     * @param string $creatorID
     * @return \StructType\ProfileType
     */
    public function setCreatorID($creatorID = null)
    {
        // validation for constraint: string
        if (!is_null($creatorID) && !is_string($creatorID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($creatorID)), __LINE__);
        }
        $this->CreatorID = $creatorID;
        return $this;
    }
    /**
     * Get LastModifyDateTime value
     * @return string|null
     */
    public function getLastModifyDateTime()
    {
        return $this->LastModifyDateTime;
    }
    /**
     * Set LastModifyDateTime value
     * @param string $lastModifyDateTime
     * @return \StructType\ProfileType
     */
    public function setLastModifyDateTime($lastModifyDateTime = null)
    {
        // validation for constraint: string
        if (!is_null($lastModifyDateTime) && !is_string($lastModifyDateTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($lastModifyDateTime)), __LINE__);
        }
        $this->LastModifyDateTime = $lastModifyDateTime;
        return $this;
    }
    /**
     * Get LastModifierID value
     * @return string|null
     */
    public function getLastModifierID()
    {
        return $this->LastModifierID;
    }
    /**
     * Set LastModifierID value
     * @param string $lastModifierID
     * @return \StructType\ProfileType
     */
    public function setLastModifierID($lastModifierID = null)
    {
        // validation for constraint: string
        if (!is_null($lastModifierID) && !is_string($lastModifierID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($lastModifierID)), __LINE__);
        }
        $this->LastModifierID = $lastModifierID;
        return $this;
    }
    /**
     * Get RPH value
     * @return string|null
     */
    public function getRPH()
    {
        return $this->RPH;
    }
    /**
     * Set RPH value
     * @param string $rPH
     * @return \StructType\ProfileType
     */
    public function setRPH($rPH = null)
    {
        // validation for constraint: string
        if (!is_null($rPH) && !is_string($rPH)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($rPH)), __LINE__);
        }
        $this->RPH = $rPH;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\ProfileType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
