<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PaymentFormType StructType
 * @subpackage Structs
 */
class PaymentFormType extends AbstractStructBase
{
    /**
     * The DirectBill
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\DirectBillType
     */
    public $DirectBill;
    /**
     * The LoyaltyRedemption
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\LoyaltyRedemption
     */
    public $LoyaltyRedemption;
    /**
     * The PaymentCard
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\PaymentCardType
     */
    public $PaymentCard;
    /**
     * The Voucher
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Voucher
     */
    public $Voucher;
    /**
     * The MiscChargeOrder
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\MiscChargeOrder
     */
    public $MiscChargeOrder;
    /**
     * The BankAcct
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\BankAcctType
     */
    public $BankAcct;
    /**
     * The Cash
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Cash
     */
    public $Cash;
    /**
     * The ShareSynchInd
     * @var string
     */
    public $ShareSynchInd;
    /**
     * The ShareMarketInd
     * @var string
     */
    public $ShareMarketInd;
    /**
     * The CostCenterID
     * @var string
     */
    public $CostCenterID;
    /**
     * The RPH
     * @var string
     */
    public $RPH;
    /**
     * The PaymentTransactionTypeCode
     * @var string
     */
    public $PaymentTransactionTypeCode;
    /**
     * Constructor method for PaymentFormType
     * @uses PaymentFormType::setDirectBill()
     * @uses PaymentFormType::setLoyaltyRedemption()
     * @uses PaymentFormType::setPaymentCard()
     * @uses PaymentFormType::setVoucher()
     * @uses PaymentFormType::setMiscChargeOrder()
     * @uses PaymentFormType::setBankAcct()
     * @uses PaymentFormType::setCash()
     * @uses PaymentFormType::setShareSynchInd()
     * @uses PaymentFormType::setShareMarketInd()
     * @uses PaymentFormType::setCostCenterID()
     * @uses PaymentFormType::setRPH()
     * @uses PaymentFormType::setPaymentTransactionTypeCode()
     * @param \StructType\DirectBillType $directBill
     * @param \StructType\LoyaltyRedemption $loyaltyRedemption
     * @param \StructType\PaymentCardType $paymentCard
     * @param \StructType\Voucher $voucher
     * @param \StructType\MiscChargeOrder $miscChargeOrder
     * @param \StructType\BankAcctType $bankAcct
     * @param \StructType\Cash $cash
     * @param string $shareSynchInd
     * @param string $shareMarketInd
     * @param string $costCenterID
     * @param string $rPH
     * @param string $paymentTransactionTypeCode
     */
    public function __construct(\StructType\DirectBillType $directBill = null, \StructType\LoyaltyRedemption $loyaltyRedemption = null, \StructType\PaymentCardType $paymentCard = null, \StructType\Voucher $voucher = null, \StructType\MiscChargeOrder $miscChargeOrder = null, \StructType\BankAcctType $bankAcct = null, \StructType\Cash $cash = null, $shareSynchInd = null, $shareMarketInd = null, $costCenterID = null, $rPH = null, $paymentTransactionTypeCode = null)
    {
        $this
            ->setDirectBill($directBill)
            ->setLoyaltyRedemption($loyaltyRedemption)
            ->setPaymentCard($paymentCard)
            ->setVoucher($voucher)
            ->setMiscChargeOrder($miscChargeOrder)
            ->setBankAcct($bankAcct)
            ->setCash($cash)
            ->setShareSynchInd($shareSynchInd)
            ->setShareMarketInd($shareMarketInd)
            ->setCostCenterID($costCenterID)
            ->setRPH($rPH)
            ->setPaymentTransactionTypeCode($paymentTransactionTypeCode);
    }
    /**
     * Get DirectBill value
     * @return \StructType\DirectBillType|null
     */
    public function getDirectBill()
    {
        return $this->DirectBill;
    }
    /**
     * Set DirectBill value
     * @param \StructType\DirectBillType $directBill
     * @return \StructType\PaymentFormType
     */
    public function setDirectBill(\StructType\DirectBillType $directBill = null)
    {
        $this->DirectBill = $directBill;
        return $this;
    }
    /**
     * Get LoyaltyRedemption value
     * @return \StructType\LoyaltyRedemption|null
     */
    public function getLoyaltyRedemption()
    {
        return $this->LoyaltyRedemption;
    }
    /**
     * Set LoyaltyRedemption value
     * @param \StructType\LoyaltyRedemption $loyaltyRedemption
     * @return \StructType\PaymentFormType
     */
    public function setLoyaltyRedemption(\StructType\LoyaltyRedemption $loyaltyRedemption = null)
    {
        $this->LoyaltyRedemption = $loyaltyRedemption;
        return $this;
    }
    /**
     * Get PaymentCard value
     * @return \StructType\PaymentCardType|null
     */
    public function getPaymentCard()
    {
        return $this->PaymentCard;
    }
    /**
     * Set PaymentCard value
     * @param \StructType\PaymentCardType $paymentCard
     * @return \StructType\PaymentFormType
     */
    public function setPaymentCard(\StructType\PaymentCardType $paymentCard = null)
    {
        $this->PaymentCard = $paymentCard;
        return $this;
    }
    /**
     * Get Voucher value
     * @return \StructType\Voucher|null
     */
    public function getVoucher()
    {
        return $this->Voucher;
    }
    /**
     * Set Voucher value
     * @param \StructType\Voucher $voucher
     * @return \StructType\PaymentFormType
     */
    public function setVoucher(\StructType\Voucher $voucher = null)
    {
        $this->Voucher = $voucher;
        return $this;
    }
    /**
     * Get MiscChargeOrder value
     * @return \StructType\MiscChargeOrder|null
     */
    public function getMiscChargeOrder()
    {
        return $this->MiscChargeOrder;
    }
    /**
     * Set MiscChargeOrder value
     * @param \StructType\MiscChargeOrder $miscChargeOrder
     * @return \StructType\PaymentFormType
     */
    public function setMiscChargeOrder(\StructType\MiscChargeOrder $miscChargeOrder = null)
    {
        $this->MiscChargeOrder = $miscChargeOrder;
        return $this;
    }
    /**
     * Get BankAcct value
     * @return \StructType\BankAcctType|null
     */
    public function getBankAcct()
    {
        return $this->BankAcct;
    }
    /**
     * Set BankAcct value
     * @param \StructType\BankAcctType $bankAcct
     * @return \StructType\PaymentFormType
     */
    public function setBankAcct(\StructType\BankAcctType $bankAcct = null)
    {
        $this->BankAcct = $bankAcct;
        return $this;
    }
    /**
     * Get Cash value
     * @return \StructType\Cash|null
     */
    public function getCash()
    {
        return $this->Cash;
    }
    /**
     * Set Cash value
     * @param \StructType\Cash $cash
     * @return \StructType\PaymentFormType
     */
    public function setCash(\StructType\Cash $cash = null)
    {
        $this->Cash = $cash;
        return $this;
    }
    /**
     * Get ShareSynchInd value
     * @return string|null
     */
    public function getShareSynchInd()
    {
        return $this->ShareSynchInd;
    }
    /**
     * Set ShareSynchInd value
     * @param string $shareSynchInd
     * @return \StructType\PaymentFormType
     */
    public function setShareSynchInd($shareSynchInd = null)
    {
        // validation for constraint: string
        if (!is_null($shareSynchInd) && !is_string($shareSynchInd)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($shareSynchInd)), __LINE__);
        }
        $this->ShareSynchInd = $shareSynchInd;
        return $this;
    }
    /**
     * Get ShareMarketInd value
     * @return string|null
     */
    public function getShareMarketInd()
    {
        return $this->ShareMarketInd;
    }
    /**
     * Set ShareMarketInd value
     * @param string $shareMarketInd
     * @return \StructType\PaymentFormType
     */
    public function setShareMarketInd($shareMarketInd = null)
    {
        // validation for constraint: string
        if (!is_null($shareMarketInd) && !is_string($shareMarketInd)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($shareMarketInd)), __LINE__);
        }
        $this->ShareMarketInd = $shareMarketInd;
        return $this;
    }
    /**
     * Get CostCenterID value
     * @return string|null
     */
    public function getCostCenterID()
    {
        return $this->CostCenterID;
    }
    /**
     * Set CostCenterID value
     * @param string $costCenterID
     * @return \StructType\PaymentFormType
     */
    public function setCostCenterID($costCenterID = null)
    {
        // validation for constraint: string
        if (!is_null($costCenterID) && !is_string($costCenterID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($costCenterID)), __LINE__);
        }
        $this->CostCenterID = $costCenterID;
        return $this;
    }
    /**
     * Get RPH value
     * @return string|null
     */
    public function getRPH()
    {
        return $this->RPH;
    }
    /**
     * Set RPH value
     * @param string $rPH
     * @return \StructType\PaymentFormType
     */
    public function setRPH($rPH = null)
    {
        // validation for constraint: string
        if (!is_null($rPH) && !is_string($rPH)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($rPH)), __LINE__);
        }
        $this->RPH = $rPH;
        return $this;
    }
    /**
     * Get PaymentTransactionTypeCode value
     * @return string|null
     */
    public function getPaymentTransactionTypeCode()
    {
        return $this->PaymentTransactionTypeCode;
    }
    /**
     * Set PaymentTransactionTypeCode value
     * @param string $paymentTransactionTypeCode
     * @return \StructType\PaymentFormType
     */
    public function setPaymentTransactionTypeCode($paymentTransactionTypeCode = null)
    {
        // validation for constraint: string
        if (!is_null($paymentTransactionTypeCode) && !is_string($paymentTransactionTypeCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($paymentTransactionTypeCode)), __LINE__);
        }
        $this->PaymentTransactionTypeCode = $paymentTransactionTypeCode;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\PaymentFormType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
