<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for OrganizationType StructType
 * @subpackage Structs
 */
class OrganizationType extends AbstractStructBase
{
    /**
     * The OrgMemberName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\OrgMemberName
     */
    public $OrgMemberName;
    /**
     * The OrgName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\CompanyNameType
     */
    public $OrgName;
    /**
     * The RelatedOrgName
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\CompanyNameType[]
     */
    public $RelatedOrgName;
    /**
     * The TravelArranger
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\TravelArrangerType[]
     */
    public $TravelArranger;
    /**
     * The DefaultInd
     * Meta informations extracted from the WSDL
     * - default: false
     * @var bool
     */
    public $DefaultInd;
    /**
     * The ShareSynchInd
     * @var string
     */
    public $ShareSynchInd;
    /**
     * The ShareMarketInd
     * @var string
     */
    public $ShareMarketInd;
    /**
     * The EffectiveDate
     * @var string
     */
    public $EffectiveDate;
    /**
     * The ExpireDate
     * @var string
     */
    public $ExpireDate;
    /**
     * The OfficeType
     * @var string
     */
    public $OfficeType;
    /**
     * Constructor method for OrganizationType
     * @uses OrganizationType::setOrgMemberName()
     * @uses OrganizationType::setOrgName()
     * @uses OrganizationType::setRelatedOrgName()
     * @uses OrganizationType::setTravelArranger()
     * @uses OrganizationType::setDefaultInd()
     * @uses OrganizationType::setShareSynchInd()
     * @uses OrganizationType::setShareMarketInd()
     * @uses OrganizationType::setEffectiveDate()
     * @uses OrganizationType::setExpireDate()
     * @uses OrganizationType::setOfficeType()
     * @param \StructType\OrgMemberName $orgMemberName
     * @param \StructType\CompanyNameType $orgName
     * @param \StructType\CompanyNameType[] $relatedOrgName
     * @param \StructType\TravelArrangerType[] $travelArranger
     * @param bool $defaultInd
     * @param string $shareSynchInd
     * @param string $shareMarketInd
     * @param string $effectiveDate
     * @param string $expireDate
     * @param string $officeType
     */
    public function __construct(\StructType\OrgMemberName $orgMemberName = null, \StructType\CompanyNameType $orgName = null, array $relatedOrgName = array(), array $travelArranger = array(), $defaultInd = false, $shareSynchInd = null, $shareMarketInd = null, $effectiveDate = null, $expireDate = null, $officeType = null)
    {
        $this
            ->setOrgMemberName($orgMemberName)
            ->setOrgName($orgName)
            ->setRelatedOrgName($relatedOrgName)
            ->setTravelArranger($travelArranger)
            ->setDefaultInd($defaultInd)
            ->setShareSynchInd($shareSynchInd)
            ->setShareMarketInd($shareMarketInd)
            ->setEffectiveDate($effectiveDate)
            ->setExpireDate($expireDate)
            ->setOfficeType($officeType);
    }
    /**
     * Get OrgMemberName value
     * @return \StructType\OrgMemberName|null
     */
    public function getOrgMemberName()
    {
        return $this->OrgMemberName;
    }
    /**
     * Set OrgMemberName value
     * @param \StructType\OrgMemberName $orgMemberName
     * @return \StructType\OrganizationType
     */
    public function setOrgMemberName(\StructType\OrgMemberName $orgMemberName = null)
    {
        $this->OrgMemberName = $orgMemberName;
        return $this;
    }
    /**
     * Get OrgName value
     * @return \StructType\CompanyNameType|null
     */
    public function getOrgName()
    {
        return $this->OrgName;
    }
    /**
     * Set OrgName value
     * @param \StructType\CompanyNameType $orgName
     * @return \StructType\OrganizationType
     */
    public function setOrgName(\StructType\CompanyNameType $orgName = null)
    {
        $this->OrgName = $orgName;
        return $this;
    }
    /**
     * Get RelatedOrgName value
     * @return \StructType\CompanyNameType[]|null
     */
    public function getRelatedOrgName()
    {
        return $this->RelatedOrgName;
    }
    /**
     * Set RelatedOrgName value
     * @throws \InvalidArgumentException
     * @param \StructType\CompanyNameType[] $relatedOrgName
     * @return \StructType\OrganizationType
     */
    public function setRelatedOrgName(array $relatedOrgName = array())
    {
        foreach ($relatedOrgName as $organizationTypeRelatedOrgNameItem) {
            // validation for constraint: itemType
            if (!$organizationTypeRelatedOrgNameItem instanceof \StructType\CompanyNameType) {
                throw new \InvalidArgumentException(sprintf('The RelatedOrgName property can only contain items of \StructType\CompanyNameType, "%s" given', is_object($organizationTypeRelatedOrgNameItem) ? get_class($organizationTypeRelatedOrgNameItem) : gettype($organizationTypeRelatedOrgNameItem)), __LINE__);
            }
        }
        $this->RelatedOrgName = $relatedOrgName;
        return $this;
    }
    /**
     * Add item to RelatedOrgName value
     * @throws \InvalidArgumentException
     * @param \StructType\CompanyNameType $item
     * @return \StructType\OrganizationType
     */
    public function addToRelatedOrgName(\StructType\CompanyNameType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\CompanyNameType) {
            throw new \InvalidArgumentException(sprintf('The RelatedOrgName property can only contain items of \StructType\CompanyNameType, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->RelatedOrgName[] = $item;
        return $this;
    }
    /**
     * Get TravelArranger value
     * @return \StructType\TravelArrangerType[]|null
     */
    public function getTravelArranger()
    {
        return $this->TravelArranger;
    }
    /**
     * Set TravelArranger value
     * @throws \InvalidArgumentException
     * @param \StructType\TravelArrangerType[] $travelArranger
     * @return \StructType\OrganizationType
     */
    public function setTravelArranger(array $travelArranger = array())
    {
        foreach ($travelArranger as $organizationTypeTravelArrangerItem) {
            // validation for constraint: itemType
            if (!$organizationTypeTravelArrangerItem instanceof \StructType\TravelArrangerType) {
                throw new \InvalidArgumentException(sprintf('The TravelArranger property can only contain items of \StructType\TravelArrangerType, "%s" given', is_object($organizationTypeTravelArrangerItem) ? get_class($organizationTypeTravelArrangerItem) : gettype($organizationTypeTravelArrangerItem)), __LINE__);
            }
        }
        $this->TravelArranger = $travelArranger;
        return $this;
    }
    /**
     * Add item to TravelArranger value
     * @throws \InvalidArgumentException
     * @param \StructType\TravelArrangerType $item
     * @return \StructType\OrganizationType
     */
    public function addToTravelArranger(\StructType\TravelArrangerType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\TravelArrangerType) {
            throw new \InvalidArgumentException(sprintf('The TravelArranger property can only contain items of \StructType\TravelArrangerType, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->TravelArranger[] = $item;
        return $this;
    }
    /**
     * Get DefaultInd value
     * @return bool|null
     */
    public function getDefaultInd()
    {
        return $this->DefaultInd;
    }
    /**
     * Set DefaultInd value
     * @param bool $defaultInd
     * @return \StructType\OrganizationType
     */
    public function setDefaultInd($defaultInd = false)
    {
        $this->DefaultInd = $defaultInd;
        return $this;
    }
    /**
     * Get ShareSynchInd value
     * @return string|null
     */
    public function getShareSynchInd()
    {
        return $this->ShareSynchInd;
    }
    /**
     * Set ShareSynchInd value
     * @param string $shareSynchInd
     * @return \StructType\OrganizationType
     */
    public function setShareSynchInd($shareSynchInd = null)
    {
        // validation for constraint: string
        if (!is_null($shareSynchInd) && !is_string($shareSynchInd)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($shareSynchInd)), __LINE__);
        }
        $this->ShareSynchInd = $shareSynchInd;
        return $this;
    }
    /**
     * Get ShareMarketInd value
     * @return string|null
     */
    public function getShareMarketInd()
    {
        return $this->ShareMarketInd;
    }
    /**
     * Set ShareMarketInd value
     * @param string $shareMarketInd
     * @return \StructType\OrganizationType
     */
    public function setShareMarketInd($shareMarketInd = null)
    {
        // validation for constraint: string
        if (!is_null($shareMarketInd) && !is_string($shareMarketInd)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($shareMarketInd)), __LINE__);
        }
        $this->ShareMarketInd = $shareMarketInd;
        return $this;
    }
    /**
     * Get EffectiveDate value
     * @return string|null
     */
    public function getEffectiveDate()
    {
        return $this->EffectiveDate;
    }
    /**
     * Set EffectiveDate value
     * @param string $effectiveDate
     * @return \StructType\OrganizationType
     */
    public function setEffectiveDate($effectiveDate = null)
    {
        // validation for constraint: string
        if (!is_null($effectiveDate) && !is_string($effectiveDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($effectiveDate)), __LINE__);
        }
        $this->EffectiveDate = $effectiveDate;
        return $this;
    }
    /**
     * Get ExpireDate value
     * @return string|null
     */
    public function getExpireDate()
    {
        return $this->ExpireDate;
    }
    /**
     * Set ExpireDate value
     * @param string $expireDate
     * @return \StructType\OrganizationType
     */
    public function setExpireDate($expireDate = null)
    {
        // validation for constraint: string
        if (!is_null($expireDate) && !is_string($expireDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($expireDate)), __LINE__);
        }
        $this->ExpireDate = $expireDate;
        return $this;
    }
    /**
     * Get OfficeType value
     * @return string|null
     */
    public function getOfficeType()
    {
        return $this->OfficeType;
    }
    /**
     * Set OfficeType value
     * @uses \EnumType\OfficeLocationType::valueIsValid()
     * @uses \EnumType\OfficeLocationType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $officeType
     * @return \StructType\OrganizationType
     */
    public function setOfficeType($officeType = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\OfficeLocationType::valueIsValid($officeType)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $officeType, implode(', ', \EnumType\OfficeLocationType::getValidValues())), __LINE__);
        }
        $this->OfficeType = $officeType;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\OrganizationType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
