<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for MultimediaDescriptionType StructType
 * @subpackage Structs
 */
class MultimediaDescriptionType extends AbstractStructBase
{
    /**
     * The TextItems
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\TextItemsType
     */
    public $TextItems;
    /**
     * The ImageItems
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\ImageItemsType
     */
    public $ImageItems;
    /**
     * The VideoItems
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\VideoItems
     */
    public $VideoItems;
    /**
     * Constructor method for MultimediaDescriptionType
     * @uses MultimediaDescriptionType::setTextItems()
     * @uses MultimediaDescriptionType::setImageItems()
     * @uses MultimediaDescriptionType::setVideoItems()
     * @param \StructType\TextItemsType $textItems
     * @param \StructType\ImageItemsType $imageItems
     * @param \StructType\VideoItems $videoItems
     */
    public function __construct(\StructType\TextItemsType $textItems = null, \StructType\ImageItemsType $imageItems = null, \StructType\VideoItems $videoItems = null)
    {
        $this
            ->setTextItems($textItems)
            ->setImageItems($imageItems)
            ->setVideoItems($videoItems);
    }
    /**
     * Get TextItems value
     * @return \StructType\TextItemsType|null
     */
    public function getTextItems()
    {
        return $this->TextItems;
    }
    /**
     * Set TextItems value
     * @param \StructType\TextItemsType $textItems
     * @return \StructType\MultimediaDescriptionType
     */
    public function setTextItems(\StructType\TextItemsType $textItems = null)
    {
        $this->TextItems = $textItems;
        return $this;
    }
    /**
     * Get ImageItems value
     * @return \StructType\ImageItemsType|null
     */
    public function getImageItems()
    {
        return $this->ImageItems;
    }
    /**
     * Set ImageItems value
     * @param \StructType\ImageItemsType $imageItems
     * @return \StructType\MultimediaDescriptionType
     */
    public function setImageItems(\StructType\ImageItemsType $imageItems = null)
    {
        $this->ImageItems = $imageItems;
        return $this;
    }
    /**
     * Get VideoItems value
     * @return \StructType\VideoItems|null
     */
    public function getVideoItems()
    {
        return $this->VideoItems;
    }
    /**
     * Set VideoItems value
     * @param \StructType\VideoItems $videoItems
     * @return \StructType\MultimediaDescriptionType
     */
    public function setVideoItems(\StructType\VideoItems $videoItems = null)
    {
        $this->VideoItems = $videoItems;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\MultimediaDescriptionType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
