<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for HotelPrefType StructType
 * @subpackage Structs
 */
class HotelPrefType extends AbstractStructBase
{
    /**
     * The LoyaltyPref
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\LoyaltyPrefType[]
     */
    public $LoyaltyPref;
    /**
     * The PaymentFormPref
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\PaymentFormPrefType[]
     */
    public $PaymentFormPref;
    /**
     * The HotelChainPref
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\CompanyNamePrefType[]
     */
    public $HotelChainPref;
    /**
     * The PropertyNamePref
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\PropertyNamePrefType[]
     */
    public $PropertyNamePref;
    /**
     * The PropertyLocationPref
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\PropertyLocationPrefType[]
     */
    public $PropertyLocationPref;
    /**
     * The PropertyTypePref
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\PropertyTypePrefType[]
     */
    public $PropertyTypePref;
    /**
     * The PropertyClassPref
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\PropertyClassPrefType[]
     */
    public $PropertyClassPref;
    /**
     * The PropertyAmenityPref
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\PropertyAmenityPrefType[]
     */
    public $PropertyAmenityPref;
    /**
     * The RoomAmenityPref
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\RoomAmenityPrefType[]
     */
    public $RoomAmenityPref;
    /**
     * The RoomLocationPref
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\RoomLocationPrefType[]
     */
    public $RoomLocationPref;
    /**
     * The BedTypePref
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\BedTypePrefType[]
     */
    public $BedTypePref;
    /**
     * The FoodSrvcPref
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\FoodSrvcPrefType[]
     */
    public $FoodSrvcPref;
    /**
     * The MediaEntertainPref
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\MediaEntertainPrefType[]
     */
    public $MediaEntertainPref;
    /**
     * The PetInfoPref
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\PetInfoPrefType[]
     */
    public $PetInfoPref;
    /**
     * The MealPref
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\MealPrefType[]
     */
    public $MealPref;
    /**
     * The RecreationSrvcPref
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\RecreationSrvcPrefType[]
     */
    public $RecreationSrvcPref;
    /**
     * The BusinessSrvcPref
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\BusinessSrvcPrefType[]
     */
    public $BusinessSrvcPref;
    /**
     * The PersonalSrvcPref
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\PersonalSrvcPrefType[]
     */
    public $PersonalSrvcPref;
    /**
     * The SecurityFeaturePref
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\SecurityFeaturePrefType[]
     */
    public $SecurityFeaturePref;
    /**
     * The PhysChallFeaturePref
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\PhysChallFeaturePrefType[]
     */
    public $PhysChallFeaturePref;
    /**
     * The SpecRequestPref
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\SpecRequestPrefType[]
     */
    public $SpecRequestPref;
    /**
     * The TPA_Extensions
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\TPA_Extensions_Type
     */
    public $TPA_Extensions;
    /**
     * The PreferLevel
     * Meta informations extracted from the WSDL
     * - default: Preferred
     * @var string
     */
    public $PreferLevel;
    /**
     * The ShareSynchInd
     * @var string
     */
    public $ShareSynchInd;
    /**
     * The ShareMarketInd
     * @var string
     */
    public $ShareMarketInd;
    /**
     * The SmokingAllowed
     * Meta informations extracted from the WSDL
     * - default: false
     * @var bool
     */
    public $SmokingAllowed;
    /**
     * The RatePlanCode
     * @var string
     */
    public $RatePlanCode;
    /**
     * The HotelGuestType
     * @var string
     */
    public $HotelGuestType;
    /**
     * Constructor method for HotelPrefType
     * @uses HotelPrefType::setLoyaltyPref()
     * @uses HotelPrefType::setPaymentFormPref()
     * @uses HotelPrefType::setHotelChainPref()
     * @uses HotelPrefType::setPropertyNamePref()
     * @uses HotelPrefType::setPropertyLocationPref()
     * @uses HotelPrefType::setPropertyTypePref()
     * @uses HotelPrefType::setPropertyClassPref()
     * @uses HotelPrefType::setPropertyAmenityPref()
     * @uses HotelPrefType::setRoomAmenityPref()
     * @uses HotelPrefType::setRoomLocationPref()
     * @uses HotelPrefType::setBedTypePref()
     * @uses HotelPrefType::setFoodSrvcPref()
     * @uses HotelPrefType::setMediaEntertainPref()
     * @uses HotelPrefType::setPetInfoPref()
     * @uses HotelPrefType::setMealPref()
     * @uses HotelPrefType::setRecreationSrvcPref()
     * @uses HotelPrefType::setBusinessSrvcPref()
     * @uses HotelPrefType::setPersonalSrvcPref()
     * @uses HotelPrefType::setSecurityFeaturePref()
     * @uses HotelPrefType::setPhysChallFeaturePref()
     * @uses HotelPrefType::setSpecRequestPref()
     * @uses HotelPrefType::setTPA_Extensions()
     * @uses HotelPrefType::setPreferLevel()
     * @uses HotelPrefType::setShareSynchInd()
     * @uses HotelPrefType::setShareMarketInd()
     * @uses HotelPrefType::setSmokingAllowed()
     * @uses HotelPrefType::setRatePlanCode()
     * @uses HotelPrefType::setHotelGuestType()
     * @param \StructType\LoyaltyPrefType[] $loyaltyPref
     * @param \StructType\PaymentFormPrefType[] $paymentFormPref
     * @param \StructType\CompanyNamePrefType[] $hotelChainPref
     * @param \StructType\PropertyNamePrefType[] $propertyNamePref
     * @param \StructType\PropertyLocationPrefType[] $propertyLocationPref
     * @param \StructType\PropertyTypePrefType[] $propertyTypePref
     * @param \StructType\PropertyClassPrefType[] $propertyClassPref
     * @param \StructType\PropertyAmenityPrefType[] $propertyAmenityPref
     * @param \StructType\RoomAmenityPrefType[] $roomAmenityPref
     * @param \StructType\RoomLocationPrefType[] $roomLocationPref
     * @param \StructType\BedTypePrefType[] $bedTypePref
     * @param \StructType\FoodSrvcPrefType[] $foodSrvcPref
     * @param \StructType\MediaEntertainPrefType[] $mediaEntertainPref
     * @param \StructType\PetInfoPrefType[] $petInfoPref
     * @param \StructType\MealPrefType[] $mealPref
     * @param \StructType\RecreationSrvcPrefType[] $recreationSrvcPref
     * @param \StructType\BusinessSrvcPrefType[] $businessSrvcPref
     * @param \StructType\PersonalSrvcPrefType[] $personalSrvcPref
     * @param \StructType\SecurityFeaturePrefType[] $securityFeaturePref
     * @param \StructType\PhysChallFeaturePrefType[] $physChallFeaturePref
     * @param \StructType\SpecRequestPrefType[] $specRequestPref
     * @param \StructType\TPA_Extensions_Type $tPA_Extensions
     * @param string $preferLevel
     * @param string $shareSynchInd
     * @param string $shareMarketInd
     * @param bool $smokingAllowed
     * @param string $ratePlanCode
     * @param string $hotelGuestType
     */
    public function __construct(array $loyaltyPref = array(), array $paymentFormPref = array(), array $hotelChainPref = array(), array $propertyNamePref = array(), array $propertyLocationPref = array(), array $propertyTypePref = array(), array $propertyClassPref = array(), array $propertyAmenityPref = array(), array $roomAmenityPref = array(), array $roomLocationPref = array(), array $bedTypePref = array(), array $foodSrvcPref = array(), array $mediaEntertainPref = array(), array $petInfoPref = array(), array $mealPref = array(), array $recreationSrvcPref = array(), array $businessSrvcPref = array(), array $personalSrvcPref = array(), array $securityFeaturePref = array(), array $physChallFeaturePref = array(), array $specRequestPref = array(), \StructType\TPA_Extensions_Type $tPA_Extensions = null, $preferLevel = 'Preferred', $shareSynchInd = null, $shareMarketInd = null, $smokingAllowed = false, $ratePlanCode = null, $hotelGuestType = null)
    {
        $this
            ->setLoyaltyPref($loyaltyPref)
            ->setPaymentFormPref($paymentFormPref)
            ->setHotelChainPref($hotelChainPref)
            ->setPropertyNamePref($propertyNamePref)
            ->setPropertyLocationPref($propertyLocationPref)
            ->setPropertyTypePref($propertyTypePref)
            ->setPropertyClassPref($propertyClassPref)
            ->setPropertyAmenityPref($propertyAmenityPref)
            ->setRoomAmenityPref($roomAmenityPref)
            ->setRoomLocationPref($roomLocationPref)
            ->setBedTypePref($bedTypePref)
            ->setFoodSrvcPref($foodSrvcPref)
            ->setMediaEntertainPref($mediaEntertainPref)
            ->setPetInfoPref($petInfoPref)
            ->setMealPref($mealPref)
            ->setRecreationSrvcPref($recreationSrvcPref)
            ->setBusinessSrvcPref($businessSrvcPref)
            ->setPersonalSrvcPref($personalSrvcPref)
            ->setSecurityFeaturePref($securityFeaturePref)
            ->setPhysChallFeaturePref($physChallFeaturePref)
            ->setSpecRequestPref($specRequestPref)
            ->setTPA_Extensions($tPA_Extensions)
            ->setPreferLevel($preferLevel)
            ->setShareSynchInd($shareSynchInd)
            ->setShareMarketInd($shareMarketInd)
            ->setSmokingAllowed($smokingAllowed)
            ->setRatePlanCode($ratePlanCode)
            ->setHotelGuestType($hotelGuestType);
    }
    /**
     * Get LoyaltyPref value
     * @return \StructType\LoyaltyPrefType[]|null
     */
    public function getLoyaltyPref()
    {
        return $this->LoyaltyPref;
    }
    /**
     * Set LoyaltyPref value
     * @throws \InvalidArgumentException
     * @param \StructType\LoyaltyPrefType[] $loyaltyPref
     * @return \StructType\HotelPrefType
     */
    public function setLoyaltyPref(array $loyaltyPref = array())
    {
        foreach ($loyaltyPref as $hotelPrefTypeLoyaltyPrefItem) {
            // validation for constraint: itemType
            if (!$hotelPrefTypeLoyaltyPrefItem instanceof \StructType\LoyaltyPrefType) {
                throw new \InvalidArgumentException(sprintf('The LoyaltyPref property can only contain items of \StructType\LoyaltyPrefType, "%s" given', is_object($hotelPrefTypeLoyaltyPrefItem) ? get_class($hotelPrefTypeLoyaltyPrefItem) : gettype($hotelPrefTypeLoyaltyPrefItem)), __LINE__);
            }
        }
        $this->LoyaltyPref = $loyaltyPref;
        return $this;
    }
    /**
     * Add item to LoyaltyPref value
     * @throws \InvalidArgumentException
     * @param \StructType\LoyaltyPrefType $item
     * @return \StructType\HotelPrefType
     */
    public function addToLoyaltyPref(\StructType\LoyaltyPrefType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\LoyaltyPrefType) {
            throw new \InvalidArgumentException(sprintf('The LoyaltyPref property can only contain items of \StructType\LoyaltyPrefType, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->LoyaltyPref[] = $item;
        return $this;
    }
    /**
     * Get PaymentFormPref value
     * @return \StructType\PaymentFormPrefType[]|null
     */
    public function getPaymentFormPref()
    {
        return $this->PaymentFormPref;
    }
    /**
     * Set PaymentFormPref value
     * @throws \InvalidArgumentException
     * @param \StructType\PaymentFormPrefType[] $paymentFormPref
     * @return \StructType\HotelPrefType
     */
    public function setPaymentFormPref(array $paymentFormPref = array())
    {
        foreach ($paymentFormPref as $hotelPrefTypePaymentFormPrefItem) {
            // validation for constraint: itemType
            if (!$hotelPrefTypePaymentFormPrefItem instanceof \StructType\PaymentFormPrefType) {
                throw new \InvalidArgumentException(sprintf('The PaymentFormPref property can only contain items of \StructType\PaymentFormPrefType, "%s" given', is_object($hotelPrefTypePaymentFormPrefItem) ? get_class($hotelPrefTypePaymentFormPrefItem) : gettype($hotelPrefTypePaymentFormPrefItem)), __LINE__);
            }
        }
        $this->PaymentFormPref = $paymentFormPref;
        return $this;
    }
    /**
     * Add item to PaymentFormPref value
     * @throws \InvalidArgumentException
     * @param \StructType\PaymentFormPrefType $item
     * @return \StructType\HotelPrefType
     */
    public function addToPaymentFormPref(\StructType\PaymentFormPrefType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\PaymentFormPrefType) {
            throw new \InvalidArgumentException(sprintf('The PaymentFormPref property can only contain items of \StructType\PaymentFormPrefType, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->PaymentFormPref[] = $item;
        return $this;
    }
    /**
     * Get HotelChainPref value
     * @return \StructType\CompanyNamePrefType[]|null
     */
    public function getHotelChainPref()
    {
        return $this->HotelChainPref;
    }
    /**
     * Set HotelChainPref value
     * @throws \InvalidArgumentException
     * @param \StructType\CompanyNamePrefType[] $hotelChainPref
     * @return \StructType\HotelPrefType
     */
    public function setHotelChainPref(array $hotelChainPref = array())
    {
        foreach ($hotelChainPref as $hotelPrefTypeHotelChainPrefItem) {
            // validation for constraint: itemType
            if (!$hotelPrefTypeHotelChainPrefItem instanceof \StructType\CompanyNamePrefType) {
                throw new \InvalidArgumentException(sprintf('The HotelChainPref property can only contain items of \StructType\CompanyNamePrefType, "%s" given', is_object($hotelPrefTypeHotelChainPrefItem) ? get_class($hotelPrefTypeHotelChainPrefItem) : gettype($hotelPrefTypeHotelChainPrefItem)), __LINE__);
            }
        }
        $this->HotelChainPref = $hotelChainPref;
        return $this;
    }
    /**
     * Add item to HotelChainPref value
     * @throws \InvalidArgumentException
     * @param \StructType\CompanyNamePrefType $item
     * @return \StructType\HotelPrefType
     */
    public function addToHotelChainPref(\StructType\CompanyNamePrefType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\CompanyNamePrefType) {
            throw new \InvalidArgumentException(sprintf('The HotelChainPref property can only contain items of \StructType\CompanyNamePrefType, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->HotelChainPref[] = $item;
        return $this;
    }
    /**
     * Get PropertyNamePref value
     * @return \StructType\PropertyNamePrefType[]|null
     */
    public function getPropertyNamePref()
    {
        return $this->PropertyNamePref;
    }
    /**
     * Set PropertyNamePref value
     * @throws \InvalidArgumentException
     * @param \StructType\PropertyNamePrefType[] $propertyNamePref
     * @return \StructType\HotelPrefType
     */
    public function setPropertyNamePref(array $propertyNamePref = array())
    {
        foreach ($propertyNamePref as $hotelPrefTypePropertyNamePrefItem) {
            // validation for constraint: itemType
            if (!$hotelPrefTypePropertyNamePrefItem instanceof \StructType\PropertyNamePrefType) {
                throw new \InvalidArgumentException(sprintf('The PropertyNamePref property can only contain items of \StructType\PropertyNamePrefType, "%s" given', is_object($hotelPrefTypePropertyNamePrefItem) ? get_class($hotelPrefTypePropertyNamePrefItem) : gettype($hotelPrefTypePropertyNamePrefItem)), __LINE__);
            }
        }
        $this->PropertyNamePref = $propertyNamePref;
        return $this;
    }
    /**
     * Add item to PropertyNamePref value
     * @throws \InvalidArgumentException
     * @param \StructType\PropertyNamePrefType $item
     * @return \StructType\HotelPrefType
     */
    public function addToPropertyNamePref(\StructType\PropertyNamePrefType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\PropertyNamePrefType) {
            throw new \InvalidArgumentException(sprintf('The PropertyNamePref property can only contain items of \StructType\PropertyNamePrefType, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->PropertyNamePref[] = $item;
        return $this;
    }
    /**
     * Get PropertyLocationPref value
     * @return \StructType\PropertyLocationPrefType[]|null
     */
    public function getPropertyLocationPref()
    {
        return $this->PropertyLocationPref;
    }
    /**
     * Set PropertyLocationPref value
     * @throws \InvalidArgumentException
     * @param \StructType\PropertyLocationPrefType[] $propertyLocationPref
     * @return \StructType\HotelPrefType
     */
    public function setPropertyLocationPref(array $propertyLocationPref = array())
    {
        foreach ($propertyLocationPref as $hotelPrefTypePropertyLocationPrefItem) {
            // validation for constraint: itemType
            if (!$hotelPrefTypePropertyLocationPrefItem instanceof \StructType\PropertyLocationPrefType) {
                throw new \InvalidArgumentException(sprintf('The PropertyLocationPref property can only contain items of \StructType\PropertyLocationPrefType, "%s" given', is_object($hotelPrefTypePropertyLocationPrefItem) ? get_class($hotelPrefTypePropertyLocationPrefItem) : gettype($hotelPrefTypePropertyLocationPrefItem)), __LINE__);
            }
        }
        $this->PropertyLocationPref = $propertyLocationPref;
        return $this;
    }
    /**
     * Add item to PropertyLocationPref value
     * @throws \InvalidArgumentException
     * @param \StructType\PropertyLocationPrefType $item
     * @return \StructType\HotelPrefType
     */
    public function addToPropertyLocationPref(\StructType\PropertyLocationPrefType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\PropertyLocationPrefType) {
            throw new \InvalidArgumentException(sprintf('The PropertyLocationPref property can only contain items of \StructType\PropertyLocationPrefType, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->PropertyLocationPref[] = $item;
        return $this;
    }
    /**
     * Get PropertyTypePref value
     * @return \StructType\PropertyTypePrefType[]|null
     */
    public function getPropertyTypePref()
    {
        return $this->PropertyTypePref;
    }
    /**
     * Set PropertyTypePref value
     * @throws \InvalidArgumentException
     * @param \StructType\PropertyTypePrefType[] $propertyTypePref
     * @return \StructType\HotelPrefType
     */
    public function setPropertyTypePref(array $propertyTypePref = array())
    {
        foreach ($propertyTypePref as $hotelPrefTypePropertyTypePrefItem) {
            // validation for constraint: itemType
            if (!$hotelPrefTypePropertyTypePrefItem instanceof \StructType\PropertyTypePrefType) {
                throw new \InvalidArgumentException(sprintf('The PropertyTypePref property can only contain items of \StructType\PropertyTypePrefType, "%s" given', is_object($hotelPrefTypePropertyTypePrefItem) ? get_class($hotelPrefTypePropertyTypePrefItem) : gettype($hotelPrefTypePropertyTypePrefItem)), __LINE__);
            }
        }
        $this->PropertyTypePref = $propertyTypePref;
        return $this;
    }
    /**
     * Add item to PropertyTypePref value
     * @throws \InvalidArgumentException
     * @param \StructType\PropertyTypePrefType $item
     * @return \StructType\HotelPrefType
     */
    public function addToPropertyTypePref(\StructType\PropertyTypePrefType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\PropertyTypePrefType) {
            throw new \InvalidArgumentException(sprintf('The PropertyTypePref property can only contain items of \StructType\PropertyTypePrefType, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->PropertyTypePref[] = $item;
        return $this;
    }
    /**
     * Get PropertyClassPref value
     * @return \StructType\PropertyClassPrefType[]|null
     */
    public function getPropertyClassPref()
    {
        return $this->PropertyClassPref;
    }
    /**
     * Set PropertyClassPref value
     * @throws \InvalidArgumentException
     * @param \StructType\PropertyClassPrefType[] $propertyClassPref
     * @return \StructType\HotelPrefType
     */
    public function setPropertyClassPref(array $propertyClassPref = array())
    {
        foreach ($propertyClassPref as $hotelPrefTypePropertyClassPrefItem) {
            // validation for constraint: itemType
            if (!$hotelPrefTypePropertyClassPrefItem instanceof \StructType\PropertyClassPrefType) {
                throw new \InvalidArgumentException(sprintf('The PropertyClassPref property can only contain items of \StructType\PropertyClassPrefType, "%s" given', is_object($hotelPrefTypePropertyClassPrefItem) ? get_class($hotelPrefTypePropertyClassPrefItem) : gettype($hotelPrefTypePropertyClassPrefItem)), __LINE__);
            }
        }
        $this->PropertyClassPref = $propertyClassPref;
        return $this;
    }
    /**
     * Add item to PropertyClassPref value
     * @throws \InvalidArgumentException
     * @param \StructType\PropertyClassPrefType $item
     * @return \StructType\HotelPrefType
     */
    public function addToPropertyClassPref(\StructType\PropertyClassPrefType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\PropertyClassPrefType) {
            throw new \InvalidArgumentException(sprintf('The PropertyClassPref property can only contain items of \StructType\PropertyClassPrefType, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->PropertyClassPref[] = $item;
        return $this;
    }
    /**
     * Get PropertyAmenityPref value
     * @return \StructType\PropertyAmenityPrefType[]|null
     */
    public function getPropertyAmenityPref()
    {
        return $this->PropertyAmenityPref;
    }
    /**
     * Set PropertyAmenityPref value
     * @throws \InvalidArgumentException
     * @param \StructType\PropertyAmenityPrefType[] $propertyAmenityPref
     * @return \StructType\HotelPrefType
     */
    public function setPropertyAmenityPref(array $propertyAmenityPref = array())
    {
        foreach ($propertyAmenityPref as $hotelPrefTypePropertyAmenityPrefItem) {
            // validation for constraint: itemType
            if (!$hotelPrefTypePropertyAmenityPrefItem instanceof \StructType\PropertyAmenityPrefType) {
                throw new \InvalidArgumentException(sprintf('The PropertyAmenityPref property can only contain items of \StructType\PropertyAmenityPrefType, "%s" given', is_object($hotelPrefTypePropertyAmenityPrefItem) ? get_class($hotelPrefTypePropertyAmenityPrefItem) : gettype($hotelPrefTypePropertyAmenityPrefItem)), __LINE__);
            }
        }
        $this->PropertyAmenityPref = $propertyAmenityPref;
        return $this;
    }
    /**
     * Add item to PropertyAmenityPref value
     * @throws \InvalidArgumentException
     * @param \StructType\PropertyAmenityPrefType $item
     * @return \StructType\HotelPrefType
     */
    public function addToPropertyAmenityPref(\StructType\PropertyAmenityPrefType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\PropertyAmenityPrefType) {
            throw new \InvalidArgumentException(sprintf('The PropertyAmenityPref property can only contain items of \StructType\PropertyAmenityPrefType, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->PropertyAmenityPref[] = $item;
        return $this;
    }
    /**
     * Get RoomAmenityPref value
     * @return \StructType\RoomAmenityPrefType[]|null
     */
    public function getRoomAmenityPref()
    {
        return $this->RoomAmenityPref;
    }
    /**
     * Set RoomAmenityPref value
     * @throws \InvalidArgumentException
     * @param \StructType\RoomAmenityPrefType[] $roomAmenityPref
     * @return \StructType\HotelPrefType
     */
    public function setRoomAmenityPref(array $roomAmenityPref = array())
    {
        foreach ($roomAmenityPref as $hotelPrefTypeRoomAmenityPrefItem) {
            // validation for constraint: itemType
            if (!$hotelPrefTypeRoomAmenityPrefItem instanceof \StructType\RoomAmenityPrefType) {
                throw new \InvalidArgumentException(sprintf('The RoomAmenityPref property can only contain items of \StructType\RoomAmenityPrefType, "%s" given', is_object($hotelPrefTypeRoomAmenityPrefItem) ? get_class($hotelPrefTypeRoomAmenityPrefItem) : gettype($hotelPrefTypeRoomAmenityPrefItem)), __LINE__);
            }
        }
        $this->RoomAmenityPref = $roomAmenityPref;
        return $this;
    }
    /**
     * Add item to RoomAmenityPref value
     * @throws \InvalidArgumentException
     * @param \StructType\RoomAmenityPrefType $item
     * @return \StructType\HotelPrefType
     */
    public function addToRoomAmenityPref(\StructType\RoomAmenityPrefType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\RoomAmenityPrefType) {
            throw new \InvalidArgumentException(sprintf('The RoomAmenityPref property can only contain items of \StructType\RoomAmenityPrefType, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->RoomAmenityPref[] = $item;
        return $this;
    }
    /**
     * Get RoomLocationPref value
     * @return \StructType\RoomLocationPrefType[]|null
     */
    public function getRoomLocationPref()
    {
        return $this->RoomLocationPref;
    }
    /**
     * Set RoomLocationPref value
     * @throws \InvalidArgumentException
     * @param \StructType\RoomLocationPrefType[] $roomLocationPref
     * @return \StructType\HotelPrefType
     */
    public function setRoomLocationPref(array $roomLocationPref = array())
    {
        foreach ($roomLocationPref as $hotelPrefTypeRoomLocationPrefItem) {
            // validation for constraint: itemType
            if (!$hotelPrefTypeRoomLocationPrefItem instanceof \StructType\RoomLocationPrefType) {
                throw new \InvalidArgumentException(sprintf('The RoomLocationPref property can only contain items of \StructType\RoomLocationPrefType, "%s" given', is_object($hotelPrefTypeRoomLocationPrefItem) ? get_class($hotelPrefTypeRoomLocationPrefItem) : gettype($hotelPrefTypeRoomLocationPrefItem)), __LINE__);
            }
        }
        $this->RoomLocationPref = $roomLocationPref;
        return $this;
    }
    /**
     * Add item to RoomLocationPref value
     * @throws \InvalidArgumentException
     * @param \StructType\RoomLocationPrefType $item
     * @return \StructType\HotelPrefType
     */
    public function addToRoomLocationPref(\StructType\RoomLocationPrefType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\RoomLocationPrefType) {
            throw new \InvalidArgumentException(sprintf('The RoomLocationPref property can only contain items of \StructType\RoomLocationPrefType, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->RoomLocationPref[] = $item;
        return $this;
    }
    /**
     * Get BedTypePref value
     * @return \StructType\BedTypePrefType[]|null
     */
    public function getBedTypePref()
    {
        return $this->BedTypePref;
    }
    /**
     * Set BedTypePref value
     * @throws \InvalidArgumentException
     * @param \StructType\BedTypePrefType[] $bedTypePref
     * @return \StructType\HotelPrefType
     */
    public function setBedTypePref(array $bedTypePref = array())
    {
        foreach ($bedTypePref as $hotelPrefTypeBedTypePrefItem) {
            // validation for constraint: itemType
            if (!$hotelPrefTypeBedTypePrefItem instanceof \StructType\BedTypePrefType) {
                throw new \InvalidArgumentException(sprintf('The BedTypePref property can only contain items of \StructType\BedTypePrefType, "%s" given', is_object($hotelPrefTypeBedTypePrefItem) ? get_class($hotelPrefTypeBedTypePrefItem) : gettype($hotelPrefTypeBedTypePrefItem)), __LINE__);
            }
        }
        $this->BedTypePref = $bedTypePref;
        return $this;
    }
    /**
     * Add item to BedTypePref value
     * @throws \InvalidArgumentException
     * @param \StructType\BedTypePrefType $item
     * @return \StructType\HotelPrefType
     */
    public function addToBedTypePref(\StructType\BedTypePrefType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\BedTypePrefType) {
            throw new \InvalidArgumentException(sprintf('The BedTypePref property can only contain items of \StructType\BedTypePrefType, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->BedTypePref[] = $item;
        return $this;
    }
    /**
     * Get FoodSrvcPref value
     * @return \StructType\FoodSrvcPrefType[]|null
     */
    public function getFoodSrvcPref()
    {
        return $this->FoodSrvcPref;
    }
    /**
     * Set FoodSrvcPref value
     * @throws \InvalidArgumentException
     * @param \StructType\FoodSrvcPrefType[] $foodSrvcPref
     * @return \StructType\HotelPrefType
     */
    public function setFoodSrvcPref(array $foodSrvcPref = array())
    {
        foreach ($foodSrvcPref as $hotelPrefTypeFoodSrvcPrefItem) {
            // validation for constraint: itemType
            if (!$hotelPrefTypeFoodSrvcPrefItem instanceof \StructType\FoodSrvcPrefType) {
                throw new \InvalidArgumentException(sprintf('The FoodSrvcPref property can only contain items of \StructType\FoodSrvcPrefType, "%s" given', is_object($hotelPrefTypeFoodSrvcPrefItem) ? get_class($hotelPrefTypeFoodSrvcPrefItem) : gettype($hotelPrefTypeFoodSrvcPrefItem)), __LINE__);
            }
        }
        $this->FoodSrvcPref = $foodSrvcPref;
        return $this;
    }
    /**
     * Add item to FoodSrvcPref value
     * @throws \InvalidArgumentException
     * @param \StructType\FoodSrvcPrefType $item
     * @return \StructType\HotelPrefType
     */
    public function addToFoodSrvcPref(\StructType\FoodSrvcPrefType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\FoodSrvcPrefType) {
            throw new \InvalidArgumentException(sprintf('The FoodSrvcPref property can only contain items of \StructType\FoodSrvcPrefType, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->FoodSrvcPref[] = $item;
        return $this;
    }
    /**
     * Get MediaEntertainPref value
     * @return \StructType\MediaEntertainPrefType[]|null
     */
    public function getMediaEntertainPref()
    {
        return $this->MediaEntertainPref;
    }
    /**
     * Set MediaEntertainPref value
     * @throws \InvalidArgumentException
     * @param \StructType\MediaEntertainPrefType[] $mediaEntertainPref
     * @return \StructType\HotelPrefType
     */
    public function setMediaEntertainPref(array $mediaEntertainPref = array())
    {
        foreach ($mediaEntertainPref as $hotelPrefTypeMediaEntertainPrefItem) {
            // validation for constraint: itemType
            if (!$hotelPrefTypeMediaEntertainPrefItem instanceof \StructType\MediaEntertainPrefType) {
                throw new \InvalidArgumentException(sprintf('The MediaEntertainPref property can only contain items of \StructType\MediaEntertainPrefType, "%s" given', is_object($hotelPrefTypeMediaEntertainPrefItem) ? get_class($hotelPrefTypeMediaEntertainPrefItem) : gettype($hotelPrefTypeMediaEntertainPrefItem)), __LINE__);
            }
        }
        $this->MediaEntertainPref = $mediaEntertainPref;
        return $this;
    }
    /**
     * Add item to MediaEntertainPref value
     * @throws \InvalidArgumentException
     * @param \StructType\MediaEntertainPrefType $item
     * @return \StructType\HotelPrefType
     */
    public function addToMediaEntertainPref(\StructType\MediaEntertainPrefType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\MediaEntertainPrefType) {
            throw new \InvalidArgumentException(sprintf('The MediaEntertainPref property can only contain items of \StructType\MediaEntertainPrefType, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->MediaEntertainPref[] = $item;
        return $this;
    }
    /**
     * Get PetInfoPref value
     * @return \StructType\PetInfoPrefType[]|null
     */
    public function getPetInfoPref()
    {
        return $this->PetInfoPref;
    }
    /**
     * Set PetInfoPref value
     * @throws \InvalidArgumentException
     * @param \StructType\PetInfoPrefType[] $petInfoPref
     * @return \StructType\HotelPrefType
     */
    public function setPetInfoPref(array $petInfoPref = array())
    {
        foreach ($petInfoPref as $hotelPrefTypePetInfoPrefItem) {
            // validation for constraint: itemType
            if (!$hotelPrefTypePetInfoPrefItem instanceof \StructType\PetInfoPrefType) {
                throw new \InvalidArgumentException(sprintf('The PetInfoPref property can only contain items of \StructType\PetInfoPrefType, "%s" given', is_object($hotelPrefTypePetInfoPrefItem) ? get_class($hotelPrefTypePetInfoPrefItem) : gettype($hotelPrefTypePetInfoPrefItem)), __LINE__);
            }
        }
        $this->PetInfoPref = $petInfoPref;
        return $this;
    }
    /**
     * Add item to PetInfoPref value
     * @throws \InvalidArgumentException
     * @param \StructType\PetInfoPrefType $item
     * @return \StructType\HotelPrefType
     */
    public function addToPetInfoPref(\StructType\PetInfoPrefType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\PetInfoPrefType) {
            throw new \InvalidArgumentException(sprintf('The PetInfoPref property can only contain items of \StructType\PetInfoPrefType, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->PetInfoPref[] = $item;
        return $this;
    }
    /**
     * Get MealPref value
     * @return \StructType\MealPrefType[]|null
     */
    public function getMealPref()
    {
        return $this->MealPref;
    }
    /**
     * Set MealPref value
     * @throws \InvalidArgumentException
     * @param \StructType\MealPrefType[] $mealPref
     * @return \StructType\HotelPrefType
     */
    public function setMealPref(array $mealPref = array())
    {
        foreach ($mealPref as $hotelPrefTypeMealPrefItem) {
            // validation for constraint: itemType
            if (!$hotelPrefTypeMealPrefItem instanceof \StructType\MealPrefType) {
                throw new \InvalidArgumentException(sprintf('The MealPref property can only contain items of \StructType\MealPrefType, "%s" given', is_object($hotelPrefTypeMealPrefItem) ? get_class($hotelPrefTypeMealPrefItem) : gettype($hotelPrefTypeMealPrefItem)), __LINE__);
            }
        }
        $this->MealPref = $mealPref;
        return $this;
    }
    /**
     * Add item to MealPref value
     * @throws \InvalidArgumentException
     * @param \StructType\MealPrefType $item
     * @return \StructType\HotelPrefType
     */
    public function addToMealPref(\StructType\MealPrefType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\MealPrefType) {
            throw new \InvalidArgumentException(sprintf('The MealPref property can only contain items of \StructType\MealPrefType, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->MealPref[] = $item;
        return $this;
    }
    /**
     * Get RecreationSrvcPref value
     * @return \StructType\RecreationSrvcPrefType[]|null
     */
    public function getRecreationSrvcPref()
    {
        return $this->RecreationSrvcPref;
    }
    /**
     * Set RecreationSrvcPref value
     * @throws \InvalidArgumentException
     * @param \StructType\RecreationSrvcPrefType[] $recreationSrvcPref
     * @return \StructType\HotelPrefType
     */
    public function setRecreationSrvcPref(array $recreationSrvcPref = array())
    {
        foreach ($recreationSrvcPref as $hotelPrefTypeRecreationSrvcPrefItem) {
            // validation for constraint: itemType
            if (!$hotelPrefTypeRecreationSrvcPrefItem instanceof \StructType\RecreationSrvcPrefType) {
                throw new \InvalidArgumentException(sprintf('The RecreationSrvcPref property can only contain items of \StructType\RecreationSrvcPrefType, "%s" given', is_object($hotelPrefTypeRecreationSrvcPrefItem) ? get_class($hotelPrefTypeRecreationSrvcPrefItem) : gettype($hotelPrefTypeRecreationSrvcPrefItem)), __LINE__);
            }
        }
        $this->RecreationSrvcPref = $recreationSrvcPref;
        return $this;
    }
    /**
     * Add item to RecreationSrvcPref value
     * @throws \InvalidArgumentException
     * @param \StructType\RecreationSrvcPrefType $item
     * @return \StructType\HotelPrefType
     */
    public function addToRecreationSrvcPref(\StructType\RecreationSrvcPrefType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\RecreationSrvcPrefType) {
            throw new \InvalidArgumentException(sprintf('The RecreationSrvcPref property can only contain items of \StructType\RecreationSrvcPrefType, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->RecreationSrvcPref[] = $item;
        return $this;
    }
    /**
     * Get BusinessSrvcPref value
     * @return \StructType\BusinessSrvcPrefType[]|null
     */
    public function getBusinessSrvcPref()
    {
        return $this->BusinessSrvcPref;
    }
    /**
     * Set BusinessSrvcPref value
     * @throws \InvalidArgumentException
     * @param \StructType\BusinessSrvcPrefType[] $businessSrvcPref
     * @return \StructType\HotelPrefType
     */
    public function setBusinessSrvcPref(array $businessSrvcPref = array())
    {
        foreach ($businessSrvcPref as $hotelPrefTypeBusinessSrvcPrefItem) {
            // validation for constraint: itemType
            if (!$hotelPrefTypeBusinessSrvcPrefItem instanceof \StructType\BusinessSrvcPrefType) {
                throw new \InvalidArgumentException(sprintf('The BusinessSrvcPref property can only contain items of \StructType\BusinessSrvcPrefType, "%s" given', is_object($hotelPrefTypeBusinessSrvcPrefItem) ? get_class($hotelPrefTypeBusinessSrvcPrefItem) : gettype($hotelPrefTypeBusinessSrvcPrefItem)), __LINE__);
            }
        }
        $this->BusinessSrvcPref = $businessSrvcPref;
        return $this;
    }
    /**
     * Add item to BusinessSrvcPref value
     * @throws \InvalidArgumentException
     * @param \StructType\BusinessSrvcPrefType $item
     * @return \StructType\HotelPrefType
     */
    public function addToBusinessSrvcPref(\StructType\BusinessSrvcPrefType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\BusinessSrvcPrefType) {
            throw new \InvalidArgumentException(sprintf('The BusinessSrvcPref property can only contain items of \StructType\BusinessSrvcPrefType, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->BusinessSrvcPref[] = $item;
        return $this;
    }
    /**
     * Get PersonalSrvcPref value
     * @return \StructType\PersonalSrvcPrefType[]|null
     */
    public function getPersonalSrvcPref()
    {
        return $this->PersonalSrvcPref;
    }
    /**
     * Set PersonalSrvcPref value
     * @throws \InvalidArgumentException
     * @param \StructType\PersonalSrvcPrefType[] $personalSrvcPref
     * @return \StructType\HotelPrefType
     */
    public function setPersonalSrvcPref(array $personalSrvcPref = array())
    {
        foreach ($personalSrvcPref as $hotelPrefTypePersonalSrvcPrefItem) {
            // validation for constraint: itemType
            if (!$hotelPrefTypePersonalSrvcPrefItem instanceof \StructType\PersonalSrvcPrefType) {
                throw new \InvalidArgumentException(sprintf('The PersonalSrvcPref property can only contain items of \StructType\PersonalSrvcPrefType, "%s" given', is_object($hotelPrefTypePersonalSrvcPrefItem) ? get_class($hotelPrefTypePersonalSrvcPrefItem) : gettype($hotelPrefTypePersonalSrvcPrefItem)), __LINE__);
            }
        }
        $this->PersonalSrvcPref = $personalSrvcPref;
        return $this;
    }
    /**
     * Add item to PersonalSrvcPref value
     * @throws \InvalidArgumentException
     * @param \StructType\PersonalSrvcPrefType $item
     * @return \StructType\HotelPrefType
     */
    public function addToPersonalSrvcPref(\StructType\PersonalSrvcPrefType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\PersonalSrvcPrefType) {
            throw new \InvalidArgumentException(sprintf('The PersonalSrvcPref property can only contain items of \StructType\PersonalSrvcPrefType, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->PersonalSrvcPref[] = $item;
        return $this;
    }
    /**
     * Get SecurityFeaturePref value
     * @return \StructType\SecurityFeaturePrefType[]|null
     */
    public function getSecurityFeaturePref()
    {
        return $this->SecurityFeaturePref;
    }
    /**
     * Set SecurityFeaturePref value
     * @throws \InvalidArgumentException
     * @param \StructType\SecurityFeaturePrefType[] $securityFeaturePref
     * @return \StructType\HotelPrefType
     */
    public function setSecurityFeaturePref(array $securityFeaturePref = array())
    {
        foreach ($securityFeaturePref as $hotelPrefTypeSecurityFeaturePrefItem) {
            // validation for constraint: itemType
            if (!$hotelPrefTypeSecurityFeaturePrefItem instanceof \StructType\SecurityFeaturePrefType) {
                throw new \InvalidArgumentException(sprintf('The SecurityFeaturePref property can only contain items of \StructType\SecurityFeaturePrefType, "%s" given', is_object($hotelPrefTypeSecurityFeaturePrefItem) ? get_class($hotelPrefTypeSecurityFeaturePrefItem) : gettype($hotelPrefTypeSecurityFeaturePrefItem)), __LINE__);
            }
        }
        $this->SecurityFeaturePref = $securityFeaturePref;
        return $this;
    }
    /**
     * Add item to SecurityFeaturePref value
     * @throws \InvalidArgumentException
     * @param \StructType\SecurityFeaturePrefType $item
     * @return \StructType\HotelPrefType
     */
    public function addToSecurityFeaturePref(\StructType\SecurityFeaturePrefType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\SecurityFeaturePrefType) {
            throw new \InvalidArgumentException(sprintf('The SecurityFeaturePref property can only contain items of \StructType\SecurityFeaturePrefType, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->SecurityFeaturePref[] = $item;
        return $this;
    }
    /**
     * Get PhysChallFeaturePref value
     * @return \StructType\PhysChallFeaturePrefType[]|null
     */
    public function getPhysChallFeaturePref()
    {
        return $this->PhysChallFeaturePref;
    }
    /**
     * Set PhysChallFeaturePref value
     * @throws \InvalidArgumentException
     * @param \StructType\PhysChallFeaturePrefType[] $physChallFeaturePref
     * @return \StructType\HotelPrefType
     */
    public function setPhysChallFeaturePref(array $physChallFeaturePref = array())
    {
        foreach ($physChallFeaturePref as $hotelPrefTypePhysChallFeaturePrefItem) {
            // validation for constraint: itemType
            if (!$hotelPrefTypePhysChallFeaturePrefItem instanceof \StructType\PhysChallFeaturePrefType) {
                throw new \InvalidArgumentException(sprintf('The PhysChallFeaturePref property can only contain items of \StructType\PhysChallFeaturePrefType, "%s" given', is_object($hotelPrefTypePhysChallFeaturePrefItem) ? get_class($hotelPrefTypePhysChallFeaturePrefItem) : gettype($hotelPrefTypePhysChallFeaturePrefItem)), __LINE__);
            }
        }
        $this->PhysChallFeaturePref = $physChallFeaturePref;
        return $this;
    }
    /**
     * Add item to PhysChallFeaturePref value
     * @throws \InvalidArgumentException
     * @param \StructType\PhysChallFeaturePrefType $item
     * @return \StructType\HotelPrefType
     */
    public function addToPhysChallFeaturePref(\StructType\PhysChallFeaturePrefType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\PhysChallFeaturePrefType) {
            throw new \InvalidArgumentException(sprintf('The PhysChallFeaturePref property can only contain items of \StructType\PhysChallFeaturePrefType, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->PhysChallFeaturePref[] = $item;
        return $this;
    }
    /**
     * Get SpecRequestPref value
     * @return \StructType\SpecRequestPrefType[]|null
     */
    public function getSpecRequestPref()
    {
        return $this->SpecRequestPref;
    }
    /**
     * Set SpecRequestPref value
     * @throws \InvalidArgumentException
     * @param \StructType\SpecRequestPrefType[] $specRequestPref
     * @return \StructType\HotelPrefType
     */
    public function setSpecRequestPref(array $specRequestPref = array())
    {
        foreach ($specRequestPref as $hotelPrefTypeSpecRequestPrefItem) {
            // validation for constraint: itemType
            if (!$hotelPrefTypeSpecRequestPrefItem instanceof \StructType\SpecRequestPrefType) {
                throw new \InvalidArgumentException(sprintf('The SpecRequestPref property can only contain items of \StructType\SpecRequestPrefType, "%s" given', is_object($hotelPrefTypeSpecRequestPrefItem) ? get_class($hotelPrefTypeSpecRequestPrefItem) : gettype($hotelPrefTypeSpecRequestPrefItem)), __LINE__);
            }
        }
        $this->SpecRequestPref = $specRequestPref;
        return $this;
    }
    /**
     * Add item to SpecRequestPref value
     * @throws \InvalidArgumentException
     * @param \StructType\SpecRequestPrefType $item
     * @return \StructType\HotelPrefType
     */
    public function addToSpecRequestPref(\StructType\SpecRequestPrefType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\SpecRequestPrefType) {
            throw new \InvalidArgumentException(sprintf('The SpecRequestPref property can only contain items of \StructType\SpecRequestPrefType, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->SpecRequestPref[] = $item;
        return $this;
    }
    /**
     * Get TPA_Extensions value
     * @return \StructType\TPA_Extensions_Type|null
     */
    public function getTPA_Extensions()
    {
        return $this->TPA_Extensions;
    }
    /**
     * Set TPA_Extensions value
     * @param \StructType\TPA_Extensions_Type $tPA_Extensions
     * @return \StructType\HotelPrefType
     */
    public function setTPA_Extensions(\StructType\TPA_Extensions_Type $tPA_Extensions = null)
    {
        $this->TPA_Extensions = $tPA_Extensions;
        return $this;
    }
    /**
     * Get PreferLevel value
     * @return string|null
     */
    public function getPreferLevel()
    {
        return $this->PreferLevel;
    }
    /**
     * Set PreferLevel value
     * @uses \EnumType\PreferLevelType::valueIsValid()
     * @uses \EnumType\PreferLevelType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $preferLevel
     * @return \StructType\HotelPrefType
     */
    public function setPreferLevel($preferLevel = 'Preferred')
    {
        // validation for constraint: enumeration
        if (!\EnumType\PreferLevelType::valueIsValid($preferLevel)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $preferLevel, implode(', ', \EnumType\PreferLevelType::getValidValues())), __LINE__);
        }
        $this->PreferLevel = $preferLevel;
        return $this;
    }
    /**
     * Get ShareSynchInd value
     * @return string|null
     */
    public function getShareSynchInd()
    {
        return $this->ShareSynchInd;
    }
    /**
     * Set ShareSynchInd value
     * @param string $shareSynchInd
     * @return \StructType\HotelPrefType
     */
    public function setShareSynchInd($shareSynchInd = null)
    {
        // validation for constraint: string
        if (!is_null($shareSynchInd) && !is_string($shareSynchInd)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($shareSynchInd)), __LINE__);
        }
        $this->ShareSynchInd = $shareSynchInd;
        return $this;
    }
    /**
     * Get ShareMarketInd value
     * @return string|null
     */
    public function getShareMarketInd()
    {
        return $this->ShareMarketInd;
    }
    /**
     * Set ShareMarketInd value
     * @param string $shareMarketInd
     * @return \StructType\HotelPrefType
     */
    public function setShareMarketInd($shareMarketInd = null)
    {
        // validation for constraint: string
        if (!is_null($shareMarketInd) && !is_string($shareMarketInd)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($shareMarketInd)), __LINE__);
        }
        $this->ShareMarketInd = $shareMarketInd;
        return $this;
    }
    /**
     * Get SmokingAllowed value
     * @return bool|null
     */
    public function getSmokingAllowed()
    {
        return $this->SmokingAllowed;
    }
    /**
     * Set SmokingAllowed value
     * @param bool $smokingAllowed
     * @return \StructType\HotelPrefType
     */
    public function setSmokingAllowed($smokingAllowed = false)
    {
        $this->SmokingAllowed = $smokingAllowed;
        return $this;
    }
    /**
     * Get RatePlanCode value
     * @return string|null
     */
    public function getRatePlanCode()
    {
        return $this->RatePlanCode;
    }
    /**
     * Set RatePlanCode value
     * @param string $ratePlanCode
     * @return \StructType\HotelPrefType
     */
    public function setRatePlanCode($ratePlanCode = null)
    {
        // validation for constraint: string
        if (!is_null($ratePlanCode) && !is_string($ratePlanCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($ratePlanCode)), __LINE__);
        }
        $this->RatePlanCode = $ratePlanCode;
        return $this;
    }
    /**
     * Get HotelGuestType value
     * @return string|null
     */
    public function getHotelGuestType()
    {
        return $this->HotelGuestType;
    }
    /**
     * Set HotelGuestType value
     * @param string $hotelGuestType
     * @return \StructType\HotelPrefType
     */
    public function setHotelGuestType($hotelGuestType = null)
    {
        // validation for constraint: string
        if (!is_null($hotelGuestType) && !is_string($hotelGuestType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($hotelGuestType)), __LINE__);
        }
        $this->HotelGuestType = $hotelGuestType;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\HotelPrefType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
