<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for EmployerType StructType
 * @subpackage Structs
 */
class EmployerType extends AbstractStructBase
{
    /**
     * The CompanyName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\CompanyNameType
     */
    public $CompanyName;
    /**
     * The RelatedEmployer
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\CompanyNameType[]
     */
    public $RelatedEmployer;
    /**
     * The EmployeeInfo
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\EmployeeInfoType[]
     */
    public $EmployeeInfo;
    /**
     * The InternalRefNmbr
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\FreeTextType[]
     */
    public $InternalRefNmbr;
    /**
     * The TravelArranger
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\TravelArrangerType[]
     */
    public $TravelArranger;
    /**
     * The LoyaltyProgram
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\LoyaltyProgramType[]
     */
    public $LoyaltyProgram;
    /**
     * The DefaultInd
     * Meta informations extracted from the WSDL
     * - default: false
     * @var bool
     */
    public $DefaultInd;
    /**
     * The OfficeType
     * @var string
     */
    public $OfficeType;
    /**
     * The EffectiveDate
     * @var string
     */
    public $EffectiveDate;
    /**
     * The ExpireDate
     * @var string
     */
    public $ExpireDate;
    /**
     * Constructor method for EmployerType
     * @uses EmployerType::setCompanyName()
     * @uses EmployerType::setRelatedEmployer()
     * @uses EmployerType::setEmployeeInfo()
     * @uses EmployerType::setInternalRefNmbr()
     * @uses EmployerType::setTravelArranger()
     * @uses EmployerType::setLoyaltyProgram()
     * @uses EmployerType::setDefaultInd()
     * @uses EmployerType::setOfficeType()
     * @uses EmployerType::setEffectiveDate()
     * @uses EmployerType::setExpireDate()
     * @param \StructType\CompanyNameType $companyName
     * @param \StructType\CompanyNameType[] $relatedEmployer
     * @param \StructType\EmployeeInfoType[] $employeeInfo
     * @param \StructType\FreeTextType[] $internalRefNmbr
     * @param \StructType\TravelArrangerType[] $travelArranger
     * @param \StructType\LoyaltyProgramType[] $loyaltyProgram
     * @param bool $defaultInd
     * @param string $officeType
     * @param string $effectiveDate
     * @param string $expireDate
     */
    public function __construct(\StructType\CompanyNameType $companyName = null, array $relatedEmployer = array(), array $employeeInfo = array(), array $internalRefNmbr = array(), array $travelArranger = array(), array $loyaltyProgram = array(), $defaultInd = false, $officeType = null, $effectiveDate = null, $expireDate = null)
    {
        $this
            ->setCompanyName($companyName)
            ->setRelatedEmployer($relatedEmployer)
            ->setEmployeeInfo($employeeInfo)
            ->setInternalRefNmbr($internalRefNmbr)
            ->setTravelArranger($travelArranger)
            ->setLoyaltyProgram($loyaltyProgram)
            ->setDefaultInd($defaultInd)
            ->setOfficeType($officeType)
            ->setEffectiveDate($effectiveDate)
            ->setExpireDate($expireDate);
    }
    /**
     * Get CompanyName value
     * @return \StructType\CompanyNameType|null
     */
    public function getCompanyName()
    {
        return $this->CompanyName;
    }
    /**
     * Set CompanyName value
     * @param \StructType\CompanyNameType $companyName
     * @return \StructType\EmployerType
     */
    public function setCompanyName(\StructType\CompanyNameType $companyName = null)
    {
        $this->CompanyName = $companyName;
        return $this;
    }
    /**
     * Get RelatedEmployer value
     * @return \StructType\CompanyNameType[]|null
     */
    public function getRelatedEmployer()
    {
        return $this->RelatedEmployer;
    }
    /**
     * Set RelatedEmployer value
     * @throws \InvalidArgumentException
     * @param \StructType\CompanyNameType[] $relatedEmployer
     * @return \StructType\EmployerType
     */
    public function setRelatedEmployer(array $relatedEmployer = array())
    {
        foreach ($relatedEmployer as $employerTypeRelatedEmployerItem) {
            // validation for constraint: itemType
            if (!$employerTypeRelatedEmployerItem instanceof \StructType\CompanyNameType) {
                throw new \InvalidArgumentException(sprintf('The RelatedEmployer property can only contain items of \StructType\CompanyNameType, "%s" given', is_object($employerTypeRelatedEmployerItem) ? get_class($employerTypeRelatedEmployerItem) : gettype($employerTypeRelatedEmployerItem)), __LINE__);
            }
        }
        $this->RelatedEmployer = $relatedEmployer;
        return $this;
    }
    /**
     * Add item to RelatedEmployer value
     * @throws \InvalidArgumentException
     * @param \StructType\CompanyNameType $item
     * @return \StructType\EmployerType
     */
    public function addToRelatedEmployer(\StructType\CompanyNameType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\CompanyNameType) {
            throw new \InvalidArgumentException(sprintf('The RelatedEmployer property can only contain items of \StructType\CompanyNameType, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->RelatedEmployer[] = $item;
        return $this;
    }
    /**
     * Get EmployeeInfo value
     * @return \StructType\EmployeeInfoType[]|null
     */
    public function getEmployeeInfo()
    {
        return $this->EmployeeInfo;
    }
    /**
     * Set EmployeeInfo value
     * @throws \InvalidArgumentException
     * @param \StructType\EmployeeInfoType[] $employeeInfo
     * @return \StructType\EmployerType
     */
    public function setEmployeeInfo(array $employeeInfo = array())
    {
        foreach ($employeeInfo as $employerTypeEmployeeInfoItem) {
            // validation for constraint: itemType
            if (!$employerTypeEmployeeInfoItem instanceof \StructType\EmployeeInfoType) {
                throw new \InvalidArgumentException(sprintf('The EmployeeInfo property can only contain items of \StructType\EmployeeInfoType, "%s" given', is_object($employerTypeEmployeeInfoItem) ? get_class($employerTypeEmployeeInfoItem) : gettype($employerTypeEmployeeInfoItem)), __LINE__);
            }
        }
        $this->EmployeeInfo = $employeeInfo;
        return $this;
    }
    /**
     * Add item to EmployeeInfo value
     * @throws \InvalidArgumentException
     * @param \StructType\EmployeeInfoType $item
     * @return \StructType\EmployerType
     */
    public function addToEmployeeInfo(\StructType\EmployeeInfoType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\EmployeeInfoType) {
            throw new \InvalidArgumentException(sprintf('The EmployeeInfo property can only contain items of \StructType\EmployeeInfoType, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->EmployeeInfo[] = $item;
        return $this;
    }
    /**
     * Get InternalRefNmbr value
     * @return \StructType\FreeTextType[]|null
     */
    public function getInternalRefNmbr()
    {
        return $this->InternalRefNmbr;
    }
    /**
     * Set InternalRefNmbr value
     * @throws \InvalidArgumentException
     * @param \StructType\FreeTextType[] $internalRefNmbr
     * @return \StructType\EmployerType
     */
    public function setInternalRefNmbr(array $internalRefNmbr = array())
    {
        foreach ($internalRefNmbr as $employerTypeInternalRefNmbrItem) {
            // validation for constraint: itemType
            if (!$employerTypeInternalRefNmbrItem instanceof \StructType\FreeTextType) {
                throw new \InvalidArgumentException(sprintf('The InternalRefNmbr property can only contain items of \StructType\FreeTextType, "%s" given', is_object($employerTypeInternalRefNmbrItem) ? get_class($employerTypeInternalRefNmbrItem) : gettype($employerTypeInternalRefNmbrItem)), __LINE__);
            }
        }
        $this->InternalRefNmbr = $internalRefNmbr;
        return $this;
    }
    /**
     * Add item to InternalRefNmbr value
     * @throws \InvalidArgumentException
     * @param \StructType\FreeTextType $item
     * @return \StructType\EmployerType
     */
    public function addToInternalRefNmbr(\StructType\FreeTextType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\FreeTextType) {
            throw new \InvalidArgumentException(sprintf('The InternalRefNmbr property can only contain items of \StructType\FreeTextType, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->InternalRefNmbr[] = $item;
        return $this;
    }
    /**
     * Get TravelArranger value
     * @return \StructType\TravelArrangerType[]|null
     */
    public function getTravelArranger()
    {
        return $this->TravelArranger;
    }
    /**
     * Set TravelArranger value
     * @throws \InvalidArgumentException
     * @param \StructType\TravelArrangerType[] $travelArranger
     * @return \StructType\EmployerType
     */
    public function setTravelArranger(array $travelArranger = array())
    {
        foreach ($travelArranger as $employerTypeTravelArrangerItem) {
            // validation for constraint: itemType
            if (!$employerTypeTravelArrangerItem instanceof \StructType\TravelArrangerType) {
                throw new \InvalidArgumentException(sprintf('The TravelArranger property can only contain items of \StructType\TravelArrangerType, "%s" given', is_object($employerTypeTravelArrangerItem) ? get_class($employerTypeTravelArrangerItem) : gettype($employerTypeTravelArrangerItem)), __LINE__);
            }
        }
        $this->TravelArranger = $travelArranger;
        return $this;
    }
    /**
     * Add item to TravelArranger value
     * @throws \InvalidArgumentException
     * @param \StructType\TravelArrangerType $item
     * @return \StructType\EmployerType
     */
    public function addToTravelArranger(\StructType\TravelArrangerType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\TravelArrangerType) {
            throw new \InvalidArgumentException(sprintf('The TravelArranger property can only contain items of \StructType\TravelArrangerType, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->TravelArranger[] = $item;
        return $this;
    }
    /**
     * Get LoyaltyProgram value
     * @return \StructType\LoyaltyProgramType[]|null
     */
    public function getLoyaltyProgram()
    {
        return $this->LoyaltyProgram;
    }
    /**
     * Set LoyaltyProgram value
     * @throws \InvalidArgumentException
     * @param \StructType\LoyaltyProgramType[] $loyaltyProgram
     * @return \StructType\EmployerType
     */
    public function setLoyaltyProgram(array $loyaltyProgram = array())
    {
        foreach ($loyaltyProgram as $employerTypeLoyaltyProgramItem) {
            // validation for constraint: itemType
            if (!$employerTypeLoyaltyProgramItem instanceof \StructType\LoyaltyProgramType) {
                throw new \InvalidArgumentException(sprintf('The LoyaltyProgram property can only contain items of \StructType\LoyaltyProgramType, "%s" given', is_object($employerTypeLoyaltyProgramItem) ? get_class($employerTypeLoyaltyProgramItem) : gettype($employerTypeLoyaltyProgramItem)), __LINE__);
            }
        }
        $this->LoyaltyProgram = $loyaltyProgram;
        return $this;
    }
    /**
     * Add item to LoyaltyProgram value
     * @throws \InvalidArgumentException
     * @param \StructType\LoyaltyProgramType $item
     * @return \StructType\EmployerType
     */
    public function addToLoyaltyProgram(\StructType\LoyaltyProgramType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\LoyaltyProgramType) {
            throw new \InvalidArgumentException(sprintf('The LoyaltyProgram property can only contain items of \StructType\LoyaltyProgramType, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->LoyaltyProgram[] = $item;
        return $this;
    }
    /**
     * Get DefaultInd value
     * @return bool|null
     */
    public function getDefaultInd()
    {
        return $this->DefaultInd;
    }
    /**
     * Set DefaultInd value
     * @param bool $defaultInd
     * @return \StructType\EmployerType
     */
    public function setDefaultInd($defaultInd = false)
    {
        $this->DefaultInd = $defaultInd;
        return $this;
    }
    /**
     * Get OfficeType value
     * @return string|null
     */
    public function getOfficeType()
    {
        return $this->OfficeType;
    }
    /**
     * Set OfficeType value
     * @uses \EnumType\OfficeLocationType::valueIsValid()
     * @uses \EnumType\OfficeLocationType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $officeType
     * @return \StructType\EmployerType
     */
    public function setOfficeType($officeType = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\OfficeLocationType::valueIsValid($officeType)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $officeType, implode(', ', \EnumType\OfficeLocationType::getValidValues())), __LINE__);
        }
        $this->OfficeType = $officeType;
        return $this;
    }
    /**
     * Get EffectiveDate value
     * @return string|null
     */
    public function getEffectiveDate()
    {
        return $this->EffectiveDate;
    }
    /**
     * Set EffectiveDate value
     * @param string $effectiveDate
     * @return \StructType\EmployerType
     */
    public function setEffectiveDate($effectiveDate = null)
    {
        // validation for constraint: string
        if (!is_null($effectiveDate) && !is_string($effectiveDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($effectiveDate)), __LINE__);
        }
        $this->EffectiveDate = $effectiveDate;
        return $this;
    }
    /**
     * Get ExpireDate value
     * @return string|null
     */
    public function getExpireDate()
    {
        return $this->ExpireDate;
    }
    /**
     * Set ExpireDate value
     * @param string $expireDate
     * @return \StructType\EmployerType
     */
    public function setExpireDate($expireDate = null)
    {
        // validation for constraint: string
        if (!is_null($expireDate) && !is_string($expireDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($expireDate)), __LINE__);
        }
        $this->ExpireDate = $expireDate;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\EmployerType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
