<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for EVRN_ReservationCancelRS StructType
 * @subpackage Structs
 */
class EVRN_ReservationCancelRS extends EVRN_BaseRSType
{
    /**
     * The ReservationID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ReservationID;
    /**
     * The ReservationStatusTypes
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ReservationStatusTypes;
    /**
     * The Message
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Message;
    /**
     * The Errors
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\ErrorsType
     */
    public $Errors;
    /**
     * The Warnings
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\WarningsType
     */
    public $Warnings;
    /**
     * The Success
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\SuccessType
     */
    public $Success;
    /**
     * The TPA_Extensions
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\TPA_Extensions_Type
     */
    public $TPA_Extensions;
    /**
     * Constructor method for EVRN_ReservationCancelRS
     * @uses EVRN_ReservationCancelRS::setReservationID()
     * @uses EVRN_ReservationCancelRS::setReservationStatusTypes()
     * @uses EVRN_ReservationCancelRS::setMessage()
     * @uses EVRN_ReservationCancelRS::setErrors()
     * @uses EVRN_ReservationCancelRS::setWarnings()
     * @uses EVRN_ReservationCancelRS::setSuccess()
     * @uses EVRN_ReservationCancelRS::setTPA_Extensions()
     * @param string $reservationID
     * @param string $reservationStatusTypes
     * @param string $message
     * @param \StructType\ErrorsType $errors
     * @param \StructType\WarningsType $warnings
     * @param \StructType\SuccessType $success
     * @param \StructType\TPA_Extensions_Type $tPA_Extensions
     */
    public function __construct($reservationID = null, $reservationStatusTypes = null, $message = null, \StructType\ErrorsType $errors = null, \StructType\WarningsType $warnings = null, \StructType\SuccessType $success = null, \StructType\TPA_Extensions_Type $tPA_Extensions = null)
    {
        $this
            ->setReservationID($reservationID)
            ->setReservationStatusTypes($reservationStatusTypes)
            ->setMessage($message)
            ->setErrors($errors)
            ->setWarnings($warnings)
            ->setSuccess($success)
            ->setTPA_Extensions($tPA_Extensions);
    }
    /**
     * Get ReservationID value
     * @return string|null
     */
    public function getReservationID()
    {
        return $this->ReservationID;
    }
    /**
     * Set ReservationID value
     * @param string $reservationID
     * @return \StructType\EVRN_ReservationCancelRS
     */
    public function setReservationID($reservationID = null)
    {
        // validation for constraint: string
        if (!is_null($reservationID) && !is_string($reservationID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($reservationID)), __LINE__);
        }
        $this->ReservationID = $reservationID;
        return $this;
    }
    /**
     * Get ReservationStatusTypes value
     * @return string|null
     */
    public function getReservationStatusTypes()
    {
        return $this->ReservationStatusTypes;
    }
    /**
     * Set ReservationStatusTypes value
     * @param string $reservationStatusTypes
     * @return \StructType\EVRN_ReservationCancelRS
     */
    public function setReservationStatusTypes($reservationStatusTypes = null)
    {
        // validation for constraint: string
        if (!is_null($reservationStatusTypes) && !is_string($reservationStatusTypes)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($reservationStatusTypes)), __LINE__);
        }
        $this->ReservationStatusTypes = $reservationStatusTypes;
        return $this;
    }
    /**
     * Get Message value
     * @return string|null
     */
    public function getMessage()
    {
        return $this->Message;
    }
    /**
     * Set Message value
     * @param string $message
     * @return \StructType\EVRN_ReservationCancelRS
     */
    public function setMessage($message = null)
    {
        // validation for constraint: string
        if (!is_null($message) && !is_string($message)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($message)), __LINE__);
        }
        $this->Message = $message;
        return $this;
    }
    /**
     * Get Errors value
     * @return \StructType\ErrorsType|null
     */
    public function getErrors()
    {
        return $this->Errors;
    }
    /**
     * Set Errors value
     * @param \StructType\ErrorsType $errors
     * @return \StructType\EVRN_ReservationCancelRS
     */
    public function setErrors(\StructType\ErrorsType $errors = null)
    {
        $this->Errors = $errors;
        return $this;
    }
    /**
     * Get Warnings value
     * @return \StructType\WarningsType|null
     */
    public function getWarnings()
    {
        return $this->Warnings;
    }
    /**
     * Set Warnings value
     * @param \StructType\WarningsType $warnings
     * @return \StructType\EVRN_ReservationCancelRS
     */
    public function setWarnings(\StructType\WarningsType $warnings = null)
    {
        $this->Warnings = $warnings;
        return $this;
    }
    /**
     * Get Success value
     * @return \StructType\SuccessType|null
     */
    public function getSuccess()
    {
        return $this->Success;
    }
    /**
     * Set Success value
     * @param \StructType\SuccessType $success
     * @return \StructType\EVRN_ReservationCancelRS
     */
    public function setSuccess(\StructType\SuccessType $success = null)
    {
        $this->Success = $success;
        return $this;
    }
    /**
     * Get TPA_Extensions value
     * @return \StructType\TPA_Extensions_Type|null
     */
    public function getTPA_Extensions()
    {
        return $this->TPA_Extensions;
    }
    /**
     * Set TPA_Extensions value
     * @param \StructType\TPA_Extensions_Type $tPA_Extensions
     * @return \StructType\EVRN_ReservationCancelRS
     */
    public function setTPA_Extensions(\StructType\TPA_Extensions_Type $tPA_Extensions = null)
    {
        $this->TPA_Extensions = $tPA_Extensions;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\EVRN_ReservationCancelRS
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
