<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for DocumentType StructType
 * @subpackage Structs
 */
class DocumentType extends AbstractStructBase
{
    /**
     * The DocHolderName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $DocHolderName;
    /**
     * The DocHolderFormattedName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\PersonNameType
     */
    public $DocHolderFormattedName;
    /**
     * The DocLimitations
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var string[]
     */
    public $DocLimitations;
    /**
     * The AdditionalPersonNames
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfString
     */
    public $AdditionalPersonNames;
    /**
     * The ShareSynchInd
     * @var string
     */
    public $ShareSynchInd;
    /**
     * The ShareMarketInd
     * @var string
     */
    public $ShareMarketInd;
    /**
     * The DocIssueAuthority
     * @var string
     */
    public $DocIssueAuthority;
    /**
     * The DocIssueLocation
     * @var string
     */
    public $DocIssueLocation;
    /**
     * The DocID
     * @var string
     */
    public $DocID;
    /**
     * The DocType
     * @var string
     */
    public $DocType;
    /**
     * The Gender
     * @var string
     */
    public $Gender;
    /**
     * The BirthDate
     * @var string
     */
    public $BirthDate;
    /**
     * The EffectiveDate
     * @var string
     */
    public $EffectiveDate;
    /**
     * The ExpireDate
     * @var string
     */
    public $ExpireDate;
    /**
     * The DocIssueStateProv
     * @var string
     */
    public $DocIssueStateProv;
    /**
     * The DocIssueCountry
     * @var string
     */
    public $DocIssueCountry;
    /**
     * The BirthCountry
     * @var string
     */
    public $BirthCountry;
    /**
     * The DocHolderNationality
     * @var string
     */
    public $DocHolderNationality;
    /**
     * Constructor method for DocumentType
     * @uses DocumentType::setDocHolderName()
     * @uses DocumentType::setDocHolderFormattedName()
     * @uses DocumentType::setDocLimitations()
     * @uses DocumentType::setAdditionalPersonNames()
     * @uses DocumentType::setShareSynchInd()
     * @uses DocumentType::setShareMarketInd()
     * @uses DocumentType::setDocIssueAuthority()
     * @uses DocumentType::setDocIssueLocation()
     * @uses DocumentType::setDocID()
     * @uses DocumentType::setDocType()
     * @uses DocumentType::setGender()
     * @uses DocumentType::setBirthDate()
     * @uses DocumentType::setEffectiveDate()
     * @uses DocumentType::setExpireDate()
     * @uses DocumentType::setDocIssueStateProv()
     * @uses DocumentType::setDocIssueCountry()
     * @uses DocumentType::setBirthCountry()
     * @uses DocumentType::setDocHolderNationality()
     * @param string $docHolderName
     * @param \StructType\PersonNameType $docHolderFormattedName
     * @param string[] $docLimitations
     * @param \ArrayType\ArrayOfString $additionalPersonNames
     * @param string $shareSynchInd
     * @param string $shareMarketInd
     * @param string $docIssueAuthority
     * @param string $docIssueLocation
     * @param string $docID
     * @param string $docType
     * @param string $gender
     * @param string $birthDate
     * @param string $effectiveDate
     * @param string $expireDate
     * @param string $docIssueStateProv
     * @param string $docIssueCountry
     * @param string $birthCountry
     * @param string $docHolderNationality
     */
    public function __construct($docHolderName = null, \StructType\PersonNameType $docHolderFormattedName = null, array $docLimitations = array(), \ArrayType\ArrayOfString $additionalPersonNames = null, $shareSynchInd = null, $shareMarketInd = null, $docIssueAuthority = null, $docIssueLocation = null, $docID = null, $docType = null, $gender = null, $birthDate = null, $effectiveDate = null, $expireDate = null, $docIssueStateProv = null, $docIssueCountry = null, $birthCountry = null, $docHolderNationality = null)
    {
        $this
            ->setDocHolderName($docHolderName)
            ->setDocHolderFormattedName($docHolderFormattedName)
            ->setDocLimitations($docLimitations)
            ->setAdditionalPersonNames($additionalPersonNames)
            ->setShareSynchInd($shareSynchInd)
            ->setShareMarketInd($shareMarketInd)
            ->setDocIssueAuthority($docIssueAuthority)
            ->setDocIssueLocation($docIssueLocation)
            ->setDocID($docID)
            ->setDocType($docType)
            ->setGender($gender)
            ->setBirthDate($birthDate)
            ->setEffectiveDate($effectiveDate)
            ->setExpireDate($expireDate)
            ->setDocIssueStateProv($docIssueStateProv)
            ->setDocIssueCountry($docIssueCountry)
            ->setBirthCountry($birthCountry)
            ->setDocHolderNationality($docHolderNationality);
    }
    /**
     * Get DocHolderName value
     * @return string|null
     */
    public function getDocHolderName()
    {
        return $this->DocHolderName;
    }
    /**
     * Set DocHolderName value
     * @param string $docHolderName
     * @return \StructType\DocumentType
     */
    public function setDocHolderName($docHolderName = null)
    {
        // validation for constraint: string
        if (!is_null($docHolderName) && !is_string($docHolderName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($docHolderName)), __LINE__);
        }
        $this->DocHolderName = $docHolderName;
        return $this;
    }
    /**
     * Get DocHolderFormattedName value
     * @return \StructType\PersonNameType|null
     */
    public function getDocHolderFormattedName()
    {
        return $this->DocHolderFormattedName;
    }
    /**
     * Set DocHolderFormattedName value
     * @param \StructType\PersonNameType $docHolderFormattedName
     * @return \StructType\DocumentType
     */
    public function setDocHolderFormattedName(\StructType\PersonNameType $docHolderFormattedName = null)
    {
        $this->DocHolderFormattedName = $docHolderFormattedName;
        return $this;
    }
    /**
     * Get DocLimitations value
     * @return string[]|null
     */
    public function getDocLimitations()
    {
        return $this->DocLimitations;
    }
    /**
     * Set DocLimitations value
     * @throws \InvalidArgumentException
     * @param string[] $docLimitations
     * @return \StructType\DocumentType
     */
    public function setDocLimitations(array $docLimitations = array())
    {
        foreach ($docLimitations as $documentTypeDocLimitationsItem) {
            // validation for constraint: itemType
            if (!is_string($documentTypeDocLimitationsItem)) {
                throw new \InvalidArgumentException(sprintf('The DocLimitations property can only contain items of string, "%s" given', is_object($documentTypeDocLimitationsItem) ? get_class($documentTypeDocLimitationsItem) : gettype($documentTypeDocLimitationsItem)), __LINE__);
            }
        }
        $this->DocLimitations = $docLimitations;
        return $this;
    }
    /**
     * Add item to DocLimitations value
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \StructType\DocumentType
     */
    public function addToDocLimitations($item)
    {
        // validation for constraint: itemType
        if (!is_string($item)) {
            throw new \InvalidArgumentException(sprintf('The DocLimitations property can only contain items of string, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->DocLimitations[] = $item;
        return $this;
    }
    /**
     * Get AdditionalPersonNames value
     * @return \ArrayType\ArrayOfString|null
     */
    public function getAdditionalPersonNames()
    {
        return $this->AdditionalPersonNames;
    }
    /**
     * Set AdditionalPersonNames value
     * @param \ArrayType\ArrayOfString $additionalPersonNames
     * @return \StructType\DocumentType
     */
    public function setAdditionalPersonNames(\ArrayType\ArrayOfString $additionalPersonNames = null)
    {
        $this->AdditionalPersonNames = $additionalPersonNames;
        return $this;
    }
    /**
     * Get ShareSynchInd value
     * @return string|null
     */
    public function getShareSynchInd()
    {
        return $this->ShareSynchInd;
    }
    /**
     * Set ShareSynchInd value
     * @param string $shareSynchInd
     * @return \StructType\DocumentType
     */
    public function setShareSynchInd($shareSynchInd = null)
    {
        // validation for constraint: string
        if (!is_null($shareSynchInd) && !is_string($shareSynchInd)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($shareSynchInd)), __LINE__);
        }
        $this->ShareSynchInd = $shareSynchInd;
        return $this;
    }
    /**
     * Get ShareMarketInd value
     * @return string|null
     */
    public function getShareMarketInd()
    {
        return $this->ShareMarketInd;
    }
    /**
     * Set ShareMarketInd value
     * @param string $shareMarketInd
     * @return \StructType\DocumentType
     */
    public function setShareMarketInd($shareMarketInd = null)
    {
        // validation for constraint: string
        if (!is_null($shareMarketInd) && !is_string($shareMarketInd)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($shareMarketInd)), __LINE__);
        }
        $this->ShareMarketInd = $shareMarketInd;
        return $this;
    }
    /**
     * Get DocIssueAuthority value
     * @return string|null
     */
    public function getDocIssueAuthority()
    {
        return $this->DocIssueAuthority;
    }
    /**
     * Set DocIssueAuthority value
     * @param string $docIssueAuthority
     * @return \StructType\DocumentType
     */
    public function setDocIssueAuthority($docIssueAuthority = null)
    {
        // validation for constraint: string
        if (!is_null($docIssueAuthority) && !is_string($docIssueAuthority)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($docIssueAuthority)), __LINE__);
        }
        $this->DocIssueAuthority = $docIssueAuthority;
        return $this;
    }
    /**
     * Get DocIssueLocation value
     * @return string|null
     */
    public function getDocIssueLocation()
    {
        return $this->DocIssueLocation;
    }
    /**
     * Set DocIssueLocation value
     * @param string $docIssueLocation
     * @return \StructType\DocumentType
     */
    public function setDocIssueLocation($docIssueLocation = null)
    {
        // validation for constraint: string
        if (!is_null($docIssueLocation) && !is_string($docIssueLocation)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($docIssueLocation)), __LINE__);
        }
        $this->DocIssueLocation = $docIssueLocation;
        return $this;
    }
    /**
     * Get DocID value
     * @return string|null
     */
    public function getDocID()
    {
        return $this->DocID;
    }
    /**
     * Set DocID value
     * @param string $docID
     * @return \StructType\DocumentType
     */
    public function setDocID($docID = null)
    {
        // validation for constraint: string
        if (!is_null($docID) && !is_string($docID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($docID)), __LINE__);
        }
        $this->DocID = $docID;
        return $this;
    }
    /**
     * Get DocType value
     * @return string|null
     */
    public function getDocType()
    {
        return $this->DocType;
    }
    /**
     * Set DocType value
     * @param string $docType
     * @return \StructType\DocumentType
     */
    public function setDocType($docType = null)
    {
        // validation for constraint: string
        if (!is_null($docType) && !is_string($docType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($docType)), __LINE__);
        }
        $this->DocType = $docType;
        return $this;
    }
    /**
     * Get Gender value
     * @return string|null
     */
    public function getGender()
    {
        return $this->Gender;
    }
    /**
     * Set Gender value
     * @param string $gender
     * @return \StructType\DocumentType
     */
    public function setGender($gender = null)
    {
        // validation for constraint: string
        if (!is_null($gender) && !is_string($gender)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($gender)), __LINE__);
        }
        $this->Gender = $gender;
        return $this;
    }
    /**
     * Get BirthDate value
     * @return string|null
     */
    public function getBirthDate()
    {
        return $this->BirthDate;
    }
    /**
     * Set BirthDate value
     * @param string $birthDate
     * @return \StructType\DocumentType
     */
    public function setBirthDate($birthDate = null)
    {
        // validation for constraint: string
        if (!is_null($birthDate) && !is_string($birthDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($birthDate)), __LINE__);
        }
        $this->BirthDate = $birthDate;
        return $this;
    }
    /**
     * Get EffectiveDate value
     * @return string|null
     */
    public function getEffectiveDate()
    {
        return $this->EffectiveDate;
    }
    /**
     * Set EffectiveDate value
     * @param string $effectiveDate
     * @return \StructType\DocumentType
     */
    public function setEffectiveDate($effectiveDate = null)
    {
        // validation for constraint: string
        if (!is_null($effectiveDate) && !is_string($effectiveDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($effectiveDate)), __LINE__);
        }
        $this->EffectiveDate = $effectiveDate;
        return $this;
    }
    /**
     * Get ExpireDate value
     * @return string|null
     */
    public function getExpireDate()
    {
        return $this->ExpireDate;
    }
    /**
     * Set ExpireDate value
     * @param string $expireDate
     * @return \StructType\DocumentType
     */
    public function setExpireDate($expireDate = null)
    {
        // validation for constraint: string
        if (!is_null($expireDate) && !is_string($expireDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($expireDate)), __LINE__);
        }
        $this->ExpireDate = $expireDate;
        return $this;
    }
    /**
     * Get DocIssueStateProv value
     * @return string|null
     */
    public function getDocIssueStateProv()
    {
        return $this->DocIssueStateProv;
    }
    /**
     * Set DocIssueStateProv value
     * @param string $docIssueStateProv
     * @return \StructType\DocumentType
     */
    public function setDocIssueStateProv($docIssueStateProv = null)
    {
        // validation for constraint: string
        if (!is_null($docIssueStateProv) && !is_string($docIssueStateProv)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($docIssueStateProv)), __LINE__);
        }
        $this->DocIssueStateProv = $docIssueStateProv;
        return $this;
    }
    /**
     * Get DocIssueCountry value
     * @return string|null
     */
    public function getDocIssueCountry()
    {
        return $this->DocIssueCountry;
    }
    /**
     * Set DocIssueCountry value
     * @param string $docIssueCountry
     * @return \StructType\DocumentType
     */
    public function setDocIssueCountry($docIssueCountry = null)
    {
        // validation for constraint: string
        if (!is_null($docIssueCountry) && !is_string($docIssueCountry)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($docIssueCountry)), __LINE__);
        }
        $this->DocIssueCountry = $docIssueCountry;
        return $this;
    }
    /**
     * Get BirthCountry value
     * @return string|null
     */
    public function getBirthCountry()
    {
        return $this->BirthCountry;
    }
    /**
     * Set BirthCountry value
     * @param string $birthCountry
     * @return \StructType\DocumentType
     */
    public function setBirthCountry($birthCountry = null)
    {
        // validation for constraint: string
        if (!is_null($birthCountry) && !is_string($birthCountry)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($birthCountry)), __LINE__);
        }
        $this->BirthCountry = $birthCountry;
        return $this;
    }
    /**
     * Get DocHolderNationality value
     * @return string|null
     */
    public function getDocHolderNationality()
    {
        return $this->DocHolderNationality;
    }
    /**
     * Set DocHolderNationality value
     * @param string $docHolderNationality
     * @return \StructType\DocumentType
     */
    public function setDocHolderNationality($docHolderNationality = null)
    {
        // validation for constraint: string
        if (!is_null($docHolderNationality) && !is_string($docHolderNationality)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($docHolderNationality)), __LINE__);
        }
        $this->DocHolderNationality = $docHolderNationality;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\DocumentType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
