<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CommonPrefType StructType
 * @subpackage Structs
 */
class CommonPrefType extends AbstractStructBase
{
    /**
     * The NamePref
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\NamePrefType[]
     */
    public $NamePref;
    /**
     * The PhonePref
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\PhonePrefType[]
     */
    public $PhonePref;
    /**
     * The AddressPref
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\AddressPrefType[]
     */
    public $AddressPref;
    /**
     * The PaymentFormPref
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\PaymentFormPrefType[]
     */
    public $PaymentFormPref;
    /**
     * The InterestPref
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\InterestPrefType[]
     */
    public $InterestPref;
    /**
     * The InsurancePref
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\InsurancePrefType[]
     */
    public $InsurancePref;
    /**
     * The SeatingPref
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\SeatingPrefType[]
     */
    public $SeatingPref;
    /**
     * The TicketDistribPref
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\TicketDistribPrefType[]
     */
    public $TicketDistribPref;
    /**
     * The MediaEntertainPref
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\MediaEntertainPrefType[]
     */
    public $MediaEntertainPref;
    /**
     * The PetInfoPref
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\PetInfoPrefType[]
     */
    public $PetInfoPref;
    /**
     * The MealPref
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\MealPrefType[]
     */
    public $MealPref;
    /**
     * The LoyaltyPref
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\LoyaltyPrefType[]
     */
    public $LoyaltyPref;
    /**
     * The SpecRequestPref
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\SpecRequestPrefType[]
     */
    public $SpecRequestPref;
    /**
     * The RelatedTravelerPref
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\RelatedTravelerPrefType[]
     */
    public $RelatedTravelerPref;
    /**
     * The TPA_Extensions
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\TPA_Extensions_Type
     */
    public $TPA_Extensions;
    /**
     * The ShareSynchInd
     * @var string
     */
    public $ShareSynchInd;
    /**
     * The ShareMarketInd
     * @var string
     */
    public $ShareMarketInd;
    /**
     * The SmokingAllowed
     * Meta informations extracted from the WSDL
     * - default: false
     * @var bool
     */
    public $SmokingAllowed;
    /**
     * The PrimaryLangID
     * @var string
     */
    public $PrimaryLangID;
    /**
     * The AltLangID
     * @var string
     */
    public $AltLangID;
    /**
     * Constructor method for CommonPrefType
     * @uses CommonPrefType::setNamePref()
     * @uses CommonPrefType::setPhonePref()
     * @uses CommonPrefType::setAddressPref()
     * @uses CommonPrefType::setPaymentFormPref()
     * @uses CommonPrefType::setInterestPref()
     * @uses CommonPrefType::setInsurancePref()
     * @uses CommonPrefType::setSeatingPref()
     * @uses CommonPrefType::setTicketDistribPref()
     * @uses CommonPrefType::setMediaEntertainPref()
     * @uses CommonPrefType::setPetInfoPref()
     * @uses CommonPrefType::setMealPref()
     * @uses CommonPrefType::setLoyaltyPref()
     * @uses CommonPrefType::setSpecRequestPref()
     * @uses CommonPrefType::setRelatedTravelerPref()
     * @uses CommonPrefType::setTPA_Extensions()
     * @uses CommonPrefType::setShareSynchInd()
     * @uses CommonPrefType::setShareMarketInd()
     * @uses CommonPrefType::setSmokingAllowed()
     * @uses CommonPrefType::setPrimaryLangID()
     * @uses CommonPrefType::setAltLangID()
     * @param \StructType\NamePrefType[] $namePref
     * @param \StructType\PhonePrefType[] $phonePref
     * @param \StructType\AddressPrefType[] $addressPref
     * @param \StructType\PaymentFormPrefType[] $paymentFormPref
     * @param \StructType\InterestPrefType[] $interestPref
     * @param \StructType\InsurancePrefType[] $insurancePref
     * @param \StructType\SeatingPrefType[] $seatingPref
     * @param \StructType\TicketDistribPrefType[] $ticketDistribPref
     * @param \StructType\MediaEntertainPrefType[] $mediaEntertainPref
     * @param \StructType\PetInfoPrefType[] $petInfoPref
     * @param \StructType\MealPrefType[] $mealPref
     * @param \StructType\LoyaltyPrefType[] $loyaltyPref
     * @param \StructType\SpecRequestPrefType[] $specRequestPref
     * @param \StructType\RelatedTravelerPrefType[] $relatedTravelerPref
     * @param \StructType\TPA_Extensions_Type $tPA_Extensions
     * @param string $shareSynchInd
     * @param string $shareMarketInd
     * @param bool $smokingAllowed
     * @param string $primaryLangID
     * @param string $altLangID
     */
    public function __construct(array $namePref = array(), array $phonePref = array(), array $addressPref = array(), array $paymentFormPref = array(), array $interestPref = array(), array $insurancePref = array(), array $seatingPref = array(), array $ticketDistribPref = array(), array $mediaEntertainPref = array(), array $petInfoPref = array(), array $mealPref = array(), array $loyaltyPref = array(), array $specRequestPref = array(), array $relatedTravelerPref = array(), \StructType\TPA_Extensions_Type $tPA_Extensions = null, $shareSynchInd = null, $shareMarketInd = null, $smokingAllowed = false, $primaryLangID = null, $altLangID = null)
    {
        $this
            ->setNamePref($namePref)
            ->setPhonePref($phonePref)
            ->setAddressPref($addressPref)
            ->setPaymentFormPref($paymentFormPref)
            ->setInterestPref($interestPref)
            ->setInsurancePref($insurancePref)
            ->setSeatingPref($seatingPref)
            ->setTicketDistribPref($ticketDistribPref)
            ->setMediaEntertainPref($mediaEntertainPref)
            ->setPetInfoPref($petInfoPref)
            ->setMealPref($mealPref)
            ->setLoyaltyPref($loyaltyPref)
            ->setSpecRequestPref($specRequestPref)
            ->setRelatedTravelerPref($relatedTravelerPref)
            ->setTPA_Extensions($tPA_Extensions)
            ->setShareSynchInd($shareSynchInd)
            ->setShareMarketInd($shareMarketInd)
            ->setSmokingAllowed($smokingAllowed)
            ->setPrimaryLangID($primaryLangID)
            ->setAltLangID($altLangID);
    }
    /**
     * Get NamePref value
     * @return \StructType\NamePrefType[]|null
     */
    public function getNamePref()
    {
        return $this->NamePref;
    }
    /**
     * Set NamePref value
     * @throws \InvalidArgumentException
     * @param \StructType\NamePrefType[] $namePref
     * @return \StructType\CommonPrefType
     */
    public function setNamePref(array $namePref = array())
    {
        foreach ($namePref as $commonPrefTypeNamePrefItem) {
            // validation for constraint: itemType
            if (!$commonPrefTypeNamePrefItem instanceof \StructType\NamePrefType) {
                throw new \InvalidArgumentException(sprintf('The NamePref property can only contain items of \StructType\NamePrefType, "%s" given', is_object($commonPrefTypeNamePrefItem) ? get_class($commonPrefTypeNamePrefItem) : gettype($commonPrefTypeNamePrefItem)), __LINE__);
            }
        }
        $this->NamePref = $namePref;
        return $this;
    }
    /**
     * Add item to NamePref value
     * @throws \InvalidArgumentException
     * @param \StructType\NamePrefType $item
     * @return \StructType\CommonPrefType
     */
    public function addToNamePref(\StructType\NamePrefType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\NamePrefType) {
            throw new \InvalidArgumentException(sprintf('The NamePref property can only contain items of \StructType\NamePrefType, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->NamePref[] = $item;
        return $this;
    }
    /**
     * Get PhonePref value
     * @return \StructType\PhonePrefType[]|null
     */
    public function getPhonePref()
    {
        return $this->PhonePref;
    }
    /**
     * Set PhonePref value
     * @throws \InvalidArgumentException
     * @param \StructType\PhonePrefType[] $phonePref
     * @return \StructType\CommonPrefType
     */
    public function setPhonePref(array $phonePref = array())
    {
        foreach ($phonePref as $commonPrefTypePhonePrefItem) {
            // validation for constraint: itemType
            if (!$commonPrefTypePhonePrefItem instanceof \StructType\PhonePrefType) {
                throw new \InvalidArgumentException(sprintf('The PhonePref property can only contain items of \StructType\PhonePrefType, "%s" given', is_object($commonPrefTypePhonePrefItem) ? get_class($commonPrefTypePhonePrefItem) : gettype($commonPrefTypePhonePrefItem)), __LINE__);
            }
        }
        $this->PhonePref = $phonePref;
        return $this;
    }
    /**
     * Add item to PhonePref value
     * @throws \InvalidArgumentException
     * @param \StructType\PhonePrefType $item
     * @return \StructType\CommonPrefType
     */
    public function addToPhonePref(\StructType\PhonePrefType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\PhonePrefType) {
            throw new \InvalidArgumentException(sprintf('The PhonePref property can only contain items of \StructType\PhonePrefType, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->PhonePref[] = $item;
        return $this;
    }
    /**
     * Get AddressPref value
     * @return \StructType\AddressPrefType[]|null
     */
    public function getAddressPref()
    {
        return $this->AddressPref;
    }
    /**
     * Set AddressPref value
     * @throws \InvalidArgumentException
     * @param \StructType\AddressPrefType[] $addressPref
     * @return \StructType\CommonPrefType
     */
    public function setAddressPref(array $addressPref = array())
    {
        foreach ($addressPref as $commonPrefTypeAddressPrefItem) {
            // validation for constraint: itemType
            if (!$commonPrefTypeAddressPrefItem instanceof \StructType\AddressPrefType) {
                throw new \InvalidArgumentException(sprintf('The AddressPref property can only contain items of \StructType\AddressPrefType, "%s" given', is_object($commonPrefTypeAddressPrefItem) ? get_class($commonPrefTypeAddressPrefItem) : gettype($commonPrefTypeAddressPrefItem)), __LINE__);
            }
        }
        $this->AddressPref = $addressPref;
        return $this;
    }
    /**
     * Add item to AddressPref value
     * @throws \InvalidArgumentException
     * @param \StructType\AddressPrefType $item
     * @return \StructType\CommonPrefType
     */
    public function addToAddressPref(\StructType\AddressPrefType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\AddressPrefType) {
            throw new \InvalidArgumentException(sprintf('The AddressPref property can only contain items of \StructType\AddressPrefType, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->AddressPref[] = $item;
        return $this;
    }
    /**
     * Get PaymentFormPref value
     * @return \StructType\PaymentFormPrefType[]|null
     */
    public function getPaymentFormPref()
    {
        return $this->PaymentFormPref;
    }
    /**
     * Set PaymentFormPref value
     * @throws \InvalidArgumentException
     * @param \StructType\PaymentFormPrefType[] $paymentFormPref
     * @return \StructType\CommonPrefType
     */
    public function setPaymentFormPref(array $paymentFormPref = array())
    {
        foreach ($paymentFormPref as $commonPrefTypePaymentFormPrefItem) {
            // validation for constraint: itemType
            if (!$commonPrefTypePaymentFormPrefItem instanceof \StructType\PaymentFormPrefType) {
                throw new \InvalidArgumentException(sprintf('The PaymentFormPref property can only contain items of \StructType\PaymentFormPrefType, "%s" given', is_object($commonPrefTypePaymentFormPrefItem) ? get_class($commonPrefTypePaymentFormPrefItem) : gettype($commonPrefTypePaymentFormPrefItem)), __LINE__);
            }
        }
        $this->PaymentFormPref = $paymentFormPref;
        return $this;
    }
    /**
     * Add item to PaymentFormPref value
     * @throws \InvalidArgumentException
     * @param \StructType\PaymentFormPrefType $item
     * @return \StructType\CommonPrefType
     */
    public function addToPaymentFormPref(\StructType\PaymentFormPrefType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\PaymentFormPrefType) {
            throw new \InvalidArgumentException(sprintf('The PaymentFormPref property can only contain items of \StructType\PaymentFormPrefType, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->PaymentFormPref[] = $item;
        return $this;
    }
    /**
     * Get InterestPref value
     * @return \StructType\InterestPrefType[]|null
     */
    public function getInterestPref()
    {
        return $this->InterestPref;
    }
    /**
     * Set InterestPref value
     * @throws \InvalidArgumentException
     * @param \StructType\InterestPrefType[] $interestPref
     * @return \StructType\CommonPrefType
     */
    public function setInterestPref(array $interestPref = array())
    {
        foreach ($interestPref as $commonPrefTypeInterestPrefItem) {
            // validation for constraint: itemType
            if (!$commonPrefTypeInterestPrefItem instanceof \StructType\InterestPrefType) {
                throw new \InvalidArgumentException(sprintf('The InterestPref property can only contain items of \StructType\InterestPrefType, "%s" given', is_object($commonPrefTypeInterestPrefItem) ? get_class($commonPrefTypeInterestPrefItem) : gettype($commonPrefTypeInterestPrefItem)), __LINE__);
            }
        }
        $this->InterestPref = $interestPref;
        return $this;
    }
    /**
     * Add item to InterestPref value
     * @throws \InvalidArgumentException
     * @param \StructType\InterestPrefType $item
     * @return \StructType\CommonPrefType
     */
    public function addToInterestPref(\StructType\InterestPrefType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\InterestPrefType) {
            throw new \InvalidArgumentException(sprintf('The InterestPref property can only contain items of \StructType\InterestPrefType, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->InterestPref[] = $item;
        return $this;
    }
    /**
     * Get InsurancePref value
     * @return \StructType\InsurancePrefType[]|null
     */
    public function getInsurancePref()
    {
        return $this->InsurancePref;
    }
    /**
     * Set InsurancePref value
     * @throws \InvalidArgumentException
     * @param \StructType\InsurancePrefType[] $insurancePref
     * @return \StructType\CommonPrefType
     */
    public function setInsurancePref(array $insurancePref = array())
    {
        foreach ($insurancePref as $commonPrefTypeInsurancePrefItem) {
            // validation for constraint: itemType
            if (!$commonPrefTypeInsurancePrefItem instanceof \StructType\InsurancePrefType) {
                throw new \InvalidArgumentException(sprintf('The InsurancePref property can only contain items of \StructType\InsurancePrefType, "%s" given', is_object($commonPrefTypeInsurancePrefItem) ? get_class($commonPrefTypeInsurancePrefItem) : gettype($commonPrefTypeInsurancePrefItem)), __LINE__);
            }
        }
        $this->InsurancePref = $insurancePref;
        return $this;
    }
    /**
     * Add item to InsurancePref value
     * @throws \InvalidArgumentException
     * @param \StructType\InsurancePrefType $item
     * @return \StructType\CommonPrefType
     */
    public function addToInsurancePref(\StructType\InsurancePrefType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\InsurancePrefType) {
            throw new \InvalidArgumentException(sprintf('The InsurancePref property can only contain items of \StructType\InsurancePrefType, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->InsurancePref[] = $item;
        return $this;
    }
    /**
     * Get SeatingPref value
     * @return \StructType\SeatingPrefType[]|null
     */
    public function getSeatingPref()
    {
        return $this->SeatingPref;
    }
    /**
     * Set SeatingPref value
     * @throws \InvalidArgumentException
     * @param \StructType\SeatingPrefType[] $seatingPref
     * @return \StructType\CommonPrefType
     */
    public function setSeatingPref(array $seatingPref = array())
    {
        foreach ($seatingPref as $commonPrefTypeSeatingPrefItem) {
            // validation for constraint: itemType
            if (!$commonPrefTypeSeatingPrefItem instanceof \StructType\SeatingPrefType) {
                throw new \InvalidArgumentException(sprintf('The SeatingPref property can only contain items of \StructType\SeatingPrefType, "%s" given', is_object($commonPrefTypeSeatingPrefItem) ? get_class($commonPrefTypeSeatingPrefItem) : gettype($commonPrefTypeSeatingPrefItem)), __LINE__);
            }
        }
        $this->SeatingPref = $seatingPref;
        return $this;
    }
    /**
     * Add item to SeatingPref value
     * @throws \InvalidArgumentException
     * @param \StructType\SeatingPrefType $item
     * @return \StructType\CommonPrefType
     */
    public function addToSeatingPref(\StructType\SeatingPrefType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\SeatingPrefType) {
            throw new \InvalidArgumentException(sprintf('The SeatingPref property can only contain items of \StructType\SeatingPrefType, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->SeatingPref[] = $item;
        return $this;
    }
    /**
     * Get TicketDistribPref value
     * @return \StructType\TicketDistribPrefType[]|null
     */
    public function getTicketDistribPref()
    {
        return $this->TicketDistribPref;
    }
    /**
     * Set TicketDistribPref value
     * @throws \InvalidArgumentException
     * @param \StructType\TicketDistribPrefType[] $ticketDistribPref
     * @return \StructType\CommonPrefType
     */
    public function setTicketDistribPref(array $ticketDistribPref = array())
    {
        foreach ($ticketDistribPref as $commonPrefTypeTicketDistribPrefItem) {
            // validation for constraint: itemType
            if (!$commonPrefTypeTicketDistribPrefItem instanceof \StructType\TicketDistribPrefType) {
                throw new \InvalidArgumentException(sprintf('The TicketDistribPref property can only contain items of \StructType\TicketDistribPrefType, "%s" given', is_object($commonPrefTypeTicketDistribPrefItem) ? get_class($commonPrefTypeTicketDistribPrefItem) : gettype($commonPrefTypeTicketDistribPrefItem)), __LINE__);
            }
        }
        $this->TicketDistribPref = $ticketDistribPref;
        return $this;
    }
    /**
     * Add item to TicketDistribPref value
     * @throws \InvalidArgumentException
     * @param \StructType\TicketDistribPrefType $item
     * @return \StructType\CommonPrefType
     */
    public function addToTicketDistribPref(\StructType\TicketDistribPrefType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\TicketDistribPrefType) {
            throw new \InvalidArgumentException(sprintf('The TicketDistribPref property can only contain items of \StructType\TicketDistribPrefType, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->TicketDistribPref[] = $item;
        return $this;
    }
    /**
     * Get MediaEntertainPref value
     * @return \StructType\MediaEntertainPrefType[]|null
     */
    public function getMediaEntertainPref()
    {
        return $this->MediaEntertainPref;
    }
    /**
     * Set MediaEntertainPref value
     * @throws \InvalidArgumentException
     * @param \StructType\MediaEntertainPrefType[] $mediaEntertainPref
     * @return \StructType\CommonPrefType
     */
    public function setMediaEntertainPref(array $mediaEntertainPref = array())
    {
        foreach ($mediaEntertainPref as $commonPrefTypeMediaEntertainPrefItem) {
            // validation for constraint: itemType
            if (!$commonPrefTypeMediaEntertainPrefItem instanceof \StructType\MediaEntertainPrefType) {
                throw new \InvalidArgumentException(sprintf('The MediaEntertainPref property can only contain items of \StructType\MediaEntertainPrefType, "%s" given', is_object($commonPrefTypeMediaEntertainPrefItem) ? get_class($commonPrefTypeMediaEntertainPrefItem) : gettype($commonPrefTypeMediaEntertainPrefItem)), __LINE__);
            }
        }
        $this->MediaEntertainPref = $mediaEntertainPref;
        return $this;
    }
    /**
     * Add item to MediaEntertainPref value
     * @throws \InvalidArgumentException
     * @param \StructType\MediaEntertainPrefType $item
     * @return \StructType\CommonPrefType
     */
    public function addToMediaEntertainPref(\StructType\MediaEntertainPrefType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\MediaEntertainPrefType) {
            throw new \InvalidArgumentException(sprintf('The MediaEntertainPref property can only contain items of \StructType\MediaEntertainPrefType, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->MediaEntertainPref[] = $item;
        return $this;
    }
    /**
     * Get PetInfoPref value
     * @return \StructType\PetInfoPrefType[]|null
     */
    public function getPetInfoPref()
    {
        return $this->PetInfoPref;
    }
    /**
     * Set PetInfoPref value
     * @throws \InvalidArgumentException
     * @param \StructType\PetInfoPrefType[] $petInfoPref
     * @return \StructType\CommonPrefType
     */
    public function setPetInfoPref(array $petInfoPref = array())
    {
        foreach ($petInfoPref as $commonPrefTypePetInfoPrefItem) {
            // validation for constraint: itemType
            if (!$commonPrefTypePetInfoPrefItem instanceof \StructType\PetInfoPrefType) {
                throw new \InvalidArgumentException(sprintf('The PetInfoPref property can only contain items of \StructType\PetInfoPrefType, "%s" given', is_object($commonPrefTypePetInfoPrefItem) ? get_class($commonPrefTypePetInfoPrefItem) : gettype($commonPrefTypePetInfoPrefItem)), __LINE__);
            }
        }
        $this->PetInfoPref = $petInfoPref;
        return $this;
    }
    /**
     * Add item to PetInfoPref value
     * @throws \InvalidArgumentException
     * @param \StructType\PetInfoPrefType $item
     * @return \StructType\CommonPrefType
     */
    public function addToPetInfoPref(\StructType\PetInfoPrefType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\PetInfoPrefType) {
            throw new \InvalidArgumentException(sprintf('The PetInfoPref property can only contain items of \StructType\PetInfoPrefType, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->PetInfoPref[] = $item;
        return $this;
    }
    /**
     * Get MealPref value
     * @return \StructType\MealPrefType[]|null
     */
    public function getMealPref()
    {
        return $this->MealPref;
    }
    /**
     * Set MealPref value
     * @throws \InvalidArgumentException
     * @param \StructType\MealPrefType[] $mealPref
     * @return \StructType\CommonPrefType
     */
    public function setMealPref(array $mealPref = array())
    {
        foreach ($mealPref as $commonPrefTypeMealPrefItem) {
            // validation for constraint: itemType
            if (!$commonPrefTypeMealPrefItem instanceof \StructType\MealPrefType) {
                throw new \InvalidArgumentException(sprintf('The MealPref property can only contain items of \StructType\MealPrefType, "%s" given', is_object($commonPrefTypeMealPrefItem) ? get_class($commonPrefTypeMealPrefItem) : gettype($commonPrefTypeMealPrefItem)), __LINE__);
            }
        }
        $this->MealPref = $mealPref;
        return $this;
    }
    /**
     * Add item to MealPref value
     * @throws \InvalidArgumentException
     * @param \StructType\MealPrefType $item
     * @return \StructType\CommonPrefType
     */
    public function addToMealPref(\StructType\MealPrefType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\MealPrefType) {
            throw new \InvalidArgumentException(sprintf('The MealPref property can only contain items of \StructType\MealPrefType, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->MealPref[] = $item;
        return $this;
    }
    /**
     * Get LoyaltyPref value
     * @return \StructType\LoyaltyPrefType[]|null
     */
    public function getLoyaltyPref()
    {
        return $this->LoyaltyPref;
    }
    /**
     * Set LoyaltyPref value
     * @throws \InvalidArgumentException
     * @param \StructType\LoyaltyPrefType[] $loyaltyPref
     * @return \StructType\CommonPrefType
     */
    public function setLoyaltyPref(array $loyaltyPref = array())
    {
        foreach ($loyaltyPref as $commonPrefTypeLoyaltyPrefItem) {
            // validation for constraint: itemType
            if (!$commonPrefTypeLoyaltyPrefItem instanceof \StructType\LoyaltyPrefType) {
                throw new \InvalidArgumentException(sprintf('The LoyaltyPref property can only contain items of \StructType\LoyaltyPrefType, "%s" given', is_object($commonPrefTypeLoyaltyPrefItem) ? get_class($commonPrefTypeLoyaltyPrefItem) : gettype($commonPrefTypeLoyaltyPrefItem)), __LINE__);
            }
        }
        $this->LoyaltyPref = $loyaltyPref;
        return $this;
    }
    /**
     * Add item to LoyaltyPref value
     * @throws \InvalidArgumentException
     * @param \StructType\LoyaltyPrefType $item
     * @return \StructType\CommonPrefType
     */
    public function addToLoyaltyPref(\StructType\LoyaltyPrefType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\LoyaltyPrefType) {
            throw new \InvalidArgumentException(sprintf('The LoyaltyPref property can only contain items of \StructType\LoyaltyPrefType, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->LoyaltyPref[] = $item;
        return $this;
    }
    /**
     * Get SpecRequestPref value
     * @return \StructType\SpecRequestPrefType[]|null
     */
    public function getSpecRequestPref()
    {
        return $this->SpecRequestPref;
    }
    /**
     * Set SpecRequestPref value
     * @throws \InvalidArgumentException
     * @param \StructType\SpecRequestPrefType[] $specRequestPref
     * @return \StructType\CommonPrefType
     */
    public function setSpecRequestPref(array $specRequestPref = array())
    {
        foreach ($specRequestPref as $commonPrefTypeSpecRequestPrefItem) {
            // validation for constraint: itemType
            if (!$commonPrefTypeSpecRequestPrefItem instanceof \StructType\SpecRequestPrefType) {
                throw new \InvalidArgumentException(sprintf('The SpecRequestPref property can only contain items of \StructType\SpecRequestPrefType, "%s" given', is_object($commonPrefTypeSpecRequestPrefItem) ? get_class($commonPrefTypeSpecRequestPrefItem) : gettype($commonPrefTypeSpecRequestPrefItem)), __LINE__);
            }
        }
        $this->SpecRequestPref = $specRequestPref;
        return $this;
    }
    /**
     * Add item to SpecRequestPref value
     * @throws \InvalidArgumentException
     * @param \StructType\SpecRequestPrefType $item
     * @return \StructType\CommonPrefType
     */
    public function addToSpecRequestPref(\StructType\SpecRequestPrefType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\SpecRequestPrefType) {
            throw new \InvalidArgumentException(sprintf('The SpecRequestPref property can only contain items of \StructType\SpecRequestPrefType, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->SpecRequestPref[] = $item;
        return $this;
    }
    /**
     * Get RelatedTravelerPref value
     * @return \StructType\RelatedTravelerPrefType[]|null
     */
    public function getRelatedTravelerPref()
    {
        return $this->RelatedTravelerPref;
    }
    /**
     * Set RelatedTravelerPref value
     * @throws \InvalidArgumentException
     * @param \StructType\RelatedTravelerPrefType[] $relatedTravelerPref
     * @return \StructType\CommonPrefType
     */
    public function setRelatedTravelerPref(array $relatedTravelerPref = array())
    {
        foreach ($relatedTravelerPref as $commonPrefTypeRelatedTravelerPrefItem) {
            // validation for constraint: itemType
            if (!$commonPrefTypeRelatedTravelerPrefItem instanceof \StructType\RelatedTravelerPrefType) {
                throw new \InvalidArgumentException(sprintf('The RelatedTravelerPref property can only contain items of \StructType\RelatedTravelerPrefType, "%s" given', is_object($commonPrefTypeRelatedTravelerPrefItem) ? get_class($commonPrefTypeRelatedTravelerPrefItem) : gettype($commonPrefTypeRelatedTravelerPrefItem)), __LINE__);
            }
        }
        $this->RelatedTravelerPref = $relatedTravelerPref;
        return $this;
    }
    /**
     * Add item to RelatedTravelerPref value
     * @throws \InvalidArgumentException
     * @param \StructType\RelatedTravelerPrefType $item
     * @return \StructType\CommonPrefType
     */
    public function addToRelatedTravelerPref(\StructType\RelatedTravelerPrefType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\RelatedTravelerPrefType) {
            throw new \InvalidArgumentException(sprintf('The RelatedTravelerPref property can only contain items of \StructType\RelatedTravelerPrefType, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->RelatedTravelerPref[] = $item;
        return $this;
    }
    /**
     * Get TPA_Extensions value
     * @return \StructType\TPA_Extensions_Type|null
     */
    public function getTPA_Extensions()
    {
        return $this->TPA_Extensions;
    }
    /**
     * Set TPA_Extensions value
     * @param \StructType\TPA_Extensions_Type $tPA_Extensions
     * @return \StructType\CommonPrefType
     */
    public function setTPA_Extensions(\StructType\TPA_Extensions_Type $tPA_Extensions = null)
    {
        $this->TPA_Extensions = $tPA_Extensions;
        return $this;
    }
    /**
     * Get ShareSynchInd value
     * @return string|null
     */
    public function getShareSynchInd()
    {
        return $this->ShareSynchInd;
    }
    /**
     * Set ShareSynchInd value
     * @param string $shareSynchInd
     * @return \StructType\CommonPrefType
     */
    public function setShareSynchInd($shareSynchInd = null)
    {
        // validation for constraint: string
        if (!is_null($shareSynchInd) && !is_string($shareSynchInd)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($shareSynchInd)), __LINE__);
        }
        $this->ShareSynchInd = $shareSynchInd;
        return $this;
    }
    /**
     * Get ShareMarketInd value
     * @return string|null
     */
    public function getShareMarketInd()
    {
        return $this->ShareMarketInd;
    }
    /**
     * Set ShareMarketInd value
     * @param string $shareMarketInd
     * @return \StructType\CommonPrefType
     */
    public function setShareMarketInd($shareMarketInd = null)
    {
        // validation for constraint: string
        if (!is_null($shareMarketInd) && !is_string($shareMarketInd)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($shareMarketInd)), __LINE__);
        }
        $this->ShareMarketInd = $shareMarketInd;
        return $this;
    }
    /**
     * Get SmokingAllowed value
     * @return bool|null
     */
    public function getSmokingAllowed()
    {
        return $this->SmokingAllowed;
    }
    /**
     * Set SmokingAllowed value
     * @param bool $smokingAllowed
     * @return \StructType\CommonPrefType
     */
    public function setSmokingAllowed($smokingAllowed = false)
    {
        $this->SmokingAllowed = $smokingAllowed;
        return $this;
    }
    /**
     * Get PrimaryLangID value
     * @return string|null
     */
    public function getPrimaryLangID()
    {
        return $this->PrimaryLangID;
    }
    /**
     * Set PrimaryLangID value
     * @param string $primaryLangID
     * @return \StructType\CommonPrefType
     */
    public function setPrimaryLangID($primaryLangID = null)
    {
        // validation for constraint: string
        if (!is_null($primaryLangID) && !is_string($primaryLangID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($primaryLangID)), __LINE__);
        }
        $this->PrimaryLangID = $primaryLangID;
        return $this;
    }
    /**
     * Get AltLangID value
     * @return string|null
     */
    public function getAltLangID()
    {
        return $this->AltLangID;
    }
    /**
     * Set AltLangID value
     * @param string $altLangID
     * @return \StructType\CommonPrefType
     */
    public function setAltLangID($altLangID = null)
    {
        // validation for constraint: string
        if (!is_null($altLangID) && !is_string($altLangID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($altLangID)), __LINE__);
        }
        $this->AltLangID = $altLangID;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\CommonPrefType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
