<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Campaigns StructType
 * @subpackage Structs
 */
class Campaigns extends AbstractStructBase
{
    /**
     * The Campaign
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\CampaignType[]
     */
    public $Campaign;
    /**
     * Constructor method for Campaigns
     * @uses Campaigns::setCampaign()
     * @param \StructType\CampaignType[] $campaign
     */
    public function __construct(array $campaign = array())
    {
        $this
            ->setCampaign($campaign);
    }
    /**
     * Get Campaign value
     * @return \StructType\CampaignType[]|null
     */
    public function getCampaign()
    {
        return $this->Campaign;
    }
    /**
     * Set Campaign value
     * @throws \InvalidArgumentException
     * @param \StructType\CampaignType[] $campaign
     * @return \StructType\Campaigns
     */
    public function setCampaign(array $campaign = array())
    {
        foreach ($campaign as $campaignsCampaignItem) {
            // validation for constraint: itemType
            if (!$campaignsCampaignItem instanceof \StructType\CampaignType) {
                throw new \InvalidArgumentException(sprintf('The Campaign property can only contain items of \StructType\CampaignType, "%s" given', is_object($campaignsCampaignItem) ? get_class($campaignsCampaignItem) : gettype($campaignsCampaignItem)), __LINE__);
            }
        }
        $this->Campaign = $campaign;
        return $this;
    }
    /**
     * Add item to Campaign value
     * @throws \InvalidArgumentException
     * @param \StructType\CampaignType $item
     * @return \StructType\Campaigns
     */
    public function addToCampaign(\StructType\CampaignType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\CampaignType) {
            throw new \InvalidArgumentException(sprintf('The Campaign property can only contain items of \StructType\CampaignType, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->Campaign[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\Campaigns
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
