<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CampaignType StructType
 * @subpackage Structs
 */
class CampaignType extends AbstractStructBase
{
    /**
     * The CampaignKeywordReferral
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\CampaignKeywordReferralType[]
     */
    public $CampaignKeywordReferral;
    /**
     * The Campaign_ID
     * @var int
     */
    public $Campaign_ID;
    /**
     * The TollFreeNumber
     * @var string
     */
    public $TollFreeNumber;
    /**
     * The CreationDate
     * @var string
     */
    public $CreationDate;
    /**
     * The EffectiveDate
     * @var string
     */
    public $EffectiveDate;
    /**
     * The ExpirationDate
     * @var string
     */
    public $ExpirationDate;
    /**
     * The UpdatedDate
     * @var string
     */
    public $UpdatedDate;
    /**
     * The Name
     * @var string
     */
    public $Name;
    /**
     * The IsActive
     * @var bool
     */
    public $IsActive;
    /**
     * The IsDeleted
     * @var bool
     */
    public $IsDeleted;
    /**
     * Constructor method for CampaignType
     * @uses CampaignType::setCampaignKeywordReferral()
     * @uses CampaignType::setCampaign_ID()
     * @uses CampaignType::setTollFreeNumber()
     * @uses CampaignType::setCreationDate()
     * @uses CampaignType::setEffectiveDate()
     * @uses CampaignType::setExpirationDate()
     * @uses CampaignType::setUpdatedDate()
     * @uses CampaignType::setName()
     * @uses CampaignType::setIsActive()
     * @uses CampaignType::setIsDeleted()
     * @param \StructType\CampaignKeywordReferralType[] $campaignKeywordReferral
     * @param int $campaign_ID
     * @param string $tollFreeNumber
     * @param string $creationDate
     * @param string $effectiveDate
     * @param string $expirationDate
     * @param string $updatedDate
     * @param string $name
     * @param bool $isActive
     * @param bool $isDeleted
     */
    public function __construct(array $campaignKeywordReferral = array(), $campaign_ID = null, $tollFreeNumber = null, $creationDate = null, $effectiveDate = null, $expirationDate = null, $updatedDate = null, $name = null, $isActive = null, $isDeleted = null)
    {
        $this
            ->setCampaignKeywordReferral($campaignKeywordReferral)
            ->setCampaign_ID($campaign_ID)
            ->setTollFreeNumber($tollFreeNumber)
            ->setCreationDate($creationDate)
            ->setEffectiveDate($effectiveDate)
            ->setExpirationDate($expirationDate)
            ->setUpdatedDate($updatedDate)
            ->setName($name)
            ->setIsActive($isActive)
            ->setIsDeleted($isDeleted);
    }
    /**
     * Get CampaignKeywordReferral value
     * @return \StructType\CampaignKeywordReferralType[]|null
     */
    public function getCampaignKeywordReferral()
    {
        return $this->CampaignKeywordReferral;
    }
    /**
     * Set CampaignKeywordReferral value
     * @throws \InvalidArgumentException
     * @param \StructType\CampaignKeywordReferralType[] $campaignKeywordReferral
     * @return \StructType\CampaignType
     */
    public function setCampaignKeywordReferral(array $campaignKeywordReferral = array())
    {
        foreach ($campaignKeywordReferral as $campaignTypeCampaignKeywordReferralItem) {
            // validation for constraint: itemType
            if (!$campaignTypeCampaignKeywordReferralItem instanceof \StructType\CampaignKeywordReferralType) {
                throw new \InvalidArgumentException(sprintf('The CampaignKeywordReferral property can only contain items of \StructType\CampaignKeywordReferralType, "%s" given', is_object($campaignTypeCampaignKeywordReferralItem) ? get_class($campaignTypeCampaignKeywordReferralItem) : gettype($campaignTypeCampaignKeywordReferralItem)), __LINE__);
            }
        }
        $this->CampaignKeywordReferral = $campaignKeywordReferral;
        return $this;
    }
    /**
     * Add item to CampaignKeywordReferral value
     * @throws \InvalidArgumentException
     * @param \StructType\CampaignKeywordReferralType $item
     * @return \StructType\CampaignType
     */
    public function addToCampaignKeywordReferral(\StructType\CampaignKeywordReferralType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\CampaignKeywordReferralType) {
            throw new \InvalidArgumentException(sprintf('The CampaignKeywordReferral property can only contain items of \StructType\CampaignKeywordReferralType, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->CampaignKeywordReferral[] = $item;
        return $this;
    }
    /**
     * Get Campaign_ID value
     * @return int|null
     */
    public function getCampaign_ID()
    {
        return $this->Campaign_ID;
    }
    /**
     * Set Campaign_ID value
     * @param int $campaign_ID
     * @return \StructType\CampaignType
     */
    public function setCampaign_ID($campaign_ID = null)
    {
        // validation for constraint: int
        if (!is_null($campaign_ID) && !is_numeric($campaign_ID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($campaign_ID)), __LINE__);
        }
        $this->Campaign_ID = $campaign_ID;
        return $this;
    }
    /**
     * Get TollFreeNumber value
     * @return string|null
     */
    public function getTollFreeNumber()
    {
        return $this->TollFreeNumber;
    }
    /**
     * Set TollFreeNumber value
     * @param string $tollFreeNumber
     * @return \StructType\CampaignType
     */
    public function setTollFreeNumber($tollFreeNumber = null)
    {
        // validation for constraint: string
        if (!is_null($tollFreeNumber) && !is_string($tollFreeNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($tollFreeNumber)), __LINE__);
        }
        $this->TollFreeNumber = $tollFreeNumber;
        return $this;
    }
    /**
     * Get CreationDate value
     * @return string|null
     */
    public function getCreationDate()
    {
        return $this->CreationDate;
    }
    /**
     * Set CreationDate value
     * @param string $creationDate
     * @return \StructType\CampaignType
     */
    public function setCreationDate($creationDate = null)
    {
        // validation for constraint: string
        if (!is_null($creationDate) && !is_string($creationDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($creationDate)), __LINE__);
        }
        $this->CreationDate = $creationDate;
        return $this;
    }
    /**
     * Get EffectiveDate value
     * @return string|null
     */
    public function getEffectiveDate()
    {
        return $this->EffectiveDate;
    }
    /**
     * Set EffectiveDate value
     * @param string $effectiveDate
     * @return \StructType\CampaignType
     */
    public function setEffectiveDate($effectiveDate = null)
    {
        // validation for constraint: string
        if (!is_null($effectiveDate) && !is_string($effectiveDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($effectiveDate)), __LINE__);
        }
        $this->EffectiveDate = $effectiveDate;
        return $this;
    }
    /**
     * Get ExpirationDate value
     * @return string|null
     */
    public function getExpirationDate()
    {
        return $this->ExpirationDate;
    }
    /**
     * Set ExpirationDate value
     * @param string $expirationDate
     * @return \StructType\CampaignType
     */
    public function setExpirationDate($expirationDate = null)
    {
        // validation for constraint: string
        if (!is_null($expirationDate) && !is_string($expirationDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($expirationDate)), __LINE__);
        }
        $this->ExpirationDate = $expirationDate;
        return $this;
    }
    /**
     * Get UpdatedDate value
     * @return string|null
     */
    public function getUpdatedDate()
    {
        return $this->UpdatedDate;
    }
    /**
     * Set UpdatedDate value
     * @param string $updatedDate
     * @return \StructType\CampaignType
     */
    public function setUpdatedDate($updatedDate = null)
    {
        // validation for constraint: string
        if (!is_null($updatedDate) && !is_string($updatedDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($updatedDate)), __LINE__);
        }
        $this->UpdatedDate = $updatedDate;
        return $this;
    }
    /**
     * Get Name value
     * @return string|null
     */
    public function getName()
    {
        return $this->Name;
    }
    /**
     * Set Name value
     * @param string $name
     * @return \StructType\CampaignType
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($name)), __LINE__);
        }
        $this->Name = $name;
        return $this;
    }
    /**
     * Get IsActive value
     * @return bool|null
     */
    public function getIsActive()
    {
        return $this->IsActive;
    }
    /**
     * Set IsActive value
     * @param bool $isActive
     * @return \StructType\CampaignType
     */
    public function setIsActive($isActive = null)
    {
        $this->IsActive = $isActive;
        return $this;
    }
    /**
     * Get IsDeleted value
     * @return bool|null
     */
    public function getIsDeleted()
    {
        return $this->IsDeleted;
    }
    /**
     * Set IsDeleted value
     * @param bool $isDeleted
     * @return \StructType\CampaignType
     */
    public function setIsDeleted($isDeleted = null)
    {
        $this->IsDeleted = $isDeleted;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\CampaignType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
