<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AdditionalGuestAmounts StructType
 * @subpackage Structs
 */
class AdditionalGuestAmounts extends AbstractStructBase
{
    /**
     * The AdditionalGuestAmount
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\AdditionalGuestAmountType[]
     */
    public $AdditionalGuestAmount;
    /**
     * The AmountBeforeTax
     * @var float
     */
    public $AmountBeforeTax;
    /**
     * The AmountAfterTax
     * @var float
     */
    public $AmountAfterTax;
    /**
     * The CurrencyCode
     * @var string
     */
    public $CurrencyCode;
    /**
     * The DecimalPlaces
     * @var int
     */
    public $DecimalPlaces;
    /**
     * Constructor method for AdditionalGuestAmounts
     * @uses AdditionalGuestAmounts::setAdditionalGuestAmount()
     * @uses AdditionalGuestAmounts::setAmountBeforeTax()
     * @uses AdditionalGuestAmounts::setAmountAfterTax()
     * @uses AdditionalGuestAmounts::setCurrencyCode()
     * @uses AdditionalGuestAmounts::setDecimalPlaces()
     * @param \StructType\AdditionalGuestAmountType[] $additionalGuestAmount
     * @param float $amountBeforeTax
     * @param float $amountAfterTax
     * @param string $currencyCode
     * @param int $decimalPlaces
     */
    public function __construct(array $additionalGuestAmount = array(), $amountBeforeTax = null, $amountAfterTax = null, $currencyCode = null, $decimalPlaces = null)
    {
        $this
            ->setAdditionalGuestAmount($additionalGuestAmount)
            ->setAmountBeforeTax($amountBeforeTax)
            ->setAmountAfterTax($amountAfterTax)
            ->setCurrencyCode($currencyCode)
            ->setDecimalPlaces($decimalPlaces);
    }
    /**
     * Get AdditionalGuestAmount value
     * @return \StructType\AdditionalGuestAmountType[]|null
     */
    public function getAdditionalGuestAmount()
    {
        return $this->AdditionalGuestAmount;
    }
    /**
     * Set AdditionalGuestAmount value
     * @throws \InvalidArgumentException
     * @param \StructType\AdditionalGuestAmountType[] $additionalGuestAmount
     * @return \StructType\AdditionalGuestAmounts
     */
    public function setAdditionalGuestAmount(array $additionalGuestAmount = array())
    {
        foreach ($additionalGuestAmount as $additionalGuestAmountsAdditionalGuestAmountItem) {
            // validation for constraint: itemType
            if (!$additionalGuestAmountsAdditionalGuestAmountItem instanceof \StructType\AdditionalGuestAmountType) {
                throw new \InvalidArgumentException(sprintf('The AdditionalGuestAmount property can only contain items of \StructType\AdditionalGuestAmountType, "%s" given', is_object($additionalGuestAmountsAdditionalGuestAmountItem) ? get_class($additionalGuestAmountsAdditionalGuestAmountItem) : gettype($additionalGuestAmountsAdditionalGuestAmountItem)), __LINE__);
            }
        }
        $this->AdditionalGuestAmount = $additionalGuestAmount;
        return $this;
    }
    /**
     * Add item to AdditionalGuestAmount value
     * @throws \InvalidArgumentException
     * @param \StructType\AdditionalGuestAmountType $item
     * @return \StructType\AdditionalGuestAmounts
     */
    public function addToAdditionalGuestAmount(\StructType\AdditionalGuestAmountType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\AdditionalGuestAmountType) {
            throw new \InvalidArgumentException(sprintf('The AdditionalGuestAmount property can only contain items of \StructType\AdditionalGuestAmountType, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->AdditionalGuestAmount[] = $item;
        return $this;
    }
    /**
     * Get AmountBeforeTax value
     * @return float|null
     */
    public function getAmountBeforeTax()
    {
        return $this->AmountBeforeTax;
    }
    /**
     * Set AmountBeforeTax value
     * @param float $amountBeforeTax
     * @return \StructType\AdditionalGuestAmounts
     */
    public function setAmountBeforeTax($amountBeforeTax = null)
    {
        $this->AmountBeforeTax = $amountBeforeTax;
        return $this;
    }
    /**
     * Get AmountAfterTax value
     * @return float|null
     */
    public function getAmountAfterTax()
    {
        return $this->AmountAfterTax;
    }
    /**
     * Set AmountAfterTax value
     * @param float $amountAfterTax
     * @return \StructType\AdditionalGuestAmounts
     */
    public function setAmountAfterTax($amountAfterTax = null)
    {
        $this->AmountAfterTax = $amountAfterTax;
        return $this;
    }
    /**
     * Get CurrencyCode value
     * @return string|null
     */
    public function getCurrencyCode()
    {
        return $this->CurrencyCode;
    }
    /**
     * Set CurrencyCode value
     * @param string $currencyCode
     * @return \StructType\AdditionalGuestAmounts
     */
    public function setCurrencyCode($currencyCode = null)
    {
        // validation for constraint: string
        if (!is_null($currencyCode) && !is_string($currencyCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($currencyCode)), __LINE__);
        }
        $this->CurrencyCode = $currencyCode;
        return $this;
    }
    /**
     * Get DecimalPlaces value
     * @return int|null
     */
    public function getDecimalPlaces()
    {
        return $this->DecimalPlaces;
    }
    /**
     * Set DecimalPlaces value
     * @param int $decimalPlaces
     * @return \StructType\AdditionalGuestAmounts
     */
    public function setDecimalPlaces($decimalPlaces = null)
    {
        // validation for constraint: int
        if (!is_null($decimalPlaces) && !is_numeric($decimalPlaces)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($decimalPlaces)), __LINE__);
        }
        $this->DecimalPlaces = $decimalPlaces;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\AdditionalGuestAmounts
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
