<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AdditionalCharges StructType
 * @subpackage Structs
 */
class AdditionalCharges extends AbstractStructBase
{
    /**
     * The AdditionalCharge
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\AdditionalChargeType[]
     */
    public $AdditionalCharge;
    /**
     * The AmountBeforeTax
     * @var float
     */
    public $AmountBeforeTax;
    /**
     * The AmountAfterTax
     * @var float
     */
    public $AmountAfterTax;
    /**
     * The CurrencyCode
     * @var string
     */
    public $CurrencyCode;
    /**
     * The DecimalPlaces
     * @var int
     */
    public $DecimalPlaces;
    /**
     * The OptionalChargesIndicator
     * @var string
     */
    public $OptionalChargesIndicator;
    /**
     * Constructor method for AdditionalCharges
     * @uses AdditionalCharges::setAdditionalCharge()
     * @uses AdditionalCharges::setAmountBeforeTax()
     * @uses AdditionalCharges::setAmountAfterTax()
     * @uses AdditionalCharges::setCurrencyCode()
     * @uses AdditionalCharges::setDecimalPlaces()
     * @uses AdditionalCharges::setOptionalChargesIndicator()
     * @param \StructType\AdditionalChargeType[] $additionalCharge
     * @param float $amountBeforeTax
     * @param float $amountAfterTax
     * @param string $currencyCode
     * @param int $decimalPlaces
     * @param string $optionalChargesIndicator
     */
    public function __construct(array $additionalCharge = array(), $amountBeforeTax = null, $amountAfterTax = null, $currencyCode = null, $decimalPlaces = null, $optionalChargesIndicator = null)
    {
        $this
            ->setAdditionalCharge($additionalCharge)
            ->setAmountBeforeTax($amountBeforeTax)
            ->setAmountAfterTax($amountAfterTax)
            ->setCurrencyCode($currencyCode)
            ->setDecimalPlaces($decimalPlaces)
            ->setOptionalChargesIndicator($optionalChargesIndicator);
    }
    /**
     * Get AdditionalCharge value
     * @return \StructType\AdditionalChargeType[]|null
     */
    public function getAdditionalCharge()
    {
        return $this->AdditionalCharge;
    }
    /**
     * Set AdditionalCharge value
     * @throws \InvalidArgumentException
     * @param \StructType\AdditionalChargeType[] $additionalCharge
     * @return \StructType\AdditionalCharges
     */
    public function setAdditionalCharge(array $additionalCharge = array())
    {
        foreach ($additionalCharge as $additionalChargesAdditionalChargeItem) {
            // validation for constraint: itemType
            if (!$additionalChargesAdditionalChargeItem instanceof \StructType\AdditionalChargeType) {
                throw new \InvalidArgumentException(sprintf('The AdditionalCharge property can only contain items of \StructType\AdditionalChargeType, "%s" given', is_object($additionalChargesAdditionalChargeItem) ? get_class($additionalChargesAdditionalChargeItem) : gettype($additionalChargesAdditionalChargeItem)), __LINE__);
            }
        }
        $this->AdditionalCharge = $additionalCharge;
        return $this;
    }
    /**
     * Add item to AdditionalCharge value
     * @throws \InvalidArgumentException
     * @param \StructType\AdditionalChargeType $item
     * @return \StructType\AdditionalCharges
     */
    public function addToAdditionalCharge(\StructType\AdditionalChargeType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\AdditionalChargeType) {
            throw new \InvalidArgumentException(sprintf('The AdditionalCharge property can only contain items of \StructType\AdditionalChargeType, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->AdditionalCharge[] = $item;
        return $this;
    }
    /**
     * Get AmountBeforeTax value
     * @return float|null
     */
    public function getAmountBeforeTax()
    {
        return $this->AmountBeforeTax;
    }
    /**
     * Set AmountBeforeTax value
     * @param float $amountBeforeTax
     * @return \StructType\AdditionalCharges
     */
    public function setAmountBeforeTax($amountBeforeTax = null)
    {
        $this->AmountBeforeTax = $amountBeforeTax;
        return $this;
    }
    /**
     * Get AmountAfterTax value
     * @return float|null
     */
    public function getAmountAfterTax()
    {
        return $this->AmountAfterTax;
    }
    /**
     * Set AmountAfterTax value
     * @param float $amountAfterTax
     * @return \StructType\AdditionalCharges
     */
    public function setAmountAfterTax($amountAfterTax = null)
    {
        $this->AmountAfterTax = $amountAfterTax;
        return $this;
    }
    /**
     * Get CurrencyCode value
     * @return string|null
     */
    public function getCurrencyCode()
    {
        return $this->CurrencyCode;
    }
    /**
     * Set CurrencyCode value
     * @param string $currencyCode
     * @return \StructType\AdditionalCharges
     */
    public function setCurrencyCode($currencyCode = null)
    {
        // validation for constraint: string
        if (!is_null($currencyCode) && !is_string($currencyCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($currencyCode)), __LINE__);
        }
        $this->CurrencyCode = $currencyCode;
        return $this;
    }
    /**
     * Get DecimalPlaces value
     * @return int|null
     */
    public function getDecimalPlaces()
    {
        return $this->DecimalPlaces;
    }
    /**
     * Set DecimalPlaces value
     * @param int $decimalPlaces
     * @return \StructType\AdditionalCharges
     */
    public function setDecimalPlaces($decimalPlaces = null)
    {
        // validation for constraint: int
        if (!is_null($decimalPlaces) && !is_numeric($decimalPlaces)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($decimalPlaces)), __LINE__);
        }
        $this->DecimalPlaces = $decimalPlaces;
        return $this;
    }
    /**
     * Get OptionalChargesIndicator value
     * @return string|null
     */
    public function getOptionalChargesIndicator()
    {
        return $this->OptionalChargesIndicator;
    }
    /**
     * Set OptionalChargesIndicator value
     * @param string $optionalChargesIndicator
     * @return \StructType\AdditionalCharges
     */
    public function setOptionalChargesIndicator($optionalChargesIndicator = null)
    {
        // validation for constraint: string
        if (!is_null($optionalChargesIndicator) && !is_string($optionalChargesIndicator)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($optionalChargesIndicator)), __LINE__);
        }
        $this->OptionalChargesIndicator = $optionalChargesIndicator;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\AdditionalCharges
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
