<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Unit ServiceType
 * @subpackage Services
 */
class Unit extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named UnitDescriptiveInfo
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\EVRN_UnitDescriptiveInfoRQ $eVRN_UnitDescriptiveInfoRQ
     * @return \StructType\EVRN_UnitDescriptiveInfoRS|bool
     */
    public function UnitDescriptiveInfo(\StructType\EVRN_UnitDescriptiveInfoRQ $eVRN_UnitDescriptiveInfoRQ)
    {
        try {
            $this->setResult(self::getSoapClient()->UnitDescriptiveInfo($eVRN_UnitDescriptiveInfoRQ));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named UnitSearch
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\EVRN_UnitSearchRQ $eVRN_UnitSearchRQ
     * @return \StructType\EVRN_UnitSearchRS|bool
     */
    public function UnitSearch(\StructType\EVRN_UnitSearchRQ $eVRN_UnitSearchRQ)
    {
        try {
            $this->setResult(self::getSoapClient()->UnitSearch($eVRN_UnitSearchRQ));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named UnitCalendarAvail
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\EVRN_UnitCalendarAvailRQ $eVRN_UnitCalendarAvailRQ
     * @return \StructType\EVRN_UnitCalendarAvailRS|bool
     */
    public function UnitCalendarAvail(\StructType\EVRN_UnitCalendarAvailRQ $eVRN_UnitCalendarAvailRQ)
    {
        try {
            $this->setResult(self::getSoapClient()->UnitCalendarAvail($eVRN_UnitCalendarAvailRQ));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named UnitStay
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\EVRN_UnitStayRQ $eVRN_UnitStayRQ
     * @return \StructType\EVRN_UnitStayRS|bool
     */
    public function UnitStay(\StructType\EVRN_UnitStayRQ $eVRN_UnitStayRQ)
    {
        try {
            $this->setResult(self::getSoapClient()->UnitStay($eVRN_UnitStayRQ));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named UnitRes
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\UnitResRequestType $eVRN_UnitResRQ
     * @return \StructType\UnitResResponseType|bool
     */
    public function UnitRes(\StructType\UnitResRequestType $eVRN_UnitResRQ)
    {
        try {
            $this->setResult(self::getSoapClient()->UnitRes($eVRN_UnitResRQ));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named UnitRead
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\EVRN_UnitReadRQ $eVRN_UnitReadRQ
     * @return \StructType\UnitResResponseType|bool
     */
    public function UnitRead(\StructType\EVRN_UnitReadRQ $eVRN_UnitReadRQ)
    {
        try {
            $this->setResult(self::getSoapClient()->UnitRead($eVRN_UnitReadRQ));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named UnitInquiry
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\EVRN_UnitInquiryRQ $eVRN_UnitInquiryRQ
     * @return \StructType\EVRN_UnitInquiryRS|bool
     */
    public function UnitInquiry(\StructType\EVRN_UnitInquiryRQ $eVRN_UnitInquiryRQ)
    {
        try {
            $this->setResult(self::getSoapClient()->UnitInquiry($eVRN_UnitInquiryRQ));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named UnitCalendarAvailBatch
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\EVRN_UnitCalendarAvailBatchRQ $eVRN_UnitCalendarAvailBatchRQ
     * @return \StructType\EVRN_UnitCalendarAvailBatchRSType|bool
     */
    public function UnitCalendarAvailBatch(\StructType\EVRN_UnitCalendarAvailBatchRQ $eVRN_UnitCalendarAvailBatchRQ)
    {
        try {
            $this->setResult(self::getSoapClient()->UnitCalendarAvailBatch($eVRN_UnitCalendarAvailBatchRQ));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named UnitHold
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\EVRN_UnitHoldRQ $eVRN_UnitHoldRQ
     * @return \StructType\EVRN_UnitHoldRS|bool
     */
    public function UnitHold(\StructType\EVRN_UnitHoldRQ $eVRN_UnitHoldRQ)
    {
        try {
            $this->setResult(self::getSoapClient()->UnitHold($eVRN_UnitHoldRQ));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named UnitCalendarAvailExtended
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\EVRN_UnitCalendarAvailRQ $eVRN_UnitCalendarAvailRQ
     * @return \StructType\EVRN_UnitCalendarAvailRS|bool
     */
    public function UnitCalendarAvailExtended(\StructType\EVRN_UnitCalendarAvailRQ $eVRN_UnitCalendarAvailRQ)
    {
        try {
            $this->setResult(self::getSoapClient()->UnitCalendarAvailExtended($eVRN_UnitCalendarAvailRQ));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\EVRN_UnitCalendarAvailBatchRSType|\StructType\EVRN_UnitCalendarAvailRS|\StructType\EVRN_UnitDescriptiveInfoRS|\StructType\EVRN_UnitHoldRS|\StructType\EVRN_UnitInquiryRS|\StructType\EVRN_UnitSearchRS|\StructType\EVRN_UnitStayRS|\StructType\UnitResResponseType
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
