<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfPaymentFormType ArrayType
 * @subpackage Arrays
 */
class ArrayOfPaymentFormType extends AbstractStructArrayBase
{
    /**
     * The AcceptedPayment
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\PaymentFormType[]
     */
    public $AcceptedPayment;
    /**
     * Constructor method for ArrayOfPaymentFormType
     * @uses ArrayOfPaymentFormType::setAcceptedPayment()
     * @param \StructType\PaymentFormType[] $acceptedPayment
     */
    public function __construct(array $acceptedPayment = array())
    {
        $this
            ->setAcceptedPayment($acceptedPayment);
    }
    /**
     * Get AcceptedPayment value
     * @return \StructType\PaymentFormType[]|null
     */
    public function getAcceptedPayment()
    {
        return $this->AcceptedPayment;
    }
    /**
     * Set AcceptedPayment value
     * @throws \InvalidArgumentException
     * @param \StructType\PaymentFormType[] $acceptedPayment
     * @return \ArrayType\ArrayOfPaymentFormType
     */
    public function setAcceptedPayment(array $acceptedPayment = array())
    {
        foreach ($acceptedPayment as $arrayOfPaymentFormTypeAcceptedPaymentItem) {
            // validation for constraint: itemType
            if (!$arrayOfPaymentFormTypeAcceptedPaymentItem instanceof \StructType\PaymentFormType) {
                throw new \InvalidArgumentException(sprintf('The AcceptedPayment property can only contain items of \StructType\PaymentFormType, "%s" given', is_object($arrayOfPaymentFormTypeAcceptedPaymentItem) ? get_class($arrayOfPaymentFormTypeAcceptedPaymentItem) : gettype($arrayOfPaymentFormTypeAcceptedPaymentItem)), __LINE__);
            }
        }
        $this->AcceptedPayment = $acceptedPayment;
        return $this;
    }
    /**
     * Add item to AcceptedPayment value
     * @throws \InvalidArgumentException
     * @param \StructType\PaymentFormType $item
     * @return \ArrayType\ArrayOfPaymentFormType
     */
    public function addToAcceptedPayment(\StructType\PaymentFormType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\PaymentFormType) {
            throw new \InvalidArgumentException(sprintf('The AcceptedPayment property can only contain items of \StructType\PaymentFormType, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->AcceptedPayment[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\PaymentFormType|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\PaymentFormType|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\PaymentFormType|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\PaymentFormType|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\PaymentFormType|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string AcceptedPayment
     */
    public function getAttributeName()
    {
        return 'AcceptedPayment';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \ArrayType\ArrayOfPaymentFormType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
