<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfBedCountType ArrayType
 * @subpackage Arrays
 */
class ArrayOfBedCountType extends AbstractStructArrayBase
{
    /**
     * The BedCount
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\BedCountType[]
     */
    public $BedCount;
    /**
     * Constructor method for ArrayOfBedCountType
     * @uses ArrayOfBedCountType::setBedCount()
     * @param \StructType\BedCountType[] $bedCount
     */
    public function __construct(array $bedCount = array())
    {
        $this
            ->setBedCount($bedCount);
    }
    /**
     * Get BedCount value
     * @return \StructType\BedCountType[]|null
     */
    public function getBedCount()
    {
        return $this->BedCount;
    }
    /**
     * Set BedCount value
     * @throws \InvalidArgumentException
     * @param \StructType\BedCountType[] $bedCount
     * @return \ArrayType\ArrayOfBedCountType
     */
    public function setBedCount(array $bedCount = array())
    {
        foreach ($bedCount as $arrayOfBedCountTypeBedCountItem) {
            // validation for constraint: itemType
            if (!$arrayOfBedCountTypeBedCountItem instanceof \StructType\BedCountType) {
                throw new \InvalidArgumentException(sprintf('The BedCount property can only contain items of \StructType\BedCountType, "%s" given', is_object($arrayOfBedCountTypeBedCountItem) ? get_class($arrayOfBedCountTypeBedCountItem) : gettype($arrayOfBedCountTypeBedCountItem)), __LINE__);
            }
        }
        $this->BedCount = $bedCount;
        return $this;
    }
    /**
     * Add item to BedCount value
     * @throws \InvalidArgumentException
     * @param \StructType\BedCountType $item
     * @return \ArrayType\ArrayOfBedCountType
     */
    public function addToBedCount(\StructType\BedCountType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\BedCountType) {
            throw new \InvalidArgumentException(sprintf('The BedCount property can only contain items of \StructType\BedCountType, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->BedCount[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\BedCountType|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\BedCountType|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\BedCountType|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\BedCountType|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\BedCountType|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string BedCount
     */
    public function getAttributeName()
    {
        return 'BedCount';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \ArrayType\ArrayOfBedCountType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
