<?php
/**
 * This file aims to show you how to use this generated package.
 * In addition, the goal is to show which methods are available and the fist needed parameter(s)
 * You have to use an associative array such as:
 * - the key must be a constant beginning with WSDL_ from AbstractSoapClientbase class each generated ServiceType class extends this class
 * - the value must be the corresponding key value (each option matches a {@link http://www.php.net/manual/en/soapclient.soapclient.php} option)
 * $options = array(
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_URL => 'main.wsdl',
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_TRACE => true,
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_LOGIN => 'you_secret_login',
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_PASSWORD => 'you_secret_password',
 * );
 * etc....
 */
require_once __DIR__ . '/vendor/autoload.php';
/**
 * Minimal options
 */
$options = array(
    \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_URL => 'main.wsdl',
    \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_CLASSMAP => ClassMap::get(),
);
/**
 * Samples for Unit ServiceType
 */
$unit = new \ServiceType\Unit($options);
/**
 * Sample call for UnitDescriptiveInfo operation/method
 */
if ($unit->UnitDescriptiveInfo(new \StructType\EVRN_UnitDescriptiveInfoRQ()) !== false) {
    print_r($unit->getResult());
} else {
    print_r($unit->getLastError());
}
/**
 * Sample call for UnitSearch operation/method
 */
if ($unit->UnitSearch(new \StructType\EVRN_UnitSearchRQ()) !== false) {
    print_r($unit->getResult());
} else {
    print_r($unit->getLastError());
}
/**
 * Sample call for UnitCalendarAvail operation/method
 */
if ($unit->UnitCalendarAvail(new \StructType\EVRN_UnitCalendarAvailRQ()) !== false) {
    print_r($unit->getResult());
} else {
    print_r($unit->getLastError());
}
/**
 * Sample call for UnitStay operation/method
 */
if ($unit->UnitStay(new \StructType\EVRN_UnitStayRQ()) !== false) {
    print_r($unit->getResult());
} else {
    print_r($unit->getLastError());
}
/**
 * Sample call for UnitRes operation/method
 */
if ($unit->UnitRes(new \StructType\UnitResRequestType()) !== false) {
    print_r($unit->getResult());
} else {
    print_r($unit->getLastError());
}
/**
 * Sample call for UnitRead operation/method
 */
if ($unit->UnitRead(new \StructType\EVRN_UnitReadRQ()) !== false) {
    print_r($unit->getResult());
} else {
    print_r($unit->getLastError());
}
/**
 * Sample call for UnitInquiry operation/method
 */
if ($unit->UnitInquiry(new \StructType\EVRN_UnitInquiryRQ()) !== false) {
    print_r($unit->getResult());
} else {
    print_r($unit->getLastError());
}
/**
 * Sample call for UnitCalendarAvailBatch operation/method
 */
if ($unit->UnitCalendarAvailBatch(new \StructType\EVRN_UnitCalendarAvailBatchRQ()) !== false) {
    print_r($unit->getResult());
} else {
    print_r($unit->getLastError());
}
/**
 * Sample call for UnitHold operation/method
 */
if ($unit->UnitHold(new \StructType\EVRN_UnitHoldRQ()) !== false) {
    print_r($unit->getResult());
} else {
    print_r($unit->getLastError());
}
/**
 * Sample call for UnitCalendarAvailExtended operation/method
 */
if ($unit->UnitCalendarAvailExtended(new \StructType\EVRN_UnitCalendarAvailRQ()) !== false) {
    print_r($unit->getResult());
} else {
    print_r($unit->getLastError());
}
/**
 * Samples for Campaign ServiceType
 */
$campaign = new \ServiceType\Campaign($options);
/**
 * Sample call for Campaign operation/method
 */
if ($campaign->Campaign(new \StructType\EVRN_CampaignRQ()) !== false) {
    print_r($campaign->getResult());
} else {
    print_r($campaign->getLastError());
}
/**
 * Samples for Property ServiceType
 */
$property = new \ServiceType\Property($options);
/**
 * Sample call for PropertyManager operation/method
 */
if ($property->PropertyManager(new \StructType\EVRN_PropertyManagerRQ()) !== false) {
    print_r($property->getResult());
} else {
    print_r($property->getLastError());
}
/**
 * Samples for Reservation ServiceType
 */
$reservation = new \ServiceType\Reservation($options);
/**
 * Sample call for ReservationCancel operation/method
 */
if ($reservation->ReservationCancel(new \StructType\EVRN_ReservationCancelRQ()) !== false) {
    print_r($reservation->getResult());
} else {
    print_r($reservation->getLastError());
}
/**
 * Sample call for ReservationUpdate operation/method
 */
if ($reservation->ReservationUpdate(new \StructType\EVRN_ReservationUpdateRQ()) !== false) {
    print_r($reservation->getResult());
} else {
    print_r($reservation->getLastError());
}
