<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for UnitValueMatchType StructType
 * @subpackage Structs
 */
class UnitValueMatchType extends BasicUnitInfoType
{
    /**
     * The RateRange
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\RateRange
     */
    public $RateRange;
    /**
     * The LastMinuteDiscountRange
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\LastMinuteDiscountRangeType
     */
    public $LastMinuteDiscountRange;
    /**
     * The MoreDataEchoToken
     * @var string
     */
    public $MoreDataEchoToken;
    /**
     * The SameCountryInd
     * @var bool
     */
    public $SameCountryInd;
    /**
     * The AvailabilityStatus
     * @var string
     */
    public $AvailabilityStatus;
    /**
     * Constructor method for UnitValueMatchType
     * @uses UnitValueMatchType::setRateRange()
     * @uses UnitValueMatchType::setLastMinuteDiscountRange()
     * @uses UnitValueMatchType::setMoreDataEchoToken()
     * @uses UnitValueMatchType::setSameCountryInd()
     * @uses UnitValueMatchType::setAvailabilityStatus()
     * @param \StructType\RateRange $rateRange
     * @param \StructType\LastMinuteDiscountRangeType $lastMinuteDiscountRange
     * @param string $moreDataEchoToken
     * @param bool $sameCountryInd
     * @param string $availabilityStatus
     */
    public function __construct(\StructType\RateRange $rateRange = null, \StructType\LastMinuteDiscountRangeType $lastMinuteDiscountRange = null, $moreDataEchoToken = null, $sameCountryInd = null, $availabilityStatus = null)
    {
        $this
            ->setRateRange($rateRange)
            ->setLastMinuteDiscountRange($lastMinuteDiscountRange)
            ->setMoreDataEchoToken($moreDataEchoToken)
            ->setSameCountryInd($sameCountryInd)
            ->setAvailabilityStatus($availabilityStatus);
    }
    /**
     * Get RateRange value
     * @return \StructType\RateRange|null
     */
    public function getRateRange()
    {
        return $this->RateRange;
    }
    /**
     * Set RateRange value
     * @param \StructType\RateRange $rateRange
     * @return \StructType\UnitValueMatchType
     */
    public function setRateRange(\StructType\RateRange $rateRange = null)
    {
        $this->RateRange = $rateRange;
        return $this;
    }
    /**
     * Get LastMinuteDiscountRange value
     * @return \StructType\LastMinuteDiscountRangeType|null
     */
    public function getLastMinuteDiscountRange()
    {
        return $this->LastMinuteDiscountRange;
    }
    /**
     * Set LastMinuteDiscountRange value
     * @param \StructType\LastMinuteDiscountRangeType $lastMinuteDiscountRange
     * @return \StructType\UnitValueMatchType
     */
    public function setLastMinuteDiscountRange(\StructType\LastMinuteDiscountRangeType $lastMinuteDiscountRange = null)
    {
        $this->LastMinuteDiscountRange = $lastMinuteDiscountRange;
        return $this;
    }
    /**
     * Get MoreDataEchoToken value
     * @return string|null
     */
    public function getMoreDataEchoToken()
    {
        return $this->MoreDataEchoToken;
    }
    /**
     * Set MoreDataEchoToken value
     * @param string $moreDataEchoToken
     * @return \StructType\UnitValueMatchType
     */
    public function setMoreDataEchoToken($moreDataEchoToken = null)
    {
        // validation for constraint: string
        if (!is_null($moreDataEchoToken) && !is_string($moreDataEchoToken)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($moreDataEchoToken)), __LINE__);
        }
        $this->MoreDataEchoToken = $moreDataEchoToken;
        return $this;
    }
    /**
     * Get SameCountryInd value
     * @return bool|null
     */
    public function getSameCountryInd()
    {
        return $this->SameCountryInd;
    }
    /**
     * Set SameCountryInd value
     * @param bool $sameCountryInd
     * @return \StructType\UnitValueMatchType
     */
    public function setSameCountryInd($sameCountryInd = null)
    {
        $this->SameCountryInd = $sameCountryInd;
        return $this;
    }
    /**
     * Get AvailabilityStatus value
     * @return string|null
     */
    public function getAvailabilityStatus()
    {
        return $this->AvailabilityStatus;
    }
    /**
     * Set AvailabilityStatus value
     * @uses \EnumType\RateIndicatorType::valueIsValid()
     * @uses \EnumType\RateIndicatorType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $availabilityStatus
     * @return \StructType\UnitValueMatchType
     */
    public function setAvailabilityStatus($availabilityStatus = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\RateIndicatorType::valueIsValid($availabilityStatus)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $availabilityStatus, implode(', ', \EnumType\RateIndicatorType::getValidValues())), __LINE__);
        }
        $this->AvailabilityStatus = $availabilityStatus;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\UnitValueMatchType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
