<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for UnitReviewType StructType
 * @subpackage Structs
 */
class UnitReviewType extends AbstractStructBase
{
    /**
     * The ReviewScore
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\ReviewScoreType[]
     */
    public $ReviewScore;
    /**
     * The ReviewComment
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\ReviewCommentType[]
     */
    public $ReviewComment;
    /**
     * The ManagerResponse
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\ManagerResponseType[]
     */
    public $ManagerResponse;
    /**
     * The Title
     * @var string
     */
    public $Title;
    /**
     * The ReviewedDate
     * @var string
     */
    public $ReviewedDate;
    /**
     * The LastUpdated
     * @var string
     */
    public $LastUpdated;
    /**
     * The ReviewerID
     * @var string
     */
    public $ReviewerID;
    /**
     * The ReviewerName
     * @var string
     */
    public $ReviewerName;
    /**
     * The ReviewerCity
     * @var string
     */
    public $ReviewerCity;
    /**
     * The ReviewerState
     * @var string
     */
    public $ReviewerState;
    /**
     * The ReviewerCountry
     * @var string
     */
    public $ReviewerCountry;
    /**
     * The ReviewerEmail
     * @var string
     */
    public $ReviewerEmail;
    /**
     * The CheckIn
     * @var string
     */
    public $CheckIn;
    /**
     * The CheckOut
     * @var string
     */
    public $CheckOut;
    /**
     * The PropertyManagerRejected
     * @var bool
     */
    public $PropertyManagerRejected;
    /**
     * The ReservationNumber
     * @var string
     */
    public $ReservationNumber;
    /**
     * Constructor method for UnitReviewType
     * @uses UnitReviewType::setReviewScore()
     * @uses UnitReviewType::setReviewComment()
     * @uses UnitReviewType::setManagerResponse()
     * @uses UnitReviewType::setTitle()
     * @uses UnitReviewType::setReviewedDate()
     * @uses UnitReviewType::setLastUpdated()
     * @uses UnitReviewType::setReviewerID()
     * @uses UnitReviewType::setReviewerName()
     * @uses UnitReviewType::setReviewerCity()
     * @uses UnitReviewType::setReviewerState()
     * @uses UnitReviewType::setReviewerCountry()
     * @uses UnitReviewType::setReviewerEmail()
     * @uses UnitReviewType::setCheckIn()
     * @uses UnitReviewType::setCheckOut()
     * @uses UnitReviewType::setPropertyManagerRejected()
     * @uses UnitReviewType::setReservationNumber()
     * @param \StructType\ReviewScoreType[] $reviewScore
     * @param \StructType\ReviewCommentType[] $reviewComment
     * @param \StructType\ManagerResponseType[] $managerResponse
     * @param string $title
     * @param string $reviewedDate
     * @param string $lastUpdated
     * @param string $reviewerID
     * @param string $reviewerName
     * @param string $reviewerCity
     * @param string $reviewerState
     * @param string $reviewerCountry
     * @param string $reviewerEmail
     * @param string $checkIn
     * @param string $checkOut
     * @param bool $propertyManagerRejected
     * @param string $reservationNumber
     */
    public function __construct(array $reviewScore = array(), array $reviewComment = array(), array $managerResponse = array(), $title = null, $reviewedDate = null, $lastUpdated = null, $reviewerID = null, $reviewerName = null, $reviewerCity = null, $reviewerState = null, $reviewerCountry = null, $reviewerEmail = null, $checkIn = null, $checkOut = null, $propertyManagerRejected = null, $reservationNumber = null)
    {
        $this
            ->setReviewScore($reviewScore)
            ->setReviewComment($reviewComment)
            ->setManagerResponse($managerResponse)
            ->setTitle($title)
            ->setReviewedDate($reviewedDate)
            ->setLastUpdated($lastUpdated)
            ->setReviewerID($reviewerID)
            ->setReviewerName($reviewerName)
            ->setReviewerCity($reviewerCity)
            ->setReviewerState($reviewerState)
            ->setReviewerCountry($reviewerCountry)
            ->setReviewerEmail($reviewerEmail)
            ->setCheckIn($checkIn)
            ->setCheckOut($checkOut)
            ->setPropertyManagerRejected($propertyManagerRejected)
            ->setReservationNumber($reservationNumber);
    }
    /**
     * Get ReviewScore value
     * @return \StructType\ReviewScoreType[]|null
     */
    public function getReviewScore()
    {
        return $this->ReviewScore;
    }
    /**
     * Set ReviewScore value
     * @throws \InvalidArgumentException
     * @param \StructType\ReviewScoreType[] $reviewScore
     * @return \StructType\UnitReviewType
     */
    public function setReviewScore(array $reviewScore = array())
    {
        foreach ($reviewScore as $unitReviewTypeReviewScoreItem) {
            // validation for constraint: itemType
            if (!$unitReviewTypeReviewScoreItem instanceof \StructType\ReviewScoreType) {
                throw new \InvalidArgumentException(sprintf('The ReviewScore property can only contain items of \StructType\ReviewScoreType, "%s" given', is_object($unitReviewTypeReviewScoreItem) ? get_class($unitReviewTypeReviewScoreItem) : gettype($unitReviewTypeReviewScoreItem)), __LINE__);
            }
        }
        $this->ReviewScore = $reviewScore;
        return $this;
    }
    /**
     * Add item to ReviewScore value
     * @throws \InvalidArgumentException
     * @param \StructType\ReviewScoreType $item
     * @return \StructType\UnitReviewType
     */
    public function addToReviewScore(\StructType\ReviewScoreType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\ReviewScoreType) {
            throw new \InvalidArgumentException(sprintf('The ReviewScore property can only contain items of \StructType\ReviewScoreType, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->ReviewScore[] = $item;
        return $this;
    }
    /**
     * Get ReviewComment value
     * @return \StructType\ReviewCommentType[]|null
     */
    public function getReviewComment()
    {
        return $this->ReviewComment;
    }
    /**
     * Set ReviewComment value
     * @throws \InvalidArgumentException
     * @param \StructType\ReviewCommentType[] $reviewComment
     * @return \StructType\UnitReviewType
     */
    public function setReviewComment(array $reviewComment = array())
    {
        foreach ($reviewComment as $unitReviewTypeReviewCommentItem) {
            // validation for constraint: itemType
            if (!$unitReviewTypeReviewCommentItem instanceof \StructType\ReviewCommentType) {
                throw new \InvalidArgumentException(sprintf('The ReviewComment property can only contain items of \StructType\ReviewCommentType, "%s" given', is_object($unitReviewTypeReviewCommentItem) ? get_class($unitReviewTypeReviewCommentItem) : gettype($unitReviewTypeReviewCommentItem)), __LINE__);
            }
        }
        $this->ReviewComment = $reviewComment;
        return $this;
    }
    /**
     * Add item to ReviewComment value
     * @throws \InvalidArgumentException
     * @param \StructType\ReviewCommentType $item
     * @return \StructType\UnitReviewType
     */
    public function addToReviewComment(\StructType\ReviewCommentType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\ReviewCommentType) {
            throw new \InvalidArgumentException(sprintf('The ReviewComment property can only contain items of \StructType\ReviewCommentType, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->ReviewComment[] = $item;
        return $this;
    }
    /**
     * Get ManagerResponse value
     * @return \StructType\ManagerResponseType[]|null
     */
    public function getManagerResponse()
    {
        return $this->ManagerResponse;
    }
    /**
     * Set ManagerResponse value
     * @throws \InvalidArgumentException
     * @param \StructType\ManagerResponseType[] $managerResponse
     * @return \StructType\UnitReviewType
     */
    public function setManagerResponse(array $managerResponse = array())
    {
        foreach ($managerResponse as $unitReviewTypeManagerResponseItem) {
            // validation for constraint: itemType
            if (!$unitReviewTypeManagerResponseItem instanceof \StructType\ManagerResponseType) {
                throw new \InvalidArgumentException(sprintf('The ManagerResponse property can only contain items of \StructType\ManagerResponseType, "%s" given', is_object($unitReviewTypeManagerResponseItem) ? get_class($unitReviewTypeManagerResponseItem) : gettype($unitReviewTypeManagerResponseItem)), __LINE__);
            }
        }
        $this->ManagerResponse = $managerResponse;
        return $this;
    }
    /**
     * Add item to ManagerResponse value
     * @throws \InvalidArgumentException
     * @param \StructType\ManagerResponseType $item
     * @return \StructType\UnitReviewType
     */
    public function addToManagerResponse(\StructType\ManagerResponseType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\ManagerResponseType) {
            throw new \InvalidArgumentException(sprintf('The ManagerResponse property can only contain items of \StructType\ManagerResponseType, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->ManagerResponse[] = $item;
        return $this;
    }
    /**
     * Get Title value
     * @return string|null
     */
    public function getTitle()
    {
        return $this->Title;
    }
    /**
     * Set Title value
     * @param string $title
     * @return \StructType\UnitReviewType
     */
    public function setTitle($title = null)
    {
        // validation for constraint: string
        if (!is_null($title) && !is_string($title)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($title)), __LINE__);
        }
        $this->Title = $title;
        return $this;
    }
    /**
     * Get ReviewedDate value
     * @return string|null
     */
    public function getReviewedDate()
    {
        return $this->ReviewedDate;
    }
    /**
     * Set ReviewedDate value
     * @param string $reviewedDate
     * @return \StructType\UnitReviewType
     */
    public function setReviewedDate($reviewedDate = null)
    {
        // validation for constraint: string
        if (!is_null($reviewedDate) && !is_string($reviewedDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($reviewedDate)), __LINE__);
        }
        $this->ReviewedDate = $reviewedDate;
        return $this;
    }
    /**
     * Get LastUpdated value
     * @return string|null
     */
    public function getLastUpdated()
    {
        return $this->LastUpdated;
    }
    /**
     * Set LastUpdated value
     * @param string $lastUpdated
     * @return \StructType\UnitReviewType
     */
    public function setLastUpdated($lastUpdated = null)
    {
        // validation for constraint: string
        if (!is_null($lastUpdated) && !is_string($lastUpdated)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($lastUpdated)), __LINE__);
        }
        $this->LastUpdated = $lastUpdated;
        return $this;
    }
    /**
     * Get ReviewerID value
     * @return string|null
     */
    public function getReviewerID()
    {
        return $this->ReviewerID;
    }
    /**
     * Set ReviewerID value
     * @param string $reviewerID
     * @return \StructType\UnitReviewType
     */
    public function setReviewerID($reviewerID = null)
    {
        // validation for constraint: string
        if (!is_null($reviewerID) && !is_string($reviewerID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($reviewerID)), __LINE__);
        }
        $this->ReviewerID = $reviewerID;
        return $this;
    }
    /**
     * Get ReviewerName value
     * @return string|null
     */
    public function getReviewerName()
    {
        return $this->ReviewerName;
    }
    /**
     * Set ReviewerName value
     * @param string $reviewerName
     * @return \StructType\UnitReviewType
     */
    public function setReviewerName($reviewerName = null)
    {
        // validation for constraint: string
        if (!is_null($reviewerName) && !is_string($reviewerName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($reviewerName)), __LINE__);
        }
        $this->ReviewerName = $reviewerName;
        return $this;
    }
    /**
     * Get ReviewerCity value
     * @return string|null
     */
    public function getReviewerCity()
    {
        return $this->ReviewerCity;
    }
    /**
     * Set ReviewerCity value
     * @param string $reviewerCity
     * @return \StructType\UnitReviewType
     */
    public function setReviewerCity($reviewerCity = null)
    {
        // validation for constraint: string
        if (!is_null($reviewerCity) && !is_string($reviewerCity)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($reviewerCity)), __LINE__);
        }
        $this->ReviewerCity = $reviewerCity;
        return $this;
    }
    /**
     * Get ReviewerState value
     * @return string|null
     */
    public function getReviewerState()
    {
        return $this->ReviewerState;
    }
    /**
     * Set ReviewerState value
     * @param string $reviewerState
     * @return \StructType\UnitReviewType
     */
    public function setReviewerState($reviewerState = null)
    {
        // validation for constraint: string
        if (!is_null($reviewerState) && !is_string($reviewerState)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($reviewerState)), __LINE__);
        }
        $this->ReviewerState = $reviewerState;
        return $this;
    }
    /**
     * Get ReviewerCountry value
     * @return string|null
     */
    public function getReviewerCountry()
    {
        return $this->ReviewerCountry;
    }
    /**
     * Set ReviewerCountry value
     * @param string $reviewerCountry
     * @return \StructType\UnitReviewType
     */
    public function setReviewerCountry($reviewerCountry = null)
    {
        // validation for constraint: string
        if (!is_null($reviewerCountry) && !is_string($reviewerCountry)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($reviewerCountry)), __LINE__);
        }
        $this->ReviewerCountry = $reviewerCountry;
        return $this;
    }
    /**
     * Get ReviewerEmail value
     * @return string|null
     */
    public function getReviewerEmail()
    {
        return $this->ReviewerEmail;
    }
    /**
     * Set ReviewerEmail value
     * @param string $reviewerEmail
     * @return \StructType\UnitReviewType
     */
    public function setReviewerEmail($reviewerEmail = null)
    {
        // validation for constraint: string
        if (!is_null($reviewerEmail) && !is_string($reviewerEmail)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($reviewerEmail)), __LINE__);
        }
        $this->ReviewerEmail = $reviewerEmail;
        return $this;
    }
    /**
     * Get CheckIn value
     * @return string|null
     */
    public function getCheckIn()
    {
        return $this->CheckIn;
    }
    /**
     * Set CheckIn value
     * @param string $checkIn
     * @return \StructType\UnitReviewType
     */
    public function setCheckIn($checkIn = null)
    {
        // validation for constraint: string
        if (!is_null($checkIn) && !is_string($checkIn)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($checkIn)), __LINE__);
        }
        $this->CheckIn = $checkIn;
        return $this;
    }
    /**
     * Get CheckOut value
     * @return string|null
     */
    public function getCheckOut()
    {
        return $this->CheckOut;
    }
    /**
     * Set CheckOut value
     * @param string $checkOut
     * @return \StructType\UnitReviewType
     */
    public function setCheckOut($checkOut = null)
    {
        // validation for constraint: string
        if (!is_null($checkOut) && !is_string($checkOut)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($checkOut)), __LINE__);
        }
        $this->CheckOut = $checkOut;
        return $this;
    }
    /**
     * Get PropertyManagerRejected value
     * @return bool|null
     */
    public function getPropertyManagerRejected()
    {
        return $this->PropertyManagerRejected;
    }
    /**
     * Set PropertyManagerRejected value
     * @param bool $propertyManagerRejected
     * @return \StructType\UnitReviewType
     */
    public function setPropertyManagerRejected($propertyManagerRejected = null)
    {
        $this->PropertyManagerRejected = $propertyManagerRejected;
        return $this;
    }
    /**
     * Get ReservationNumber value
     * @return string|null
     */
    public function getReservationNumber()
    {
        return $this->ReservationNumber;
    }
    /**
     * Set ReservationNumber value
     * @param string $reservationNumber
     * @return \StructType\UnitReviewType
     */
    public function setReservationNumber($reservationNumber = null)
    {
        // validation for constraint: string
        if (!is_null($reservationNumber) && !is_string($reservationNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($reservationNumber)), __LINE__);
        }
        $this->ReservationNumber = $reservationNumber;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\UnitReviewType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
