<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for UnitHolds StructType
 * @subpackage Structs
 */
class UnitHolds extends AbstractStructBase
{
    /**
     * The UnitHold
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\UnitHolds[]
     */
    public $UnitHold;
    /**
     * The UnitCode
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $UnitCode;
    /**
     * The FirstName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $FirstName;
    /**
     * The LastName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $LastName;
    /**
     * The Notes
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Notes;
    /**
     * The Email
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Email;
    /**
     * The PhoneNumber
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $PhoneNumber;
    /**
     * The CreateDateTime
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $CreateDateTime;
    /**
     * The Timespan
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\DateTimeSpanType
     */
    public $Timespan;
    /**
     * The ID
     * @var int
     */
    public $ID;
    /**
     * The Type
     * @var string
     */
    public $Type;
    /**
     * The Number
     * @var string
     */
    public $Number;
    /**
     * Constructor method for UnitHolds
     * @uses UnitHolds::setUnitHold()
     * @uses UnitHolds::setUnitCode()
     * @uses UnitHolds::setFirstName()
     * @uses UnitHolds::setLastName()
     * @uses UnitHolds::setNotes()
     * @uses UnitHolds::setEmail()
     * @uses UnitHolds::setPhoneNumber()
     * @uses UnitHolds::setCreateDateTime()
     * @uses UnitHolds::setTimespan()
     * @uses UnitHolds::setID()
     * @uses UnitHolds::setType()
     * @uses UnitHolds::setNumber()
     * @param \StructType\UnitHolds[] $unitHold
     * @param string $unitCode
     * @param string $firstName
     * @param string $lastName
     * @param string $notes
     * @param string $email
     * @param string $phoneNumber
     * @param string $createDateTime
     * @param \StructType\DateTimeSpanType $timespan
     * @param int $iD
     * @param string $type
     * @param string $number
     */
    public function __construct(array $unitHold = array(), $unitCode = null, $firstName = null, $lastName = null, $notes = null, $email = null, $phoneNumber = null, $createDateTime = null, \StructType\DateTimeSpanType $timespan = null, $iD = null, $type = null, $number = null)
    {
        $this
            ->setUnitHold($unitHold)
            ->setUnitCode($unitCode)
            ->setFirstName($firstName)
            ->setLastName($lastName)
            ->setNotes($notes)
            ->setEmail($email)
            ->setPhoneNumber($phoneNumber)
            ->setCreateDateTime($createDateTime)
            ->setTimespan($timespan)
            ->setID($iD)
            ->setType($type)
            ->setNumber($number);
    }
    /**
     * Get UnitHold value
     * @return \StructType\UnitHolds[]|null
     */
    public function getUnitHold()
    {
        return $this->UnitHold;
    }
    /**
     * Set UnitHold value
     * @throws \InvalidArgumentException
     * @param \StructType\UnitHolds[] $unitHold
     * @return \StructType\UnitHolds
     */
    public function setUnitHold(array $unitHold = array())
    {
        foreach ($unitHold as $unitHoldsUnitHoldItem) {
            // validation for constraint: itemType
            if (!$unitHoldsUnitHoldItem instanceof \StructType\UnitHolds) {
                throw new \InvalidArgumentException(sprintf('The UnitHold property can only contain items of \StructType\UnitHolds, "%s" given', is_object($unitHoldsUnitHoldItem) ? get_class($unitHoldsUnitHoldItem) : gettype($unitHoldsUnitHoldItem)), __LINE__);
            }
        }
        $this->UnitHold = $unitHold;
        return $this;
    }
    /**
     * Add item to UnitHold value
     * @throws \InvalidArgumentException
     * @param \StructType\UnitHolds $item
     * @return \StructType\UnitHolds
     */
    public function addToUnitHold(\StructType\UnitHolds $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\UnitHolds) {
            throw new \InvalidArgumentException(sprintf('The UnitHold property can only contain items of \StructType\UnitHolds, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->UnitHold[] = $item;
        return $this;
    }
    /**
     * Get UnitCode value
     * @return string|null
     */
    public function getUnitCode()
    {
        return $this->UnitCode;
    }
    /**
     * Set UnitCode value
     * @param string $unitCode
     * @return \StructType\UnitHolds
     */
    public function setUnitCode($unitCode = null)
    {
        // validation for constraint: string
        if (!is_null($unitCode) && !is_string($unitCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($unitCode)), __LINE__);
        }
        $this->UnitCode = $unitCode;
        return $this;
    }
    /**
     * Get FirstName value
     * @return string|null
     */
    public function getFirstName()
    {
        return $this->FirstName;
    }
    /**
     * Set FirstName value
     * @param string $firstName
     * @return \StructType\UnitHolds
     */
    public function setFirstName($firstName = null)
    {
        // validation for constraint: string
        if (!is_null($firstName) && !is_string($firstName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($firstName)), __LINE__);
        }
        $this->FirstName = $firstName;
        return $this;
    }
    /**
     * Get LastName value
     * @return string|null
     */
    public function getLastName()
    {
        return $this->LastName;
    }
    /**
     * Set LastName value
     * @param string $lastName
     * @return \StructType\UnitHolds
     */
    public function setLastName($lastName = null)
    {
        // validation for constraint: string
        if (!is_null($lastName) && !is_string($lastName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($lastName)), __LINE__);
        }
        $this->LastName = $lastName;
        return $this;
    }
    /**
     * Get Notes value
     * @return string|null
     */
    public function getNotes()
    {
        return $this->Notes;
    }
    /**
     * Set Notes value
     * @param string $notes
     * @return \StructType\UnitHolds
     */
    public function setNotes($notes = null)
    {
        // validation for constraint: string
        if (!is_null($notes) && !is_string($notes)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($notes)), __LINE__);
        }
        $this->Notes = $notes;
        return $this;
    }
    /**
     * Get Email value
     * @return string|null
     */
    public function getEmail()
    {
        return $this->Email;
    }
    /**
     * Set Email value
     * @param string $email
     * @return \StructType\UnitHolds
     */
    public function setEmail($email = null)
    {
        // validation for constraint: string
        if (!is_null($email) && !is_string($email)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($email)), __LINE__);
        }
        $this->Email = $email;
        return $this;
    }
    /**
     * Get PhoneNumber value
     * @return string|null
     */
    public function getPhoneNumber()
    {
        return $this->PhoneNumber;
    }
    /**
     * Set PhoneNumber value
     * @param string $phoneNumber
     * @return \StructType\UnitHolds
     */
    public function setPhoneNumber($phoneNumber = null)
    {
        // validation for constraint: string
        if (!is_null($phoneNumber) && !is_string($phoneNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($phoneNumber)), __LINE__);
        }
        $this->PhoneNumber = $phoneNumber;
        return $this;
    }
    /**
     * Get CreateDateTime value
     * @return string|null
     */
    public function getCreateDateTime()
    {
        return $this->CreateDateTime;
    }
    /**
     * Set CreateDateTime value
     * @param string $createDateTime
     * @return \StructType\UnitHolds
     */
    public function setCreateDateTime($createDateTime = null)
    {
        // validation for constraint: string
        if (!is_null($createDateTime) && !is_string($createDateTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($createDateTime)), __LINE__);
        }
        $this->CreateDateTime = $createDateTime;
        return $this;
    }
    /**
     * Get Timespan value
     * @return \StructType\DateTimeSpanType|null
     */
    public function getTimespan()
    {
        return $this->Timespan;
    }
    /**
     * Set Timespan value
     * @param \StructType\DateTimeSpanType $timespan
     * @return \StructType\UnitHolds
     */
    public function setTimespan(\StructType\DateTimeSpanType $timespan = null)
    {
        $this->Timespan = $timespan;
        return $this;
    }
    /**
     * Get ID value
     * @return int|null
     */
    public function getID()
    {
        return $this->ID;
    }
    /**
     * Set ID value
     * @param int $iD
     * @return \StructType\UnitHolds
     */
    public function setID($iD = null)
    {
        // validation for constraint: int
        if (!is_null($iD) && !is_numeric($iD)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($iD)), __LINE__);
        }
        $this->ID = $iD;
        return $this;
    }
    /**
     * Get Type value
     * @return string|null
     */
    public function getType()
    {
        return $this->Type;
    }
    /**
     * Set Type value
     * @param string $type
     * @return \StructType\UnitHolds
     */
    public function setType($type = null)
    {
        // validation for constraint: string
        if (!is_null($type) && !is_string($type)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($type)), __LINE__);
        }
        $this->Type = $type;
        return $this;
    }
    /**
     * Get Number value
     * @return string|null
     */
    public function getNumber()
    {
        return $this->Number;
    }
    /**
     * Set Number value
     * @param string $number
     * @return \StructType\UnitHolds
     */
    public function setNumber($number = null)
    {
        // validation for constraint: string
        if (!is_null($number) && !is_string($number)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($number)), __LINE__);
        }
        $this->Number = $number;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\UnitHolds
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
