<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for UnitDescriptiveContents StructType
 * @subpackage Structs
 */
class UnitDescriptiveContents extends AbstractStructBase
{
    /**
     * The UnitDescriptiveContent
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\UnitDescriptiveContentType[]
     */
    public $UnitDescriptiveContent;
    /**
     * The CachedData
     * @var bool
     */
    public $CachedData;
    /**
     * Constructor method for UnitDescriptiveContents
     * @uses UnitDescriptiveContents::setUnitDescriptiveContent()
     * @uses UnitDescriptiveContents::setCachedData()
     * @param \StructType\UnitDescriptiveContentType[] $unitDescriptiveContent
     * @param bool $cachedData
     */
    public function __construct(array $unitDescriptiveContent = array(), $cachedData = null)
    {
        $this
            ->setUnitDescriptiveContent($unitDescriptiveContent)
            ->setCachedData($cachedData);
    }
    /**
     * Get UnitDescriptiveContent value
     * @return \StructType\UnitDescriptiveContentType[]|null
     */
    public function getUnitDescriptiveContent()
    {
        return $this->UnitDescriptiveContent;
    }
    /**
     * Set UnitDescriptiveContent value
     * @throws \InvalidArgumentException
     * @param \StructType\UnitDescriptiveContentType[] $unitDescriptiveContent
     * @return \StructType\UnitDescriptiveContents
     */
    public function setUnitDescriptiveContent(array $unitDescriptiveContent = array())
    {
        foreach ($unitDescriptiveContent as $unitDescriptiveContentsUnitDescriptiveContentItem) {
            // validation for constraint: itemType
            if (!$unitDescriptiveContentsUnitDescriptiveContentItem instanceof \StructType\UnitDescriptiveContentType) {
                throw new \InvalidArgumentException(sprintf('The UnitDescriptiveContent property can only contain items of \StructType\UnitDescriptiveContentType, "%s" given', is_object($unitDescriptiveContentsUnitDescriptiveContentItem) ? get_class($unitDescriptiveContentsUnitDescriptiveContentItem) : gettype($unitDescriptiveContentsUnitDescriptiveContentItem)), __LINE__);
            }
        }
        $this->UnitDescriptiveContent = $unitDescriptiveContent;
        return $this;
    }
    /**
     * Add item to UnitDescriptiveContent value
     * @throws \InvalidArgumentException
     * @param \StructType\UnitDescriptiveContentType $item
     * @return \StructType\UnitDescriptiveContents
     */
    public function addToUnitDescriptiveContent(\StructType\UnitDescriptiveContentType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\UnitDescriptiveContentType) {
            throw new \InvalidArgumentException(sprintf('The UnitDescriptiveContent property can only contain items of \StructType\UnitDescriptiveContentType, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->UnitDescriptiveContent[] = $item;
        return $this;
    }
    /**
     * Get CachedData value
     * @return bool|null
     */
    public function getCachedData()
    {
        return $this->CachedData;
    }
    /**
     * Set CachedData value
     * @param bool $cachedData
     * @return \StructType\UnitDescriptiveContents
     */
    public function setCachedData($cachedData = null)
    {
        $this->CachedData = $cachedData;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\UnitDescriptiveContents
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
