<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for UnitCalendarAvailType StructType
 * @subpackage Structs
 */
class UnitCalendarAvailType extends AbstractStructBase
{
    /**
     * The UnitCalendarAvailSegment
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\UnitCalendarAvailSegmentType[]
     */
    public $UnitCalendarAvailSegment;
    /**
     * The PropertyManagerCode
     * @var string
     */
    public $PropertyManagerCode;
    /**
     * The UnitCode
     * @var string
     */
    public $UnitCode;
    /**
     * The UnitName
     * @var string
     */
    public $UnitName;
    /**
     * The InfoSource
     * @var string
     */
    public $InfoSource;
    /**
     * The InternalUnitCode
     * @var string
     */
    public $InternalUnitCode;
    /**
     * The UnitHeadline
     * @var string
     */
    public $UnitHeadline;
    /**
     * The PropertyURL
     * @var string
     */
    public $PropertyURL;
    /**
     * The LastUpdated
     * @var string
     */
    public $LastUpdated;
    /**
     * Constructor method for UnitCalendarAvailType
     * @uses UnitCalendarAvailType::setUnitCalendarAvailSegment()
     * @uses UnitCalendarAvailType::setPropertyManagerCode()
     * @uses UnitCalendarAvailType::setUnitCode()
     * @uses UnitCalendarAvailType::setUnitName()
     * @uses UnitCalendarAvailType::setInfoSource()
     * @uses UnitCalendarAvailType::setInternalUnitCode()
     * @uses UnitCalendarAvailType::setUnitHeadline()
     * @uses UnitCalendarAvailType::setPropertyURL()
     * @uses UnitCalendarAvailType::setLastUpdated()
     * @param \StructType\UnitCalendarAvailSegmentType[] $unitCalendarAvailSegment
     * @param string $propertyManagerCode
     * @param string $unitCode
     * @param string $unitName
     * @param string $infoSource
     * @param string $internalUnitCode
     * @param string $unitHeadline
     * @param string $propertyURL
     * @param string $lastUpdated
     */
    public function __construct(array $unitCalendarAvailSegment = array(), $propertyManagerCode = null, $unitCode = null, $unitName = null, $infoSource = null, $internalUnitCode = null, $unitHeadline = null, $propertyURL = null, $lastUpdated = null)
    {
        $this
            ->setUnitCalendarAvailSegment($unitCalendarAvailSegment)
            ->setPropertyManagerCode($propertyManagerCode)
            ->setUnitCode($unitCode)
            ->setUnitName($unitName)
            ->setInfoSource($infoSource)
            ->setInternalUnitCode($internalUnitCode)
            ->setUnitHeadline($unitHeadline)
            ->setPropertyURL($propertyURL)
            ->setLastUpdated($lastUpdated);
    }
    /**
     * Get UnitCalendarAvailSegment value
     * @return \StructType\UnitCalendarAvailSegmentType[]|null
     */
    public function getUnitCalendarAvailSegment()
    {
        return $this->UnitCalendarAvailSegment;
    }
    /**
     * Set UnitCalendarAvailSegment value
     * @throws \InvalidArgumentException
     * @param \StructType\UnitCalendarAvailSegmentType[] $unitCalendarAvailSegment
     * @return \StructType\UnitCalendarAvailType
     */
    public function setUnitCalendarAvailSegment(array $unitCalendarAvailSegment = array())
    {
        foreach ($unitCalendarAvailSegment as $unitCalendarAvailTypeUnitCalendarAvailSegmentItem) {
            // validation for constraint: itemType
            if (!$unitCalendarAvailTypeUnitCalendarAvailSegmentItem instanceof \StructType\UnitCalendarAvailSegmentType) {
                throw new \InvalidArgumentException(sprintf('The UnitCalendarAvailSegment property can only contain items of \StructType\UnitCalendarAvailSegmentType, "%s" given', is_object($unitCalendarAvailTypeUnitCalendarAvailSegmentItem) ? get_class($unitCalendarAvailTypeUnitCalendarAvailSegmentItem) : gettype($unitCalendarAvailTypeUnitCalendarAvailSegmentItem)), __LINE__);
            }
        }
        $this->UnitCalendarAvailSegment = $unitCalendarAvailSegment;
        return $this;
    }
    /**
     * Add item to UnitCalendarAvailSegment value
     * @throws \InvalidArgumentException
     * @param \StructType\UnitCalendarAvailSegmentType $item
     * @return \StructType\UnitCalendarAvailType
     */
    public function addToUnitCalendarAvailSegment(\StructType\UnitCalendarAvailSegmentType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\UnitCalendarAvailSegmentType) {
            throw new \InvalidArgumentException(sprintf('The UnitCalendarAvailSegment property can only contain items of \StructType\UnitCalendarAvailSegmentType, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->UnitCalendarAvailSegment[] = $item;
        return $this;
    }
    /**
     * Get PropertyManagerCode value
     * @return string|null
     */
    public function getPropertyManagerCode()
    {
        return $this->PropertyManagerCode;
    }
    /**
     * Set PropertyManagerCode value
     * @param string $propertyManagerCode
     * @return \StructType\UnitCalendarAvailType
     */
    public function setPropertyManagerCode($propertyManagerCode = null)
    {
        // validation for constraint: string
        if (!is_null($propertyManagerCode) && !is_string($propertyManagerCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($propertyManagerCode)), __LINE__);
        }
        $this->PropertyManagerCode = $propertyManagerCode;
        return $this;
    }
    /**
     * Get UnitCode value
     * @return string|null
     */
    public function getUnitCode()
    {
        return $this->UnitCode;
    }
    /**
     * Set UnitCode value
     * @param string $unitCode
     * @return \StructType\UnitCalendarAvailType
     */
    public function setUnitCode($unitCode = null)
    {
        // validation for constraint: string
        if (!is_null($unitCode) && !is_string($unitCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($unitCode)), __LINE__);
        }
        $this->UnitCode = $unitCode;
        return $this;
    }
    /**
     * Get UnitName value
     * @return string|null
     */
    public function getUnitName()
    {
        return $this->UnitName;
    }
    /**
     * Set UnitName value
     * @param string $unitName
     * @return \StructType\UnitCalendarAvailType
     */
    public function setUnitName($unitName = null)
    {
        // validation for constraint: string
        if (!is_null($unitName) && !is_string($unitName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($unitName)), __LINE__);
        }
        $this->UnitName = $unitName;
        return $this;
    }
    /**
     * Get InfoSource value
     * @return string|null
     */
    public function getInfoSource()
    {
        return $this->InfoSource;
    }
    /**
     * Set InfoSource value
     * @param string $infoSource
     * @return \StructType\UnitCalendarAvailType
     */
    public function setInfoSource($infoSource = null)
    {
        // validation for constraint: string
        if (!is_null($infoSource) && !is_string($infoSource)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($infoSource)), __LINE__);
        }
        $this->InfoSource = $infoSource;
        return $this;
    }
    /**
     * Get InternalUnitCode value
     * @return string|null
     */
    public function getInternalUnitCode()
    {
        return $this->InternalUnitCode;
    }
    /**
     * Set InternalUnitCode value
     * @param string $internalUnitCode
     * @return \StructType\UnitCalendarAvailType
     */
    public function setInternalUnitCode($internalUnitCode = null)
    {
        // validation for constraint: string
        if (!is_null($internalUnitCode) && !is_string($internalUnitCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($internalUnitCode)), __LINE__);
        }
        $this->InternalUnitCode = $internalUnitCode;
        return $this;
    }
    /**
     * Get UnitHeadline value
     * @return string|null
     */
    public function getUnitHeadline()
    {
        return $this->UnitHeadline;
    }
    /**
     * Set UnitHeadline value
     * @param string $unitHeadline
     * @return \StructType\UnitCalendarAvailType
     */
    public function setUnitHeadline($unitHeadline = null)
    {
        // validation for constraint: string
        if (!is_null($unitHeadline) && !is_string($unitHeadline)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($unitHeadline)), __LINE__);
        }
        $this->UnitHeadline = $unitHeadline;
        return $this;
    }
    /**
     * Get PropertyURL value
     * @return string|null
     */
    public function getPropertyURL()
    {
        return $this->PropertyURL;
    }
    /**
     * Set PropertyURL value
     * @param string $propertyURL
     * @return \StructType\UnitCalendarAvailType
     */
    public function setPropertyURL($propertyURL = null)
    {
        // validation for constraint: string
        if (!is_null($propertyURL) && !is_string($propertyURL)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($propertyURL)), __LINE__);
        }
        $this->PropertyURL = $propertyURL;
        return $this;
    }
    /**
     * Get LastUpdated value
     * @return string|null
     */
    public function getLastUpdated()
    {
        return $this->LastUpdated;
    }
    /**
     * Set LastUpdated value
     * @param string $lastUpdated
     * @return \StructType\UnitCalendarAvailType
     */
    public function setLastUpdated($lastUpdated = null)
    {
        // validation for constraint: string
        if (!is_null($lastUpdated) && !is_string($lastUpdated)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($lastUpdated)), __LINE__);
        }
        $this->LastUpdated = $lastUpdated;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\UnitCalendarAvailType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
