<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Source StructType
 * @subpackage Structs
 */
class Source extends AbstractStructBase
{
    /**
     * The UnitDescriptionURL
     * @var string
     */
    public $UnitDescriptionURL;
    /**
     * Constructor method for Source
     * @uses Source::setUnitDescriptionURL()
     * @param string $unitDescriptionURL
     */
    public function __construct($unitDescriptionURL = null)
    {
        $this
            ->setUnitDescriptionURL($unitDescriptionURL);
    }
    /**
     * Get UnitDescriptionURL value
     * @return string|null
     */
    public function getUnitDescriptionURL()
    {
        return $this->UnitDescriptionURL;
    }
    /**
     * Set UnitDescriptionURL value
     * @param string $unitDescriptionURL
     * @return \StructType\Source
     */
    public function setUnitDescriptionURL($unitDescriptionURL = null)
    {
        // validation for constraint: string
        if (!is_null($unitDescriptionURL) && !is_string($unitDescriptionURL)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($unitDescriptionURL)), __LINE__);
        }
        $this->UnitDescriptionURL = $unitDescriptionURL;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\Source
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
