<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ServiceRPH StructType
 * @subpackage Structs
 */
class ServiceRPH extends AbstractStructBase
{
    /**
     * The RPH
     * @var string
     */
    public $RPH;
    /**
     * The IsPerRoom
     * @var bool
     */
    public $IsPerRoom;
    /**
     * Constructor method for ServiceRPH
     * @uses ServiceRPH::setRPH()
     * @uses ServiceRPH::setIsPerRoom()
     * @param string $rPH
     * @param bool $isPerRoom
     */
    public function __construct($rPH = null, $isPerRoom = null)
    {
        $this
            ->setRPH($rPH)
            ->setIsPerRoom($isPerRoom);
    }
    /**
     * Get RPH value
     * @return string|null
     */
    public function getRPH()
    {
        return $this->RPH;
    }
    /**
     * Set RPH value
     * @param string $rPH
     * @return \StructType\ServiceRPH
     */
    public function setRPH($rPH = null)
    {
        // validation for constraint: string
        if (!is_null($rPH) && !is_string($rPH)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($rPH)), __LINE__);
        }
        $this->RPH = $rPH;
        return $this;
    }
    /**
     * Get IsPerRoom value
     * @return bool|null
     */
    public function getIsPerRoom()
    {
        return $this->IsPerRoom;
    }
    /**
     * Set IsPerRoom value
     * @param bool $isPerRoom
     * @return \StructType\ServiceRPH
     */
    public function setIsPerRoom($isPerRoom = null)
    {
        $this->IsPerRoom = $isPerRoom;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\ServiceRPH
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
