<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RoomAmenityPrefType StructType
 * @subpackage Structs
 */
class RoomAmenityPrefType extends AbstractStructBase
{
    /**
     * The _
     * @var string
     */
    public $_;
    /**
     * The PreferLevel
     * Meta informations extracted from the WSDL
     * - default: Preferred
     * @var string
     */
    public $PreferLevel;
    /**
     * The RoomAmenity
     * @var string
     */
    public $RoomAmenity;
    /**
     * The ExistsCode
     * @var string
     */
    public $ExistsCode;
    /**
     * The Quantity
     * @var int
     */
    public $Quantity;
    /**
     * The QualityLevel
     * @var string
     */
    public $QualityLevel;
    /**
     * Constructor method for RoomAmenityPrefType
     * @uses RoomAmenityPrefType::set_()
     * @uses RoomAmenityPrefType::setPreferLevel()
     * @uses RoomAmenityPrefType::setRoomAmenity()
     * @uses RoomAmenityPrefType::setExistsCode()
     * @uses RoomAmenityPrefType::setQuantity()
     * @uses RoomAmenityPrefType::setQualityLevel()
     * @param string $_
     * @param string $preferLevel
     * @param string $roomAmenity
     * @param string $existsCode
     * @param int $quantity
     * @param string $qualityLevel
     */
    public function __construct($_ = null, $preferLevel = 'Preferred', $roomAmenity = null, $existsCode = null, $quantity = null, $qualityLevel = null)
    {
        $this
            ->set_($_)
            ->setPreferLevel($preferLevel)
            ->setRoomAmenity($roomAmenity)
            ->setExistsCode($existsCode)
            ->setQuantity($quantity)
            ->setQualityLevel($qualityLevel);
    }
    /**
     * Get _ value
     * @return string|null
     */
    public function get_()
    {
        return $this->_;
    }
    /**
     * Set _ value
     * @param string $_
     * @return \StructType\RoomAmenityPrefType
     */
    public function set_($_ = null)
    {
        // validation for constraint: string
        if (!is_null($_) && !is_string($_)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($_)), __LINE__);
        }
        $this->_ = $_;
        return $this;
    }
    /**
     * Get PreferLevel value
     * @return string|null
     */
    public function getPreferLevel()
    {
        return $this->PreferLevel;
    }
    /**
     * Set PreferLevel value
     * @uses \EnumType\PreferLevelType::valueIsValid()
     * @uses \EnumType\PreferLevelType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $preferLevel
     * @return \StructType\RoomAmenityPrefType
     */
    public function setPreferLevel($preferLevel = 'Preferred')
    {
        // validation for constraint: enumeration
        if (!\EnumType\PreferLevelType::valueIsValid($preferLevel)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $preferLevel, implode(', ', \EnumType\PreferLevelType::getValidValues())), __LINE__);
        }
        $this->PreferLevel = $preferLevel;
        return $this;
    }
    /**
     * Get RoomAmenity value
     * @return string|null
     */
    public function getRoomAmenity()
    {
        return $this->RoomAmenity;
    }
    /**
     * Set RoomAmenity value
     * @param string $roomAmenity
     * @return \StructType\RoomAmenityPrefType
     */
    public function setRoomAmenity($roomAmenity = null)
    {
        // validation for constraint: string
        if (!is_null($roomAmenity) && !is_string($roomAmenity)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($roomAmenity)), __LINE__);
        }
        $this->RoomAmenity = $roomAmenity;
        return $this;
    }
    /**
     * Get ExistsCode value
     * @return string|null
     */
    public function getExistsCode()
    {
        return $this->ExistsCode;
    }
    /**
     * Set ExistsCode value
     * @param string $existsCode
     * @return \StructType\RoomAmenityPrefType
     */
    public function setExistsCode($existsCode = null)
    {
        // validation for constraint: string
        if (!is_null($existsCode) && !is_string($existsCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($existsCode)), __LINE__);
        }
        $this->ExistsCode = $existsCode;
        return $this;
    }
    /**
     * Get Quantity value
     * @return int|null
     */
    public function getQuantity()
    {
        return $this->Quantity;
    }
    /**
     * Set Quantity value
     * @param int $quantity
     * @return \StructType\RoomAmenityPrefType
     */
    public function setQuantity($quantity = null)
    {
        // validation for constraint: int
        if (!is_null($quantity) && !is_numeric($quantity)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($quantity)), __LINE__);
        }
        $this->Quantity = $quantity;
        return $this;
    }
    /**
     * Get QualityLevel value
     * @return string|null
     */
    public function getQualityLevel()
    {
        return $this->QualityLevel;
    }
    /**
     * Set QualityLevel value
     * @param string $qualityLevel
     * @return \StructType\RoomAmenityPrefType
     */
    public function setQualityLevel($qualityLevel = null)
    {
        // validation for constraint: string
        if (!is_null($qualityLevel) && !is_string($qualityLevel)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($qualityLevel)), __LINE__);
        }
        $this->QualityLevel = $qualityLevel;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\RoomAmenityPrefType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
