<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RegionType StructType
 * @subpackage Structs
 */
class RegionType extends RegionIdentifierType
{
    /**
     * The CountryCode
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $CountryCode;
    /**
     * The PostalCode
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var string[]
     */
    public $PostalCode;
    /**
     * Constructor method for RegionType
     * @uses RegionType::setCountryCode()
     * @uses RegionType::setPostalCode()
     * @param string $countryCode
     * @param string[] $postalCode
     */
    public function __construct($countryCode = null, array $postalCode = array())
    {
        $this
            ->setCountryCode($countryCode)
            ->setPostalCode($postalCode);
    }
    /**
     * Get CountryCode value
     * @return string|null
     */
    public function getCountryCode()
    {
        return $this->CountryCode;
    }
    /**
     * Set CountryCode value
     * @param string $countryCode
     * @return \StructType\RegionType
     */
    public function setCountryCode($countryCode = null)
    {
        // validation for constraint: string
        if (!is_null($countryCode) && !is_string($countryCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($countryCode)), __LINE__);
        }
        $this->CountryCode = $countryCode;
        return $this;
    }
    /**
     * Get PostalCode value
     * @return string[]|null
     */
    public function getPostalCode()
    {
        return $this->PostalCode;
    }
    /**
     * Set PostalCode value
     * @throws \InvalidArgumentException
     * @param string[] $postalCode
     * @return \StructType\RegionType
     */
    public function setPostalCode(array $postalCode = array())
    {
        foreach ($postalCode as $regionTypePostalCodeItem) {
            // validation for constraint: itemType
            if (!is_string($regionTypePostalCodeItem)) {
                throw new \InvalidArgumentException(sprintf('The PostalCode property can only contain items of string, "%s" given', is_object($regionTypePostalCodeItem) ? get_class($regionTypePostalCodeItem) : gettype($regionTypePostalCodeItem)), __LINE__);
            }
        }
        $this->PostalCode = $postalCode;
        return $this;
    }
    /**
     * Add item to PostalCode value
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \StructType\RegionType
     */
    public function addToPostalCode($item)
    {
        // validation for constraint: itemType
        if (!is_string($item)) {
            throw new \InvalidArgumentException(sprintf('The PostalCode property can only contain items of string, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->PostalCode[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\RegionType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
