<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RegionIdentifierType StructType
 * @subpackage Structs
 */
class RegionIdentifierType extends AbstractStructBase
{
    /**
     * The RegionCode
     * @var int
     */
    public $RegionCode;
    /**
     * The RegionName
     * @var string
     */
    public $RegionName;
    /**
     * The RegionFriendlyName
     * @var string
     */
    public $RegionFriendlyName;
    /**
     * Constructor method for RegionIdentifierType
     * @uses RegionIdentifierType::setRegionCode()
     * @uses RegionIdentifierType::setRegionName()
     * @uses RegionIdentifierType::setRegionFriendlyName()
     * @param int $regionCode
     * @param string $regionName
     * @param string $regionFriendlyName
     */
    public function __construct($regionCode = null, $regionName = null, $regionFriendlyName = null)
    {
        $this
            ->setRegionCode($regionCode)
            ->setRegionName($regionName)
            ->setRegionFriendlyName($regionFriendlyName);
    }
    /**
     * Get RegionCode value
     * @return int|null
     */
    public function getRegionCode()
    {
        return $this->RegionCode;
    }
    /**
     * Set RegionCode value
     * @param int $regionCode
     * @return \StructType\RegionIdentifierType
     */
    public function setRegionCode($regionCode = null)
    {
        // validation for constraint: int
        if (!is_null($regionCode) && !is_numeric($regionCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($regionCode)), __LINE__);
        }
        $this->RegionCode = $regionCode;
        return $this;
    }
    /**
     * Get RegionName value
     * @return string|null
     */
    public function getRegionName()
    {
        return $this->RegionName;
    }
    /**
     * Set RegionName value
     * @param string $regionName
     * @return \StructType\RegionIdentifierType
     */
    public function setRegionName($regionName = null)
    {
        // validation for constraint: string
        if (!is_null($regionName) && !is_string($regionName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($regionName)), __LINE__);
        }
        $this->RegionName = $regionName;
        return $this;
    }
    /**
     * Get RegionFriendlyName value
     * @return string|null
     */
    public function getRegionFriendlyName()
    {
        return $this->RegionFriendlyName;
    }
    /**
     * Set RegionFriendlyName value
     * @param string $regionFriendlyName
     * @return \StructType\RegionIdentifierType
     */
    public function setRegionFriendlyName($regionFriendlyName = null)
    {
        // validation for constraint: string
        if (!is_null($regionFriendlyName) && !is_string($regionFriendlyName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($regionFriendlyName)), __LINE__);
        }
        $this->RegionFriendlyName = $regionFriendlyName;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\RegionIdentifierType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
