<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PropertyManagerType StructType
 * @subpackage Structs
 */
class PropertyManagerType extends ProfileType
{
    /**
     * The PropertyManagerCode
     * @var string
     */
    public $PropertyManagerCode;
    /**
     * The CurrencyCode
     * @var string
     */
    public $CurrencyCode;
    /**
     * The DecimalPlaces
     * @var int
     */
    public $DecimalPlaces;
    /**
     * Constructor method for PropertyManagerType
     * @uses PropertyManagerType::setPropertyManagerCode()
     * @uses PropertyManagerType::setCurrencyCode()
     * @uses PropertyManagerType::setDecimalPlaces()
     * @param string $propertyManagerCode
     * @param string $currencyCode
     * @param int $decimalPlaces
     */
    public function __construct($propertyManagerCode = null, $currencyCode = null, $decimalPlaces = null)
    {
        $this
            ->setPropertyManagerCode($propertyManagerCode)
            ->setCurrencyCode($currencyCode)
            ->setDecimalPlaces($decimalPlaces);
    }
    /**
     * Get PropertyManagerCode value
     * @return string|null
     */
    public function getPropertyManagerCode()
    {
        return $this->PropertyManagerCode;
    }
    /**
     * Set PropertyManagerCode value
     * @param string $propertyManagerCode
     * @return \StructType\PropertyManagerType
     */
    public function setPropertyManagerCode($propertyManagerCode = null)
    {
        // validation for constraint: string
        if (!is_null($propertyManagerCode) && !is_string($propertyManagerCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($propertyManagerCode)), __LINE__);
        }
        $this->PropertyManagerCode = $propertyManagerCode;
        return $this;
    }
    /**
     * Get CurrencyCode value
     * @return string|null
     */
    public function getCurrencyCode()
    {
        return $this->CurrencyCode;
    }
    /**
     * Set CurrencyCode value
     * @param string $currencyCode
     * @return \StructType\PropertyManagerType
     */
    public function setCurrencyCode($currencyCode = null)
    {
        // validation for constraint: string
        if (!is_null($currencyCode) && !is_string($currencyCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($currencyCode)), __LINE__);
        }
        $this->CurrencyCode = $currencyCode;
        return $this;
    }
    /**
     * Get DecimalPlaces value
     * @return int|null
     */
    public function getDecimalPlaces()
    {
        return $this->DecimalPlaces;
    }
    /**
     * Set DecimalPlaces value
     * @param int $decimalPlaces
     * @return \StructType\PropertyManagerType
     */
    public function setDecimalPlaces($decimalPlaces = null)
    {
        // validation for constraint: int
        if (!is_null($decimalPlaces) && !is_numeric($decimalPlaces)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($decimalPlaces)), __LINE__);
        }
        $this->DecimalPlaces = $decimalPlaces;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\PropertyManagerType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
