<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PetsPoliciesType StructType
 * @subpackage Structs
 */
class PetsPoliciesType extends AbstractStructBase
{
    /**
     * The PetsPolicy
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\PetsPolicy[]
     */
    public $PetsPolicy;
    /**
     * The PetsAllowedCode
     * @var string
     */
    public $PetsAllowedCode;
    /**
     * Constructor method for PetsPoliciesType
     * @uses PetsPoliciesType::setPetsPolicy()
     * @uses PetsPoliciesType::setPetsAllowedCode()
     * @param \StructType\PetsPolicy[] $petsPolicy
     * @param string $petsAllowedCode
     */
    public function __construct(array $petsPolicy = array(), $petsAllowedCode = null)
    {
        $this
            ->setPetsPolicy($petsPolicy)
            ->setPetsAllowedCode($petsAllowedCode);
    }
    /**
     * Get PetsPolicy value
     * @return \StructType\PetsPolicy[]|null
     */
    public function getPetsPolicy()
    {
        return $this->PetsPolicy;
    }
    /**
     * Set PetsPolicy value
     * @throws \InvalidArgumentException
     * @param \StructType\PetsPolicy[] $petsPolicy
     * @return \StructType\PetsPoliciesType
     */
    public function setPetsPolicy(array $petsPolicy = array())
    {
        foreach ($petsPolicy as $petsPoliciesTypePetsPolicyItem) {
            // validation for constraint: itemType
            if (!$petsPoliciesTypePetsPolicyItem instanceof \StructType\PetsPolicy) {
                throw new \InvalidArgumentException(sprintf('The PetsPolicy property can only contain items of \StructType\PetsPolicy, "%s" given', is_object($petsPoliciesTypePetsPolicyItem) ? get_class($petsPoliciesTypePetsPolicyItem) : gettype($petsPoliciesTypePetsPolicyItem)), __LINE__);
            }
        }
        $this->PetsPolicy = $petsPolicy;
        return $this;
    }
    /**
     * Add item to PetsPolicy value
     * @throws \InvalidArgumentException
     * @param \StructType\PetsPolicy $item
     * @return \StructType\PetsPoliciesType
     */
    public function addToPetsPolicy(\StructType\PetsPolicy $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\PetsPolicy) {
            throw new \InvalidArgumentException(sprintf('The PetsPolicy property can only contain items of \StructType\PetsPolicy, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->PetsPolicy[] = $item;
        return $this;
    }
    /**
     * Get PetsAllowedCode value
     * @return string|null
     */
    public function getPetsAllowedCode()
    {
        return $this->PetsAllowedCode;
    }
    /**
     * Set PetsAllowedCode value
     * @uses \EnumType\PetsAllowedCodeType::valueIsValid()
     * @uses \EnumType\PetsAllowedCodeType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $petsAllowedCode
     * @return \StructType\PetsPoliciesType
     */
    public function setPetsAllowedCode($petsAllowedCode = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\PetsAllowedCodeType::valueIsValid($petsAllowedCode)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $petsAllowedCode, implode(', ', \EnumType\PetsAllowedCodeType::getValidValues())), __LINE__);
        }
        $this->PetsAllowedCode = $petsAllowedCode;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\PetsPoliciesType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
