<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GuaranteeAccepted StructType
 * @subpackage Structs
 */
class GuaranteeAccepted extends PaymentFormType
{
    /**
     * The Default
     * @var bool
     */
    public $Default;
    /**
     * The NoCardHolderInfoReqInd
     * @var bool
     */
    public $NoCardHolderInfoReqInd;
    /**
     * The NameReqInd
     * @var bool
     */
    public $NameReqInd;
    /**
     * The AddressReqInd
     * @var bool
     */
    public $AddressReqInd;
    /**
     * The PhoneReqInd
     * @var bool
     */
    public $PhoneReqInd;
    /**
     * The InterbankNbrReqInd
     * @var bool
     */
    public $InterbankNbrReqInd;
    /**
     * The BookingSourceAllowedInd
     * @var bool
     */
    public $BookingSourceAllowedInd;
    /**
     * The CorpDiscountNbrAllowedInd
     * @var bool
     */
    public $CorpDiscountNbrAllowedInd;
    /**
     * The GuaranteeTypeCode
     * @var string
     */
    public $GuaranteeTypeCode;
    /**
     * The GuaranteeID
     * @var string
     */
    public $GuaranteeID;
    /**
     * Constructor method for GuaranteeAccepted
     * @uses GuaranteeAccepted::setDefault()
     * @uses GuaranteeAccepted::setNoCardHolderInfoReqInd()
     * @uses GuaranteeAccepted::setNameReqInd()
     * @uses GuaranteeAccepted::setAddressReqInd()
     * @uses GuaranteeAccepted::setPhoneReqInd()
     * @uses GuaranteeAccepted::setInterbankNbrReqInd()
     * @uses GuaranteeAccepted::setBookingSourceAllowedInd()
     * @uses GuaranteeAccepted::setCorpDiscountNbrAllowedInd()
     * @uses GuaranteeAccepted::setGuaranteeTypeCode()
     * @uses GuaranteeAccepted::setGuaranteeID()
     * @param bool $default
     * @param bool $noCardHolderInfoReqInd
     * @param bool $nameReqInd
     * @param bool $addressReqInd
     * @param bool $phoneReqInd
     * @param bool $interbankNbrReqInd
     * @param bool $bookingSourceAllowedInd
     * @param bool $corpDiscountNbrAllowedInd
     * @param string $guaranteeTypeCode
     * @param string $guaranteeID
     */
    public function __construct($default = null, $noCardHolderInfoReqInd = null, $nameReqInd = null, $addressReqInd = null, $phoneReqInd = null, $interbankNbrReqInd = null, $bookingSourceAllowedInd = null, $corpDiscountNbrAllowedInd = null, $guaranteeTypeCode = null, $guaranteeID = null)
    {
        $this
            ->setDefault($default)
            ->setNoCardHolderInfoReqInd($noCardHolderInfoReqInd)
            ->setNameReqInd($nameReqInd)
            ->setAddressReqInd($addressReqInd)
            ->setPhoneReqInd($phoneReqInd)
            ->setInterbankNbrReqInd($interbankNbrReqInd)
            ->setBookingSourceAllowedInd($bookingSourceAllowedInd)
            ->setCorpDiscountNbrAllowedInd($corpDiscountNbrAllowedInd)
            ->setGuaranteeTypeCode($guaranteeTypeCode)
            ->setGuaranteeID($guaranteeID);
    }
    /**
     * Get Default value
     * @return bool|null
     */
    public function getDefault()
    {
        return $this->Default;
    }
    /**
     * Set Default value
     * @param bool $default
     * @return \StructType\GuaranteeAccepted
     */
    public function setDefault($default = null)
    {
        $this->Default = $default;
        return $this;
    }
    /**
     * Get NoCardHolderInfoReqInd value
     * @return bool|null
     */
    public function getNoCardHolderInfoReqInd()
    {
        return $this->NoCardHolderInfoReqInd;
    }
    /**
     * Set NoCardHolderInfoReqInd value
     * @param bool $noCardHolderInfoReqInd
     * @return \StructType\GuaranteeAccepted
     */
    public function setNoCardHolderInfoReqInd($noCardHolderInfoReqInd = null)
    {
        $this->NoCardHolderInfoReqInd = $noCardHolderInfoReqInd;
        return $this;
    }
    /**
     * Get NameReqInd value
     * @return bool|null
     */
    public function getNameReqInd()
    {
        return $this->NameReqInd;
    }
    /**
     * Set NameReqInd value
     * @param bool $nameReqInd
     * @return \StructType\GuaranteeAccepted
     */
    public function setNameReqInd($nameReqInd = null)
    {
        $this->NameReqInd = $nameReqInd;
        return $this;
    }
    /**
     * Get AddressReqInd value
     * @return bool|null
     */
    public function getAddressReqInd()
    {
        return $this->AddressReqInd;
    }
    /**
     * Set AddressReqInd value
     * @param bool $addressReqInd
     * @return \StructType\GuaranteeAccepted
     */
    public function setAddressReqInd($addressReqInd = null)
    {
        $this->AddressReqInd = $addressReqInd;
        return $this;
    }
    /**
     * Get PhoneReqInd value
     * @return bool|null
     */
    public function getPhoneReqInd()
    {
        return $this->PhoneReqInd;
    }
    /**
     * Set PhoneReqInd value
     * @param bool $phoneReqInd
     * @return \StructType\GuaranteeAccepted
     */
    public function setPhoneReqInd($phoneReqInd = null)
    {
        $this->PhoneReqInd = $phoneReqInd;
        return $this;
    }
    /**
     * Get InterbankNbrReqInd value
     * @return bool|null
     */
    public function getInterbankNbrReqInd()
    {
        return $this->InterbankNbrReqInd;
    }
    /**
     * Set InterbankNbrReqInd value
     * @param bool $interbankNbrReqInd
     * @return \StructType\GuaranteeAccepted
     */
    public function setInterbankNbrReqInd($interbankNbrReqInd = null)
    {
        $this->InterbankNbrReqInd = $interbankNbrReqInd;
        return $this;
    }
    /**
     * Get BookingSourceAllowedInd value
     * @return bool|null
     */
    public function getBookingSourceAllowedInd()
    {
        return $this->BookingSourceAllowedInd;
    }
    /**
     * Set BookingSourceAllowedInd value
     * @param bool $bookingSourceAllowedInd
     * @return \StructType\GuaranteeAccepted
     */
    public function setBookingSourceAllowedInd($bookingSourceAllowedInd = null)
    {
        $this->BookingSourceAllowedInd = $bookingSourceAllowedInd;
        return $this;
    }
    /**
     * Get CorpDiscountNbrAllowedInd value
     * @return bool|null
     */
    public function getCorpDiscountNbrAllowedInd()
    {
        return $this->CorpDiscountNbrAllowedInd;
    }
    /**
     * Set CorpDiscountNbrAllowedInd value
     * @param bool $corpDiscountNbrAllowedInd
     * @return \StructType\GuaranteeAccepted
     */
    public function setCorpDiscountNbrAllowedInd($corpDiscountNbrAllowedInd = null)
    {
        $this->CorpDiscountNbrAllowedInd = $corpDiscountNbrAllowedInd;
        return $this;
    }
    /**
     * Get GuaranteeTypeCode value
     * @return string|null
     */
    public function getGuaranteeTypeCode()
    {
        return $this->GuaranteeTypeCode;
    }
    /**
     * Set GuaranteeTypeCode value
     * @param string $guaranteeTypeCode
     * @return \StructType\GuaranteeAccepted
     */
    public function setGuaranteeTypeCode($guaranteeTypeCode = null)
    {
        // validation for constraint: string
        if (!is_null($guaranteeTypeCode) && !is_string($guaranteeTypeCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($guaranteeTypeCode)), __LINE__);
        }
        $this->GuaranteeTypeCode = $guaranteeTypeCode;
        return $this;
    }
    /**
     * Get GuaranteeID value
     * @return string|null
     */
    public function getGuaranteeID()
    {
        return $this->GuaranteeID;
    }
    /**
     * Set GuaranteeID value
     * @param string $guaranteeID
     * @return \StructType\GuaranteeAccepted
     */
    public function setGuaranteeID($guaranteeID = null)
    {
        // validation for constraint: string
        if (!is_null($guaranteeID) && !is_string($guaranteeID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($guaranteeID)), __LINE__);
        }
        $this->GuaranteeID = $guaranteeID;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\GuaranteeAccepted
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
