<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for FeeType StructType
 * @subpackage Structs
 */
class FeeType extends AbstractStructBase
{
    /**
     * The Taxes
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\TaxesType
     */
    public $Taxes;
    /**
     * The Description
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\ParagraphType[]
     */
    public $Description;
    /**
     * The TaxInclusive
     * @var bool
     */
    public $TaxInclusive;
    /**
     * The Type
     * @var string
     */
    public $Type;
    /**
     * The Code
     * @var string
     */
    public $Code;
    /**
     * The Percent
     * @var float
     */
    public $Percent;
    /**
     * The Amount
     * @var float
     */
    public $Amount;
    /**
     * The CurrencyCode
     * @var string
     */
    public $CurrencyCode;
    /**
     * The DecimalPlaces
     * @var int
     */
    public $DecimalPlaces;
    /**
     * The EffectiveDate
     * @var string
     */
    public $EffectiveDate;
    /**
     * The ExpireDate
     * @var string
     */
    public $ExpireDate;
    /**
     * The MandatoryIndicator
     * @var bool
     */
    public $MandatoryIndicator;
    /**
     * The RPH
     * @var string
     */
    public $RPH;
    /**
     * The ChargeUnit
     * @var string
     */
    public $ChargeUnit;
    /**
     * The ChargeFrequency
     * @var string
     */
    public $ChargeFrequency;
    /**
     * The ChargeUnitExempt
     * @var int
     */
    public $ChargeUnitExempt;
    /**
     * The ChargeFrequencyExempt
     * @var int
     */
    public $ChargeFrequencyExempt;
    /**
     * The MaxChargeUnitApplies
     * @var int
     */
    public $MaxChargeUnitApplies;
    /**
     * The MaxChargeFrequencyApplies
     * @var int
     */
    public $MaxChargeFrequencyApplies;
    /**
     * The TaxableIndicator
     * @var bool
     */
    public $TaxableIndicator;
    /**
     * Constructor method for FeeType
     * @uses FeeType::setTaxes()
     * @uses FeeType::setDescription()
     * @uses FeeType::setTaxInclusive()
     * @uses FeeType::setType()
     * @uses FeeType::setCode()
     * @uses FeeType::setPercent()
     * @uses FeeType::setAmount()
     * @uses FeeType::setCurrencyCode()
     * @uses FeeType::setDecimalPlaces()
     * @uses FeeType::setEffectiveDate()
     * @uses FeeType::setExpireDate()
     * @uses FeeType::setMandatoryIndicator()
     * @uses FeeType::setRPH()
     * @uses FeeType::setChargeUnit()
     * @uses FeeType::setChargeFrequency()
     * @uses FeeType::setChargeUnitExempt()
     * @uses FeeType::setChargeFrequencyExempt()
     * @uses FeeType::setMaxChargeUnitApplies()
     * @uses FeeType::setMaxChargeFrequencyApplies()
     * @uses FeeType::setTaxableIndicator()
     * @param \StructType\TaxesType $taxes
     * @param \StructType\ParagraphType[] $description
     * @param bool $taxInclusive
     * @param string $type
     * @param string $code
     * @param float $percent
     * @param float $amount
     * @param string $currencyCode
     * @param int $decimalPlaces
     * @param string $effectiveDate
     * @param string $expireDate
     * @param bool $mandatoryIndicator
     * @param string $rPH
     * @param string $chargeUnit
     * @param string $chargeFrequency
     * @param int $chargeUnitExempt
     * @param int $chargeFrequencyExempt
     * @param int $maxChargeUnitApplies
     * @param int $maxChargeFrequencyApplies
     * @param bool $taxableIndicator
     */
    public function __construct(\StructType\TaxesType $taxes = null, array $description = array(), $taxInclusive = null, $type = null, $code = null, $percent = null, $amount = null, $currencyCode = null, $decimalPlaces = null, $effectiveDate = null, $expireDate = null, $mandatoryIndicator = null, $rPH = null, $chargeUnit = null, $chargeFrequency = null, $chargeUnitExempt = null, $chargeFrequencyExempt = null, $maxChargeUnitApplies = null, $maxChargeFrequencyApplies = null, $taxableIndicator = null)
    {
        $this
            ->setTaxes($taxes)
            ->setDescription($description)
            ->setTaxInclusive($taxInclusive)
            ->setType($type)
            ->setCode($code)
            ->setPercent($percent)
            ->setAmount($amount)
            ->setCurrencyCode($currencyCode)
            ->setDecimalPlaces($decimalPlaces)
            ->setEffectiveDate($effectiveDate)
            ->setExpireDate($expireDate)
            ->setMandatoryIndicator($mandatoryIndicator)
            ->setRPH($rPH)
            ->setChargeUnit($chargeUnit)
            ->setChargeFrequency($chargeFrequency)
            ->setChargeUnitExempt($chargeUnitExempt)
            ->setChargeFrequencyExempt($chargeFrequencyExempt)
            ->setMaxChargeUnitApplies($maxChargeUnitApplies)
            ->setMaxChargeFrequencyApplies($maxChargeFrequencyApplies)
            ->setTaxableIndicator($taxableIndicator);
    }
    /**
     * Get Taxes value
     * @return \StructType\TaxesType|null
     */
    public function getTaxes()
    {
        return $this->Taxes;
    }
    /**
     * Set Taxes value
     * @param \StructType\TaxesType $taxes
     * @return \StructType\FeeType
     */
    public function setTaxes(\StructType\TaxesType $taxes = null)
    {
        $this->Taxes = $taxes;
        return $this;
    }
    /**
     * Get Description value
     * @return \StructType\ParagraphType[]|null
     */
    public function getDescription()
    {
        return $this->Description;
    }
    /**
     * Set Description value
     * @throws \InvalidArgumentException
     * @param \StructType\ParagraphType[] $description
     * @return \StructType\FeeType
     */
    public function setDescription(array $description = array())
    {
        foreach ($description as $feeTypeDescriptionItem) {
            // validation for constraint: itemType
            if (!$feeTypeDescriptionItem instanceof \StructType\ParagraphType) {
                throw new \InvalidArgumentException(sprintf('The Description property can only contain items of \StructType\ParagraphType, "%s" given', is_object($feeTypeDescriptionItem) ? get_class($feeTypeDescriptionItem) : gettype($feeTypeDescriptionItem)), __LINE__);
            }
        }
        $this->Description = $description;
        return $this;
    }
    /**
     * Add item to Description value
     * @throws \InvalidArgumentException
     * @param \StructType\ParagraphType $item
     * @return \StructType\FeeType
     */
    public function addToDescription(\StructType\ParagraphType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\ParagraphType) {
            throw new \InvalidArgumentException(sprintf('The Description property can only contain items of \StructType\ParagraphType, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->Description[] = $item;
        return $this;
    }
    /**
     * Get TaxInclusive value
     * @return bool|null
     */
    public function getTaxInclusive()
    {
        return $this->TaxInclusive;
    }
    /**
     * Set TaxInclusive value
     * @param bool $taxInclusive
     * @return \StructType\FeeType
     */
    public function setTaxInclusive($taxInclusive = null)
    {
        $this->TaxInclusive = $taxInclusive;
        return $this;
    }
    /**
     * Get Type value
     * @return string|null
     */
    public function getType()
    {
        return $this->Type;
    }
    /**
     * Set Type value
     * @uses \EnumType\AmountDeterminationType::valueIsValid()
     * @uses \EnumType\AmountDeterminationType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $type
     * @return \StructType\FeeType
     */
    public function setType($type = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\AmountDeterminationType::valueIsValid($type)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $type, implode(', ', \EnumType\AmountDeterminationType::getValidValues())), __LINE__);
        }
        $this->Type = $type;
        return $this;
    }
    /**
     * Get Code value
     * @return string|null
     */
    public function getCode()
    {
        return $this->Code;
    }
    /**
     * Set Code value
     * @param string $code
     * @return \StructType\FeeType
     */
    public function setCode($code = null)
    {
        // validation for constraint: string
        if (!is_null($code) && !is_string($code)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($code)), __LINE__);
        }
        $this->Code = $code;
        return $this;
    }
    /**
     * Get Percent value
     * @return float|null
     */
    public function getPercent()
    {
        return $this->Percent;
    }
    /**
     * Set Percent value
     * @param float $percent
     * @return \StructType\FeeType
     */
    public function setPercent($percent = null)
    {
        $this->Percent = $percent;
        return $this;
    }
    /**
     * Get Amount value
     * @return float|null
     */
    public function getAmount()
    {
        return $this->Amount;
    }
    /**
     * Set Amount value
     * @param float $amount
     * @return \StructType\FeeType
     */
    public function setAmount($amount = null)
    {
        $this->Amount = $amount;
        return $this;
    }
    /**
     * Get CurrencyCode value
     * @return string|null
     */
    public function getCurrencyCode()
    {
        return $this->CurrencyCode;
    }
    /**
     * Set CurrencyCode value
     * @param string $currencyCode
     * @return \StructType\FeeType
     */
    public function setCurrencyCode($currencyCode = null)
    {
        // validation for constraint: string
        if (!is_null($currencyCode) && !is_string($currencyCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($currencyCode)), __LINE__);
        }
        $this->CurrencyCode = $currencyCode;
        return $this;
    }
    /**
     * Get DecimalPlaces value
     * @return int|null
     */
    public function getDecimalPlaces()
    {
        return $this->DecimalPlaces;
    }
    /**
     * Set DecimalPlaces value
     * @param int $decimalPlaces
     * @return \StructType\FeeType
     */
    public function setDecimalPlaces($decimalPlaces = null)
    {
        // validation for constraint: int
        if (!is_null($decimalPlaces) && !is_numeric($decimalPlaces)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($decimalPlaces)), __LINE__);
        }
        $this->DecimalPlaces = $decimalPlaces;
        return $this;
    }
    /**
     * Get EffectiveDate value
     * @return string|null
     */
    public function getEffectiveDate()
    {
        return $this->EffectiveDate;
    }
    /**
     * Set EffectiveDate value
     * @param string $effectiveDate
     * @return \StructType\FeeType
     */
    public function setEffectiveDate($effectiveDate = null)
    {
        // validation for constraint: string
        if (!is_null($effectiveDate) && !is_string($effectiveDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($effectiveDate)), __LINE__);
        }
        $this->EffectiveDate = $effectiveDate;
        return $this;
    }
    /**
     * Get ExpireDate value
     * @return string|null
     */
    public function getExpireDate()
    {
        return $this->ExpireDate;
    }
    /**
     * Set ExpireDate value
     * @param string $expireDate
     * @return \StructType\FeeType
     */
    public function setExpireDate($expireDate = null)
    {
        // validation for constraint: string
        if (!is_null($expireDate) && !is_string($expireDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($expireDate)), __LINE__);
        }
        $this->ExpireDate = $expireDate;
        return $this;
    }
    /**
     * Get MandatoryIndicator value
     * @return bool|null
     */
    public function getMandatoryIndicator()
    {
        return $this->MandatoryIndicator;
    }
    /**
     * Set MandatoryIndicator value
     * @param bool $mandatoryIndicator
     * @return \StructType\FeeType
     */
    public function setMandatoryIndicator($mandatoryIndicator = null)
    {
        $this->MandatoryIndicator = $mandatoryIndicator;
        return $this;
    }
    /**
     * Get RPH value
     * @return string|null
     */
    public function getRPH()
    {
        return $this->RPH;
    }
    /**
     * Set RPH value
     * @param string $rPH
     * @return \StructType\FeeType
     */
    public function setRPH($rPH = null)
    {
        // validation for constraint: string
        if (!is_null($rPH) && !is_string($rPH)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($rPH)), __LINE__);
        }
        $this->RPH = $rPH;
        return $this;
    }
    /**
     * Get ChargeUnit value
     * @return string|null
     */
    public function getChargeUnit()
    {
        return $this->ChargeUnit;
    }
    /**
     * Set ChargeUnit value
     * @param string $chargeUnit
     * @return \StructType\FeeType
     */
    public function setChargeUnit($chargeUnit = null)
    {
        // validation for constraint: string
        if (!is_null($chargeUnit) && !is_string($chargeUnit)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($chargeUnit)), __LINE__);
        }
        $this->ChargeUnit = $chargeUnit;
        return $this;
    }
    /**
     * Get ChargeFrequency value
     * @return string|null
     */
    public function getChargeFrequency()
    {
        return $this->ChargeFrequency;
    }
    /**
     * Set ChargeFrequency value
     * @param string $chargeFrequency
     * @return \StructType\FeeType
     */
    public function setChargeFrequency($chargeFrequency = null)
    {
        // validation for constraint: string
        if (!is_null($chargeFrequency) && !is_string($chargeFrequency)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($chargeFrequency)), __LINE__);
        }
        $this->ChargeFrequency = $chargeFrequency;
        return $this;
    }
    /**
     * Get ChargeUnitExempt value
     * @return int|null
     */
    public function getChargeUnitExempt()
    {
        return $this->ChargeUnitExempt;
    }
    /**
     * Set ChargeUnitExempt value
     * @param int $chargeUnitExempt
     * @return \StructType\FeeType
     */
    public function setChargeUnitExempt($chargeUnitExempt = null)
    {
        // validation for constraint: int
        if (!is_null($chargeUnitExempt) && !is_numeric($chargeUnitExempt)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($chargeUnitExempt)), __LINE__);
        }
        $this->ChargeUnitExempt = $chargeUnitExempt;
        return $this;
    }
    /**
     * Get ChargeFrequencyExempt value
     * @return int|null
     */
    public function getChargeFrequencyExempt()
    {
        return $this->ChargeFrequencyExempt;
    }
    /**
     * Set ChargeFrequencyExempt value
     * @param int $chargeFrequencyExempt
     * @return \StructType\FeeType
     */
    public function setChargeFrequencyExempt($chargeFrequencyExempt = null)
    {
        // validation for constraint: int
        if (!is_null($chargeFrequencyExempt) && !is_numeric($chargeFrequencyExempt)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($chargeFrequencyExempt)), __LINE__);
        }
        $this->ChargeFrequencyExempt = $chargeFrequencyExempt;
        return $this;
    }
    /**
     * Get MaxChargeUnitApplies value
     * @return int|null
     */
    public function getMaxChargeUnitApplies()
    {
        return $this->MaxChargeUnitApplies;
    }
    /**
     * Set MaxChargeUnitApplies value
     * @param int $maxChargeUnitApplies
     * @return \StructType\FeeType
     */
    public function setMaxChargeUnitApplies($maxChargeUnitApplies = null)
    {
        // validation for constraint: int
        if (!is_null($maxChargeUnitApplies) && !is_numeric($maxChargeUnitApplies)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($maxChargeUnitApplies)), __LINE__);
        }
        $this->MaxChargeUnitApplies = $maxChargeUnitApplies;
        return $this;
    }
    /**
     * Get MaxChargeFrequencyApplies value
     * @return int|null
     */
    public function getMaxChargeFrequencyApplies()
    {
        return $this->MaxChargeFrequencyApplies;
    }
    /**
     * Set MaxChargeFrequencyApplies value
     * @param int $maxChargeFrequencyApplies
     * @return \StructType\FeeType
     */
    public function setMaxChargeFrequencyApplies($maxChargeFrequencyApplies = null)
    {
        // validation for constraint: int
        if (!is_null($maxChargeFrequencyApplies) && !is_numeric($maxChargeFrequencyApplies)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($maxChargeFrequencyApplies)), __LINE__);
        }
        $this->MaxChargeFrequencyApplies = $maxChargeFrequencyApplies;
        return $this;
    }
    /**
     * Get TaxableIndicator value
     * @return bool|null
     */
    public function getTaxableIndicator()
    {
        return $this->TaxableIndicator;
    }
    /**
     * Set TaxableIndicator value
     * @param bool $taxableIndicator
     * @return \StructType\FeeType
     */
    public function setTaxableIndicator($taxableIndicator = null)
    {
        $this->TaxableIndicator = $taxableIndicator;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\FeeType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
