<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for EVRN_ReservationCancelRQ StructType
 * @subpackage Structs
 */
class EVRN_ReservationCancelRQ extends EVRN_BaseRQType
{
    /**
     * The UnitCode
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $UnitCode;
    /**
     * The AgentID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $AgentID;
    /**
     * The ReservationID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ReservationID;
    /**
     * The ReservationNumber
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ReservationNumber;
    /**
     * Constructor method for EVRN_ReservationCancelRQ
     * @uses EVRN_ReservationCancelRQ::setUnitCode()
     * @uses EVRN_ReservationCancelRQ::setAgentID()
     * @uses EVRN_ReservationCancelRQ::setReservationID()
     * @uses EVRN_ReservationCancelRQ::setReservationNumber()
     * @param string $unitCode
     * @param string $agentID
     * @param string $reservationID
     * @param string $reservationNumber
     */
    public function __construct($unitCode = null, $agentID = null, $reservationID = null, $reservationNumber = null)
    {
        $this
            ->setUnitCode($unitCode)
            ->setAgentID($agentID)
            ->setReservationID($reservationID)
            ->setReservationNumber($reservationNumber);
    }
    /**
     * Get UnitCode value
     * @return string|null
     */
    public function getUnitCode()
    {
        return $this->UnitCode;
    }
    /**
     * Set UnitCode value
     * @param string $unitCode
     * @return \StructType\EVRN_ReservationCancelRQ
     */
    public function setUnitCode($unitCode = null)
    {
        // validation for constraint: string
        if (!is_null($unitCode) && !is_string($unitCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($unitCode)), __LINE__);
        }
        $this->UnitCode = $unitCode;
        return $this;
    }
    /**
     * Get AgentID value
     * @return string|null
     */
    public function getAgentID()
    {
        return $this->AgentID;
    }
    /**
     * Set AgentID value
     * @param string $agentID
     * @return \StructType\EVRN_ReservationCancelRQ
     */
    public function setAgentID($agentID = null)
    {
        // validation for constraint: string
        if (!is_null($agentID) && !is_string($agentID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($agentID)), __LINE__);
        }
        $this->AgentID = $agentID;
        return $this;
    }
    /**
     * Get ReservationID value
     * @return string|null
     */
    public function getReservationID()
    {
        return $this->ReservationID;
    }
    /**
     * Set ReservationID value
     * @param string $reservationID
     * @return \StructType\EVRN_ReservationCancelRQ
     */
    public function setReservationID($reservationID = null)
    {
        // validation for constraint: string
        if (!is_null($reservationID) && !is_string($reservationID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($reservationID)), __LINE__);
        }
        $this->ReservationID = $reservationID;
        return $this;
    }
    /**
     * Get ReservationNumber value
     * @return string|null
     */
    public function getReservationNumber()
    {
        return $this->ReservationNumber;
    }
    /**
     * Set ReservationNumber value
     * @param string $reservationNumber
     * @return \StructType\EVRN_ReservationCancelRQ
     */
    public function setReservationNumber($reservationNumber = null)
    {
        // validation for constraint: string
        if (!is_null($reservationNumber) && !is_string($reservationNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($reservationNumber)), __LINE__);
        }
        $this->ReservationNumber = $reservationNumber;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\EVRN_ReservationCancelRQ
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
