<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for DateTimeSpanType StructType
 * @subpackage Structs
 */
class DateTimeSpanType extends AbstractStructBase
{
    /**
     * The StartDateWindow
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\StartDateWindow
     */
    public $StartDateWindow;
    /**
     * The DateWindowRange
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\TimeInstantType
     */
    public $DateWindowRange;
    /**
     * The EndDateWindow
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\EndDateWindow
     */
    public $EndDateWindow;
    /**
     * The Start
     * @var string
     */
    public $Start;
    /**
     * The Duration
     * @var string
     */
    public $Duration;
    /**
     * The End
     * @var string
     */
    public $End;
    /**
     * The Release
     * @var string
     */
    public $Release;
    /**
     * Constructor method for DateTimeSpanType
     * @uses DateTimeSpanType::setStartDateWindow()
     * @uses DateTimeSpanType::setDateWindowRange()
     * @uses DateTimeSpanType::setEndDateWindow()
     * @uses DateTimeSpanType::setStart()
     * @uses DateTimeSpanType::setDuration()
     * @uses DateTimeSpanType::setEnd()
     * @uses DateTimeSpanType::setRelease()
     * @param \StructType\StartDateWindow $startDateWindow
     * @param \StructType\TimeInstantType $dateWindowRange
     * @param \StructType\EndDateWindow $endDateWindow
     * @param string $start
     * @param string $duration
     * @param string $end
     * @param string $release
     */
    public function __construct(\StructType\StartDateWindow $startDateWindow = null, \StructType\TimeInstantType $dateWindowRange = null, \StructType\EndDateWindow $endDateWindow = null, $start = null, $duration = null, $end = null, $release = null)
    {
        $this
            ->setStartDateWindow($startDateWindow)
            ->setDateWindowRange($dateWindowRange)
            ->setEndDateWindow($endDateWindow)
            ->setStart($start)
            ->setDuration($duration)
            ->setEnd($end)
            ->setRelease($release);
    }
    /**
     * Get StartDateWindow value
     * @return \StructType\StartDateWindow|null
     */
    public function getStartDateWindow()
    {
        return $this->StartDateWindow;
    }
    /**
     * Set StartDateWindow value
     * @param \StructType\StartDateWindow $startDateWindow
     * @return \StructType\DateTimeSpanType
     */
    public function setStartDateWindow(\StructType\StartDateWindow $startDateWindow = null)
    {
        $this->StartDateWindow = $startDateWindow;
        return $this;
    }
    /**
     * Get DateWindowRange value
     * @return \StructType\TimeInstantType|null
     */
    public function getDateWindowRange()
    {
        return $this->DateWindowRange;
    }
    /**
     * Set DateWindowRange value
     * @param \StructType\TimeInstantType $dateWindowRange
     * @return \StructType\DateTimeSpanType
     */
    public function setDateWindowRange(\StructType\TimeInstantType $dateWindowRange = null)
    {
        $this->DateWindowRange = $dateWindowRange;
        return $this;
    }
    /**
     * Get EndDateWindow value
     * @return \StructType\EndDateWindow|null
     */
    public function getEndDateWindow()
    {
        return $this->EndDateWindow;
    }
    /**
     * Set EndDateWindow value
     * @param \StructType\EndDateWindow $endDateWindow
     * @return \StructType\DateTimeSpanType
     */
    public function setEndDateWindow(\StructType\EndDateWindow $endDateWindow = null)
    {
        $this->EndDateWindow = $endDateWindow;
        return $this;
    }
    /**
     * Get Start value
     * @return string|null
     */
    public function getStart()
    {
        return $this->Start;
    }
    /**
     * Set Start value
     * @param string $start
     * @return \StructType\DateTimeSpanType
     */
    public function setStart($start = null)
    {
        // validation for constraint: string
        if (!is_null($start) && !is_string($start)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($start)), __LINE__);
        }
        $this->Start = $start;
        return $this;
    }
    /**
     * Get Duration value
     * @return string|null
     */
    public function getDuration()
    {
        return $this->Duration;
    }
    /**
     * Set Duration value
     * @param string $duration
     * @return \StructType\DateTimeSpanType
     */
    public function setDuration($duration = null)
    {
        // validation for constraint: string
        if (!is_null($duration) && !is_string($duration)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($duration)), __LINE__);
        }
        $this->Duration = $duration;
        return $this;
    }
    /**
     * Get End value
     * @return string|null
     */
    public function getEnd()
    {
        return $this->End;
    }
    /**
     * Set End value
     * @param string $end
     * @return \StructType\DateTimeSpanType
     */
    public function setEnd($end = null)
    {
        // validation for constraint: string
        if (!is_null($end) && !is_string($end)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($end)), __LINE__);
        }
        $this->End = $end;
        return $this;
    }
    /**
     * Get Release value
     * @return string|null
     */
    public function getRelease()
    {
        return $this->Release;
    }
    /**
     * Set Release value
     * @param string $release
     * @return \StructType\DateTimeSpanType
     */
    public function setRelease($release = null)
    {
        // validation for constraint: string
        if (!is_null($release) && !is_string($release)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($release)), __LINE__);
        }
        $this->Release = $release;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\DateTimeSpanType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
